{type:"class",attributes:{"name":"Element","packageName":"qx.html","superClass":"qx.core.Object","childClasses":"qx.html.Canvas,qx.html.Iframe,qx.html.Image,qx.html.Input,qx.html.Label,qx.html.Root","fullName":"qx.html.Element","type":"class"},children:[{type:"desc",attributes:{"text":"<p>High-performance, high-level <span class=\"caps\">DOM</span> element creation and managment.</p>\n\n<p>Includes support for <span class=\"caps\">HTML</span> and style attributes. Elements also have\ngot a powerful children and visibility managment.</p>\n\n<p>Processes <span class=\"caps\">DOM</span> insertion and modification with a advanced logic\nto reduce the real transactions.</p>\n\n<p>From the view of the parent you can use the following children managment\nmethods:\n{@link #getChildren}, {@link #indexOf}, {@link #hasChild}, {@link #add},\n{@link #addAt}, {@link #remove}, {@link #removeAt}, {@link #removeAll}</p>\n\n<p>Each child itself also has got some powerful methods to control its\nposition:\n{@link #getParent}, {@link #free},\n{@link #insertInto}, {@link #insertBefore}, {@link #insertAfter},\n{@link #moveTo}, {@link #moveBefore}, {@link #moveAfter},</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"\"div\"","name":"tagName"},children:[{type:"desc",attributes:{"text":"<p>Tag name of the element to create</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a new Element</p>"}}]}]},{type:"methods-static",children:[{type:"method",attributes:{"access":"protected","isStatic":"true","name":"_mshtmlVisibilitySort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"a"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element 1</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"b"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element 2</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sorts elements by their cascading level</p>"}}]},{type:"method",attributes:{"access":"protected","isStatic":"true","name":"_scheduleFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"job"},children:[{type:"desc",attributes:{"text":"<p>The job descriptor. Should always be <code>&#8220;element&#8221;</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Schedule a deferred element queue flush. If the widget subsystem is used\nthis method gets overwritten by {@link qx.ui.core.queue.Manager}.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"flush"},children:[{type:"desc",attributes:{"text":"<p>Flush the global modified list</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"type":"Boolean","name":"DEBUG","value":"false"},children:[{type:"desc",attributes:{"text":"<p>If debugging should be enabled</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__addChildHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the element to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal helper for all children addition needs</p>"}}]},{type:"method",attributes:{"access":"private","name":"__flush"},children:[{type:"desc",attributes:{"text":"<p>Syncs data of an HtmlElement object to the <span class=\"caps\">DOM</span>.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__generateListenerId"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Name of the event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"listener"},children:[{type:"desc",attributes:{"text":"<p>Function to execute on event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"self"},children:[{type:"desc",attributes:{"text":"<p>Execution context of given function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Whether capturing should be enabled</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Generates a unique key for a listener configuration</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A unique ID for this configuration</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__moveChildHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the moved element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal helper for all children move needs</p>"}}]},{type:"method",attributes:{"access":"private","name":"__performAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"action"},children:[{type:"desc",attributes:{"text":"<p>action to queue</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Takes the action to process as argument and queues this action if the\nunderlying <span class=\"caps\">DOM</span> element is not yet created.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__removeChildHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the removed element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal helper for all children removal needs</p>"}}]},{type:"method",attributes:{"access":"private","name":"__willBeSeeable"},children:[{type:"desc",attributes:{"text":"<p>Walk up the internal children hierarchy and\nlook if one of the children is marked as root.</p>\n\n<p>This method is quite performance hungry as it\nreally walks up recursively.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_applyProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>Unique property identifier</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Any valid value (depends on the property)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies a special property with the given value.</p>\n\n<p>This property apply routine can be easily overwritten and\nextended by sub classes to add new low level features which\nare not easily possible using styles and attributes.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_copyData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromMarkup"},children:[{type:"desc",attributes:{"text":"<p>Whether the copy should respect styles\n  given from markup</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Copies data between the internal representation and the <span class=\"caps\">DOM</span>. This\nsimply copies all the data and only works well directly after\nelement creation. After this the data must be synced using {@link #_syncData}</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_createDomElement"},children:[{type:"desc",attributes:{"text":"<p>Internal helper to generate the <span class=\"caps\">DOM</span> element</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_getProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>name of the misc</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get the value of the given misc.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the value of the misc</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_insertChildren"},children:[{type:"desc",attributes:{"text":"<p>Append all child nodes to the <span class=\"caps\">DOM</span>\nelement. This function is used when the element is initially\ncreated. After this initial apply {@link #_syncChildren} is used\ninstead.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_removeProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>the name of the misc</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the value should be removed\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given misc</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_scheduleChildrenUpdate"},children:[{type:"desc",attributes:{"text":"<p>Add the element to the global modification list.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_setProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>the name of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>the value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the value should be applied\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set up the given property.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_syncChildren"},children:[{type:"desc",attributes:{"text":"<p>Syncronize internal children hierarchy to the <span class=\"caps\">DOM</span>. This is used\nfor further runtime updates after the element has been created\ninitially.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_syncData"},children:[{type:"desc",attributes:{"text":"<p>Syncronizes data between the internal representation and the <span class=\"caps\">DOM</span>. This\nis the counterpart of {@link #_copyData} and is used for further updates\nafter the element has been created.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"activate"},children:[{type:"desc",attributes:{"text":"<p>Mark this element to get activated on the next flush of the queue</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>elements to insert</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element..."}}]}]}]},{type:"desc",attributes:{"text":"<p>Append all given children at the end of this element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"addAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the element to insert</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]},{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index (starts at 0 for the\n    first child) to insert (the index of the following\n    children will be increased by one)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Inserts a new element into this element at the given position.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"addListener"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Name of the event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"listener"},children:[{type:"desc",attributes:{"text":"<p>Function to execute on event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"self"},children:[{type:"desc",attributes:{"text":"<p>Execution context of given function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Whether capturing should be enabled</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds an event listener to the element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>An opaque id, which can be used to remove the event listener\n        using the {@link #removeListenerById} method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"blur"},children:[{type:"desc",attributes:{"text":"<p>Mark this element to get blurred on the next flush of the queue</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Captures all mouse events to this element</p>"}}]},{type:"method",attributes:{"name":"clearSelection"},children:[{type:"desc",attributes:{"text":"<p>Clears the selection of the element.</p>\n\n<p>This method only works if the underlying <span class=\"caps\">DOM</span> element is already created.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"deactivate"},children:[{type:"desc",attributes:{"text":"<p>Mark this element to get deactivated on the next flush of the queue</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"exclude"},children:[{type:"desc",attributes:{"text":"<p>Marks the element as excluded which means it will be removed\nfrom the <span class=\"caps\">DOM</span> and ignored for updates until it gets included again.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"focus"},children:[{type:"desc",attributes:{"text":"<p>Focus this element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, the\nfocus is queued for processing after the element creation.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"free"},children:[{type:"desc",attributes:{"text":"<p>Remove self from the current parent.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"getAllStyles"},children:[{type:"desc",attributes:{"text":"<p>Returns a map of all styles. Do not modify the result map!</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>All styles or <code>null</code> when none are configured.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getAttribute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>name of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get the value of the given attribute.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the value of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>child index</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get a child element at the given index</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The child element or <code>null</code> if\n    no child is found at that index.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns a copy of the internal children structure.</p>\n\n<p>Please do not modify the array in place. If you need\nto work with the data in such a way make yourself\na copy of the data first.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the children list</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"name":"getDomElement"},children:[{type:"desc",attributes:{"text":"<p>Returns the <span class=\"caps\">DOM</span> element (if created). Please use this with caution.\nIt is better to make all changes to the object itself using the public\n<span class=\"caps\">API</span> rather than to the underlying <span class=\"caps\">DOM</span> element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> element node</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"name":"getNodeName"},children:[{type:"desc",attributes:{"text":"<p>Returns the nodeName of the <span class=\"caps\">DOM</span> element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The node name</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getParent"},children:[{type:"desc",attributes:{"text":"<p>Returns the parent of this element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The parent of this element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getScrollX"},children:[{type:"desc",attributes:{"text":"<p>Get the horizontal scroll position.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Horizontal scroll position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getScrollY"},children:[{type:"desc",attributes:{"text":"<p>Get the vertical scroll position.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Vertical scroll position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getSelection"},children:[{type:"desc",attributes:{"text":"<p>Get the selection of the element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, this methods returns\na null value.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"String"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getSelectionLength"},children:[{type:"desc",attributes:{"text":"<p>Get the length of selection of the element.</p>\n\n<p>If the underlaying <span class=\"caps\">DOM</span> element is not yet created, this methods returns\na null value.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>name of the style attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get the value of the given style attribute.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the value of the style attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"hasChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the child</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given element is a child of this element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the given\n   element is a child of this element.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"hasChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the element has any child nodes</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the element has any child nodes</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"hasListener"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>name of the event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Whether to check for listeners of\n        the bubbling or of the capturing phase.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Check if there are one or more listeners for an event type.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the object has a listener of the given type.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"hide"},children:[{type:"desc",attributes:{"text":"<p>Marks the element as hidden which means it will kept in <span class=\"caps\">DOM</span> (if it\nis already there, but configured hidden using a <span class=\"caps\">CSS</span> style of display=none).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"include"},children:[{type:"desc",attributes:{"text":"<p>Marks the element as included which means it will be moved into\nthe <span class=\"caps\">DOM</span> again and synced with the internal data representation.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"indexOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the child</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Find the position of the given child</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>returns the position. If the element\n    is not a child <code>-1</code> will be returned.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"insertAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rel"},children:[{type:"desc",attributes:{"text":"<p>the related element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Insert self after the given (related) element</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"insertBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rel"},children:[{type:"desc",attributes:{"text":"<p>the related element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Insert self before the given (related) element</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"insertInto"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"},children:[{type:"desc",attributes:{"text":"<p>The new parent of this element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"index"},children:[{type:"desc",attributes:{"text":"<p>Optional position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Insert self into the given parent. Normally appends self to the end,\nbut optionally a position can be defined. With index <code>0</code> it\nwill be inserted at the begin.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"isFocusable"},children:[{type:"desc",attributes:{"text":"<p>Whether the element is focusable (or will be when created)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the element is focusable."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isIncluded"},children:[{type:"desc",attributes:{"text":"<p>Whether the element is part of the <span class=\"caps\">DOM</span></p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the element is part of the <span class=\"caps\">DOM</span>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isNativelyFocusable"},children:[{type:"desc",attributes:{"text":"<p>Whether the element is natively focusable (or will be when created)</p>\n\n<p>This ignores the configured tabIndex.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the element is focusable."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isVisible"},children:[{type:"desc",attributes:{"text":"<p>Whether the element is visible.</p>\n\n<p>Please note: This does not control the visibility or parent inclusion recursively.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the element is configured\n  to be visible.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"moveAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rel"},children:[{type:"desc",attributes:{"text":"<p>the related child</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Move self after the given (related) child.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"moveBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rel"},children:[{type:"desc",attributes:{"text":"<p>the related child</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Move self before the given (related) child.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"moveTo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index (starts at 0 for the first child)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Move self to the given index in the current parent.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"releaseCapture"},children:[{type:"desc",attributes:{"text":"<p>Releases this element from a previous {@link #capture} call</p>"}}]},{type:"method",attributes:{"name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"childs"},children:[{type:"desc",attributes:{"text":"<p>children to remove</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element..."}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes all given children</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"removeAll"},children:[{type:"desc",attributes:{"text":"<p>Remove all children from this element.</p>"}},{type:"return"}]},{type:"method",attributes:{"name":"removeAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the position of the\n    child (starts at 0 for the first child)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the child at the given index</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"removeAttribute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>the name of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the value should be removed\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given attribute</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"removeListener"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Name of the event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"listener"},children:[{type:"desc",attributes:{"text":"<p>Function to execute on event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"self"},children:[{type:"desc",attributes:{"text":"<p>Execution context of given function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Whether capturing should be enabled</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes an event listener from the element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"removeListenerById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>The id returned by {@link #addListener}</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes an event listener from an event target by an id returned by\n{@link #addListener}</p>"}}]},{type:"method",attributes:{"name":"removeStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>the name of the style attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the value should be removed\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given style attribute</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"scrollChildIntoViewX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"elem"},children:[{type:"desc",attributes:{"text":"<p>The element to scroll into the viewport.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"align"},children:[{type:"desc",attributes:{"text":"<p>Alignment of the element. Allowed values:\n  <code>left</code> or <code>right</code>. Could also be null.\n  Without a given alignment the method tries to scroll the widget\n  with the minimum effort needed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the execution should be made\n  directly when possible</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the given child element into view. Only scrolls children.\nDo not influence elements on top of this element.</p>\n\n<p>If the element is currently invisible it gets scrolled automatically\nat the next time it is visible again (queued).</p>"}}]},{type:"method",attributes:{"name":"scrollChildIntoViewY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"elem"},children:[{type:"desc",attributes:{"text":"<p>The element to scroll into the viewport.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"align"},children:[{type:"desc",attributes:{"text":"<p>Alignment of the element. Allowed values:\n  <code>top</code> or <code>bottom</code>. Could also be null.\n  Without a given alignment the method tries to scroll the widget\n  with the minimum effort needed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the execution should be made\n  directly when possible</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the given child element into view. Only scrolls children.\nDo not influence elements on top of this element.</p>\n\n<p>If the element is currently invisible it gets scrolled automatically\nat the next time it is visible again (queued).</p>"}}]},{type:"method",attributes:{"name":"scrollToX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"x"},children:[{type:"desc",attributes:{"text":"<p>Horizontal scroll position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"lazy"},children:[{type:"desc",attributes:{"text":"<p>Whether the scrolling should be performed\n   during element flush.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the element to the given left position.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"scrollToY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"y"},children:[{type:"desc",attributes:{"text":"<p>Vertical scroll position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"lazy"},children:[{type:"desc",attributes:{"text":"<p>Whether the scrolling should be performed\n   during element flush.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls the element to the given top position.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setAttribute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>the name of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>the value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the value should be applied\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set up the given attribute</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"setAttributes"},children:[{type:"params",children:[{type:"param",attributes:{"name":"map"},children:[{type:"desc",attributes:{"text":"<p>a map where the key is the name of the property\n   and the value is the value to use.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the values should be applied\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Convenience method to modify a set of attributes at once.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"setNodeName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>The node name</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the nodeName of the <span class=\"caps\">DOM</span> element.</p>"}}]},{type:"method",attributes:{"name":"setRoot"},children:[{type:"params",children:[{type:"param",attributes:{"name":"root"},children:[{type:"desc",attributes:{"text":"<p>The root flag.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the element&#8217;s root flag, which indicates\nwhether the element should be a root element or not.</p>"}}]},{type:"method",attributes:{"name":"setSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"start"},children:[{type:"desc",attributes:{"text":"<p>start of the selection (zero based)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"end"},children:[{type:"desc",attributes:{"text":"<p>end of the selection</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set the selection of the element with the given start and end value.\nIf no end value is passed the selection will extend to the end.</p>\n\n<p>This method only works if the underlying <span class=\"caps\">DOM</span> element is already created.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"},children:[{type:"desc",attributes:{"text":"<p>the name of the style attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>the value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the value should be applied\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set up the given style attribute</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"setStyles"},children:[{type:"params",children:[{type:"param",attributes:{"name":"map"},children:[{type:"desc",attributes:{"text":"<p>a map where the key is the name of the property\n   and the value is the value to use.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"direct"},children:[{type:"desc",attributes:{"text":"<p>Whether the values should be applied\n   directly (without queuing)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Convenience method to modify a set of styles at once.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"show"},children:[{type:"desc",attributes:{"text":"<p>Marks the element as visible which means that a previously applied\n<span class=\"caps\">CSS</span> style of display=none gets removed and the element will inserted\ninto the <span class=\"caps\">DOM</span>, when this had not already happened before.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>this object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"name":"useElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"elem"},children:[{type:"desc",attributes:{"text":"<p>Element to reuse</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Uses an existing element instead of creating one. This may be interesting\nwhen the <span class=\"caps\">DOM</span> element is directly needed to add content etc.</p>"}}]},{type:"method",attributes:{"name":"useMarkup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"html"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">HTML</span> markup with one root element\n  which is used as the main element for this instance.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Uses existing markup for this element. This is mainly used\nto insert pre-built markup blocks into the element hierarchy.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The created <span class=\"caps\">DOM</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]}]}]}