{type:"class",attributes:{"name":"Mouse","packageName":"qx.event.handler","superClass":"qx.core.Object","fullName":"qx.event.handler.Mouse","type":"class","interfaces":"qx.event.IEventHandler"},children:[{type:"desc",attributes:{"text":"<p>This class provides a unified mouse event handler for Internet Explorer,\nFirefox, Opera and Safari</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"manager"},children:[{type:"desc",attributes:{"text":"<p>Event manager for the window to use</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.Manager"}}]}]}]},{type:"desc",attributes:{"text":"<p>Create a new instance</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"PRIORITY"},children:[{type:"desc",attributes:{"text":"<p>Priority of this handler</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"constant",attributes:{"name":"TARGET_CHECK"},children:[{type:"desc",attributes:{"text":"<p>Which target check to use</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"constant",attributes:{"type":"Boolean","name":"IGNORE_CAN_HANDLE","value":"true"},children:[{type:"desc",attributes:{"text":"<p>Whether the method &#8220;canHandleEvent&#8221; must be called</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"constant",attributes:{"name":"SUPPORTED_TYPES"},children:[{type:"desc",attributes:{"text":"<p>Supported event types</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__differentTargetClickFixPost"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p>original <span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>event target of the <span class=\"caps\">DOM</span> event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Elment"}}]}]}]},{type:"desc",attributes:{"text":"<p>If the mouseup event happens on a different target than the corresponding\nmousedown event the internet explorer dispatches a click event on the\nfirst common ancestor of both targets. The presence of this click event\nis essential for the qooxdoo widget system. All other browsers don&#8217;t fire\nthe click event so it must be emulated.</p>"}}]},{type:"method",attributes:{"access":"private","name":"__doubleClickFixPre"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p>original <span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>event target of the <span class=\"caps\">DOM</span> event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Elment"}}]}]}]},{type:"desc",attributes:{"text":"<p>Normalizes the click sequence of double click event in the Internet\nExplorer. The normalized sequence is:</p>\n\n<p>1. mousedown\n 2. mouseup\n 3. click\n 4. mousedown  <- not fired by IE\n 5. mouseup\n 6. click  <- not fired by IE\n 7. dblclick</p>"}}]},{type:"method",attributes:{"access":"private","name":"__fireEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>type og the event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>event target</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Fire a mouse event with the given parameters</p>"}}]},{type:"method",attributes:{"access":"private","name":"__rightClickFixPost"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p>original <span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>event target of the <span class=\"caps\">DOM</span> event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Elment"}}]}]}]},{type:"desc",attributes:{"text":"<p>Normalizes the click sequence of right click events in Webkit and Opera.\nThe normalized sequence is:</p>\n\n<p>1. mousedown  <- not fired by Webkit\n 2. mouseup  <- not fired by Webkit\n 3. contextmenu <- not fired by Opera</p>\n\n<p><span class=\"caps\">TODO</span>: Just curious. Where is the webkit version? is the\ndocumentation up-to-date?</p>"}}]},{type:"method",attributes:{"access":"private","name":"__rightClickFixPre"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p>original <span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>event target of the <span class=\"caps\">DOM</span> event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Elment"}}]}]}]},{type:"desc",attributes:{"text":"<p>Normalizes the click sequence of right click events in Webkit and Opera.\nThe normalized sequence is:</p>\n\n<p>1. mousedown  <- not fired by Webkit\n 2. mouseup  <- not fired by Webkit\n 3. contextmenu <- not fired by Opera</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_initButtonObserver"},children:[{type:"desc",attributes:{"text":"<p>Initializes the native mouse button event listeners.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_initMoveObserver"},children:[{type:"desc",attributes:{"text":"<p>Initializes the native mouse move event listeners.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_initWheelObserver"},children:[{type:"desc",attributes:{"text":"<p>Initializes the native mouse wheel event listeners.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onButtonEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Global handler for all mouse button related events like &#8220;mouseup&#8221;,\n&#8220;mousedown&#8221;, &#8220;click&#8221;, &#8220;dblclick&#8221; and &#8220;contextmenu&#8221;.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMoveEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Global handler for all mouse move related events like &#8220;mousemove&#8221;,\n&#8220;mouseout&#8221; and &#8220;mouseover&#8221;.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onWheelEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Global handler for the mouse wheel event.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_stopButtonObserver"},children:[{type:"desc",attributes:{"text":"<p>Disconnects the native mouse button event listeners.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_stopMoveObserver"},children:[{type:"desc",attributes:{"text":"<p>Disconnects the native mouse move event listeners.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_stopWheelObserver"},children:[{type:"desc",attributes:{"text":"<p>Disconnects the native mouse wheel event listeners.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.event.IEventHandler","name":"canHandleEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"}},{type:"param",attributes:{"name":"type"}}]}]},{type:"method",attributes:{"docFrom":"qx.event.IEventHandler","name":"registerEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"}},{type:"param",attributes:{"name":"type"}},{type:"param",attributes:{"name":"capture"}}]}]},{type:"method",attributes:{"docFrom":"qx.event.IEventHandler","name":"unregisterEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"}},{type:"param",attributes:{"name":"type"}},{type:"param",attributes:{"name":"capture"}}]}]}]}]}