{type:"class",attributes:{"isStatic":"true","name":"SingleValueBinding","packageName":"qx.data","fullName":"qx.data.SingleValueBinding","type":"class"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">EXPERIMENTAL</span>!!!</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"access":"private","isStatic":"true","name":"__bindEventToProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The source of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"sourceEvent"},children:[{type:"desc",attributes:{"text":"<p>The event of the source object which could \n  be the change event in common but has to be an \n  {@link qx.event.type.Data} event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"targetObject"},children:[{type:"desc",attributes:{"text":"<p>The object which the source should \n  be bind to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"targetProperty"},children:[{type:"desc",attributes:{"text":"<p>The property name of the target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>A map containing the options. See \n  {@link #bindEventToProperty} for more information.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal helper method which is actually doing all bindings. That means \nthat an event listener will be added to the source object which listens \nto the given event and invokes an set on the target property on the \ntargetObject.\nThis method does not store the binding in the internal reference store \nso it should <span class=\"caps\">NOT</span> be used from outside this class. For an outside usage, \nuse {@link #bindEventToProperty}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns the internal id for that binding. This can be used \n  for referencing the binding or e.g. for removing. This is not an atomic \n  id so you can&#8217;t you use it as a hash-map index. It&#8217;s the id which will\n  be returned b< the {@link qx.core.Object#addListener} method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__bindPropertyToProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The source of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"sourceProperty"},children:[{type:"desc",attributes:{"text":"<p>The source property of the source object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"targetObject"},children:[{type:"desc",attributes:{"text":"<p>The object which the source should \n  be bind to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"targetProperty"},children:[{type:"desc",attributes:{"text":"<p>The property name of the target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>A map containing the options. See \n  {@link #bindEventToProperty} for more information.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal helper method which evaluates the change event name and \ndelegates the creation of the binding to the \n{@link #__bindEventToProperty} method. This method does not store the \nbinding in the internal reference store so it should <span class=\"caps\">NOT</span> be used from \noutside this class. For an outside usage, use \n{@link #bindPropertyToProperty}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns the internal id for that binding. This can be used \n  for referencing the binding or e.g. for removing. This is not an atomic \n  id so you can&#8217;t you use it as a hash-map index. It&#8217;s the id which will\n  be returned b< the {@link qx.core.Object#addListener} method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__convertValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The value which possibly should be converted.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"targetObject"},children:[{type:"desc",attributes:{"text":"<p>The target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"targetProperty"},children:[{type:"desc",attributes:{"text":"<p>The property name of the target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>The options map which can includes the converter.\n  For a detailed information on the map, take a look at \n  {@link #bindEventToProperty}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method takes the given value, checks if the user has given a \nconverter and converts the value to its target type. If no converter is \ngiven by the user, the {@link #__defaultConvertion} will try to convert\nthe value.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The converted value. If no conversion has been done, the\n  value property will be returned.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__defaultConvertion"},children:[{type:"params",children:[{type:"param",attributes:{"name":"data"},children:[{type:"desc",attributes:{"text":"<p>The data to convert.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"targetCheck"},children:[{type:"desc",attributes:{"text":"<p>The value of the check property. That usually\n  contains the target type.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Tries to convert the data to the type given in the targetCheck argument.</p>"}}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__getEventForProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The object to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"sourceProperty"},children:[{type:"desc",attributes:{"text":"<p>The name of the property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Helper method which tries to figure out if the given property on the \ngiven object does have a change event and if returns the name of it.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The name of the change event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__storeBinding"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>The listener id of the id for a deeper bingin.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]},{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The source Object of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"sourceEvent"},children:[{type:"desc",attributes:{"text":"<p>The name of the source event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"targetObject"},children:[{type:"desc",attributes:{"text":"<p>The target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"targetProperty"},children:[{type:"desc",attributes:{"text":"<p>The name of the property on the target \n  object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method stores the given value as a binding in the internal structure\nof all bindings.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"bind"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The source of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"sourcePropertyChain"},children:[{type:"desc",attributes:{"text":"<p>The property chain which represents \n  the source property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"targetObject"},children:[{type:"desc",attributes:{"text":"<p>The object which the source should \n  be bind to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"targetProperty"},children:[{type:"desc",attributes:{"text":"<p>The property name of the target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>A map containing the options. See \n  {@link #bindEventToProperty} for more information.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>The function is responsible for binding a source objects property to \na target objects property. Both properties have to have the usual qooxdoo \ngetter and setter. The source property also needs to fire change-events\non every change of its value.\nPlease keep in mind, that this binding is unidirectional. If you need\na binding in both directions, you have to use two of this bindings.</p>\n\n<p>It&#8217;s also possible to bind some hind of a hierarchy as a source. This \nmeans that you can separate the source properties with a dot and bind \nby that the object referenced to this property chain.\nExample with an object &#8216;a&#8217; which has object &#8216;b&#8217; stored in its &#8216;child&#8217; \nproperty. Object b has a string property named abc:\n<code>\nqx.data.SingleValueBinding.bind(a, &#8220;child.abc&#8221;, textfield, &#8220;value&#8221;);\n</code></p>\n\n<p>As you can see in this example, the abc property of a&#8217;s b will be bound \nto the textfield. If now the value of b changed or even the a will get a \nnew b, the binding still shows the right value.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns the internal id for that binding. This can be used \n  for referencing the binding or e.g. for removing. This is not an atomic \n  id so you can&#8217;t you use it as a hash-map index.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"bindEventToProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The source of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"sourceEvent"},children:[{type:"desc",attributes:{"text":"<p>The event of the source object which chould \n  be the change event in common but has to be an \n  {@link qx.event.type.Data} event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"targetObject"},children:[{type:"desc",attributes:{"text":"<p>The object which the source should \n  be bind to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"targetProperty"},children:[{type:"desc",attributes:{"text":"<p>The property name of the target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>A map containing the options. \n  <li>converter: A converter function which takes one parameter \n      (the value) and should return the converted value. If no conversion\n      has been done, the given value should be returned.</li>\n  <li>onSetOk: A callback function can be given here. This method will be \n      called if the set of the value was successful.</li>\n  <li>onSetFail: A callback function can be given here. This method will \n      be called if the set of the value fails.</li></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>The method binds a {@link qx.event.type.Data} event to a target property.\nThis could be necessary for &#8220;properties&#8221; in the framework which \nare no real properties but do fire an change event. The change event <span class=\"caps\">HAS</span> \nto be a data event!\nRemember that this binding is one way only!\nthe common way of binding is to bind one property to another or a \nproperty chain to another property. To do that, take the {@link #bind}\nmethod.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns the internal id for that binding. This can be used \n  for referencing the binding or e.g. for removing. This is not an atomic \n  id so you can&#8217;t you use it as a hash-map index. It&#8217;s the id which will\n  be returned b< the {@link qx.core.Object#addListener} method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"bindPropertyToProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The source of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"sourceProperty"},children:[{type:"desc",attributes:{"text":"<p>The source property of the source object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"targetObject"},children:[{type:"desc",attributes:{"text":"<p>The object which the source should \n  be bind to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"targetProperty"},children:[{type:"desc",attributes:{"text":"<p>The property name of the target object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>A map containing the options. See \n  {@link #bindEventToProperty} for more information.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method binds a source property to a target property. The source \nproperty needs to be an qooxdoo property and has to have an changeEvent\nfired on every change. The change Event has to be an \n{@link qx.event.type.Data} event.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns the internal id for that binding. This can be used \n  for referencing the binding or e.g. for removing. This is not an atomic \n  id so you can&#8217;t you use it as a hash-map index. It&#8217;s the id which will\n  be returned b< the {@link qx.core.Object#addListener} method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getAllBindings"},children:[{type:"desc",attributes:{"text":"<p>Returns a map containing for every bound object an array of data binding \ninformation. The key of the map is the hashcode of the bound objects.\nEvery binding is represented by an array containing id, sourceObject, \nsourceEvent, targetObject and targetProperty.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map containing all bindings.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getAllBindingsForObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>The object of which the bindings should \n  be returned.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns an array which lists all bindings.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>An array of binding informations. Every binding \n  information is an array itself containing id, sourceObject, sourceEvent,\n  targetObject and targetProperty in that order.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"removeAllBindings"},children:[{type:"desc",attributes:{"text":"<p>Removes all binding in the whole application. After that not a single\nbinding is left.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"removeAllBindingsForObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>The object of which the bindings should be\n  removed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes all bindings for the given object.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"removeBindingFromObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sourceObject"},children:[{type:"desc",attributes:{"text":"<p>The source object of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]},{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>The id of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the binding with the given id from the given sourceObject. The \nid hast to be the id returned by any of the bind functions.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"showAllBindingsInLog"},children:[{type:"desc",attributes:{"text":"<p>Debug function which shows all bindings in the log console. To get only \none binding in the console use {@link #showBindingInLog}</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"showBindingInLog"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"},children:[{type:"desc",attributes:{"text":"<p>the source of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"x.core.Object"}}]}]},{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>The id of the binding.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"id"}}]}]}]},{type:"desc",attributes:{"text":"<p>Debug function which shows some valuable information about the given \nbinding in console. For that it uses {@link qx.log.Logger}.</p>"}}]}]}]}