{type:"class",attributes:{"isStatic":"true","name":"ObjectRegistry","packageName":"qx.core","fullName":"qx.core.ObjectRegistry","type":"bootstrap"},children:[{type:"desc",attributes:{"text":"<p>Registration for all instances of qooxdoo classes. Mainly\nused to manage them for the final shutdown sequence and to\nuse weak references when connecting widgets to <span class=\"caps\">DOM</span> nodes etc.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"fromHashCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"hash"},children:[{type:"desc",attributes:{"text":"<p>The object&#8217;s hash code.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get a object instance by its hash code as returned by {@link #toHashCode}.\nIf the object is already disposed or the hashCode is invalid,\n<code>null</code> is returned.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The corresponding object or <code>null</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getRegistry"},children:[{type:"desc",attributes:{"text":"<p>Returns the object registry.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The registry</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"register"},children:[{type:"params",children:[{type:"param",attributes:{"name":"obj"},children:[{type:"desc",attributes:{"text":"<p>Any object with a dispose() method</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Registers an object into the database. This adds a hashcode\nto the object (if not already done before) and stores it under\nthis hashcode. You can access this object later using the hashcode\nby calling {@link #fromHashCode}.</p>\n\n<p>All registered objects are automatically disposed on application\nshutdown. Each registered object must at least have a method\ncalled <code>dispose</code>.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"shutdown"},children:[{type:"desc",attributes:{"text":"<p>Disposing all registered object and cleaning up registry. This is\nautomatically executed at application shutdown.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"toHashCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"obj"},children:[{type:"desc",attributes:{"text":"<p>the Object to get the hashcode for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns an unique identifier for the given object. If such an identifier\ndoes not yet exist, create it.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>unique identifier for the given object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"unregister"},children:[{type:"params",children:[{type:"param",attributes:{"name":"obj"},children:[{type:"desc",attributes:{"text":"<p>Any previously registered object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given object from the database.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}