{type:"class",attributes:{"isStatic":"true","name":"BoxSizing","packageName":"qx.bom.element","fullName":"qx.bom.element.BoxSizing","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Contains methods to control and query the element&#8217;s box-sizing property.</p>\n\n<p>Supported values:</p>\n\n<ul>\n<li>&#8220;content-box&#8221; = W3C model (dimensions are content specific)</li>\n<li>&#8220;border-box&#8221; = Microsoft model (dimensions are box specific incl. border and padding)</li>\n</ul>"}},{type:"methods-static",children:[{type:"method",attributes:{"access":"private","isStatic":"true","name":"__usesNativeBorderBox"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given elements defaults to the &#8220;border-box&#8221; Microsoft model in all cases.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>true when the element uses &#8220;border-box&#8221; independently from the doctype</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"compile"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Valid <span class=\"caps\">CSS</span> box-sizing value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Compiles the given box sizing into a <span class=\"caps\">CSS</span> compatible string.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">CSS</span> string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The element to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the box sizing for the given element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Box sizing value of the given element.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"reset"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The element to modify</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the local box sizing applied to the element</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"set"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The element to modify</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New box sizing value to set</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies a new box sizing to the given element</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}