{type:"class",attributes:{"isStatic":"true","name":"Attribute","packageName":"qx.bom.element","fullName":"qx.bom.element.Attribute","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Attribute/Property handling for <span class=\"caps\">DOM</span> <span class=\"caps\">HTML</span> elements.</p>\n\n<p>Also includes support for <span class=\"caps\">HTML</span> properties like <code>checked</code>\nor <code>value</code>. This feature set is supported cross-browser\nthrough one common interface and is independent of the differences between\nthe multiple implementations.</p>\n\n<p>Supports applying text and <span class=\"caps\">HTML</span> content using the attribute names\n<code>text</code> and <code>html</code>.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"compile"},children:[{type:"params",children:[{type:"param",attributes:{"name":"map"},children:[{type:"desc",attributes:{"text":"<p>Map of attributes. The key is the name of the attribute.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Compiles an incoming attribute map to a string which\ncould be used when building <span class=\"caps\">HTML</span> blocks using innerHTML.</p>\n\n<p>This method silently ignores runtime attributes like\n<code>html</code> or <code>text</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns a compiled string ready for usage.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> element to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>Name of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the value of the given <span class=\"caps\">HTML</span> attribute</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>New value of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"reset"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> element to modify</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>Name of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Resets an <span class=\"caps\">HTML</span> attribute on the given <span class=\"caps\">DOM</span> element</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"set"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> element to modify</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>Name of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value of the attribute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets an <span class=\"caps\">HTML</span> attribute on the given <span class=\"caps\">DOM</span> element</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}