{type:"class",attributes:{"name":"Font","packageName":"qx.bom","superClass":"qx.core.Object","fullName":"qx.bom.Font","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A wrapper for <span class=\"caps\">CSS</span> font styles. Fond objects can be aplpied to instances\nof {@link qx.html.Element}.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"size"},children:[{type:"desc",attributes:{"text":"<p>The font size (Unit: pixel)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"family"},children:[{type:"desc",attributes:{"text":"<p>A sorted list of font families</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String","dimensions":"1"}}]}]}]}]}]},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"fromConfig"},children:[{type:"params",children:[{type:"param",attributes:{"name":"config"},children:[{type:"desc",attributes:{"text":"<p>map of property values</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Converts a map property definition into a border object.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the created instance</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.bom.Font"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"fromString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">CSS</span> string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Converts a typical <span class=\"caps\">CSS</span> font definition string to an font object</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the created instance</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.bom.Font"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getDefaultStyles"},children:[{type:"desc",attributes:{"text":"<p>Returns a map of all properties in empty state.</p>\n\n<p>This is useful for resetting previously configured\nfont styles.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Default styles</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.bom.Font#bold","name":"_applyBold"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyBold}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.bom.Font#decoration","name":"_applyDecoration"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>decoration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDecoration}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.bom.Font#family","name":"_applyFamily"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>family</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyFamily}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.bom.Font#italic","name":"_applyItalic"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyItalic}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.bom.Font#lineHeight","name":"_applyLineHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>lineHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyLineHeight}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.bom.Font#size","name":"_applySize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySize}.</p>"}}]},{type:"method",attributes:{"name":"getBold","fromProperty":"bold"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>bold</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getDecoration","fromProperty":"decoration"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>decoration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>decoration</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getFamily","fromProperty":"family"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>family</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>family</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getItalic","fromProperty":"italic"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>italic</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getLineHeight","fromProperty":"lineHeight"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>lineHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>lineHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSize","fromProperty":"size"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>size</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getStyles"},children:[{type:"desc",attributes:{"text":"<p>Get a map of all <span class=\"caps\">CSS</span> styles, which will be applied to the widget</p>"}}]},{type:"method",attributes:{"access":"protected","name":"initBold","fromProperty":"bold"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>bold</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>bold</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDecoration","fromProperty":"decoration"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>decoration</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>decoration</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initFamily","fromProperty":"family"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>family</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>family</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initItalic","fromProperty":"italic"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>italic</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>italic</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initLineHeight","fromProperty":"lineHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>lineHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>lineHeight</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSize","fromProperty":"size"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>size</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>size</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isBold","fromProperty":"bold"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>bold</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isItalic","fromProperty":"italic"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>italic</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"resetBold","fromProperty":"bold"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>bold</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetDecoration","fromProperty":"decoration"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>decoration</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetFamily","fromProperty":"family"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>family</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetItalic","fromProperty":"italic"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>italic</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetLineHeight","fromProperty":"lineHeight"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>lineHeight</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSize","fromProperty":"size"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>size</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setBold","fromProperty":"bold"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>bold</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setDecoration","fromProperty":"decoration"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>decoration</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>decoration</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #decoration}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setFamily","fromProperty":"family"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>family</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>family</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #family}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setItalic","fromProperty":"italic"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>italic</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setLineHeight","fromProperty":"lineHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>lineHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>lineHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #lineHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSize","fromProperty":"size"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>size</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleBold","fromProperty":"bold"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>bold</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #bold}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleItalic","fromProperty":"italic"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>italic</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #italic}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"true","apply":"_applyBold","check":"Boolean","name":"bold","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the font is bold</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyDecoration","name":"decoration","possibleValues":"\"underline\",\"line-through\",\"overline\"","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The text decoration for this font</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyFamily","check":"Array","name":"family","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>A sorted list of font families</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyItalic","check":"Boolean","name":"italic","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the font is italic</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyLineHeight","check":"Number","name":"lineHeight","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The line height as scaling factor of the default line height. A value\nof 1 corresponds to the default line height</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applySize","check":"Integer","name":"size","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The font size (Unit: pixel)</p>"}}]}]}]}