// $Id$
// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag. Alle Rechte vorbehalten.

#include <memory>
#include <iostream>

using namespace std;
using namespace std::tr1;

#include "dangle.h"

struct Bar;

typedef shared_ptr<Bar> BarPointer;
typedef weak_ptr<Bar> WeakBarPointer;

struct Bar {
	Bar(void) : v(0) {}
	Bar(int _V) : v(_V) {}
	~Bar() { cout << "Zerstren von Bar mit v = " << v << endl; }
	int v;
	WeakBarPointer ref;	
};

void dangle(void)
{
	BarPointer A(new Bar(1));
	BarPointer B(new Bar(2));
	A->ref = B;
    B->ref = A;

    cout << A->v << endl; 
    cout << B->v << endl;
}
