#!BPY

# """
# Name: 'Printer-friendly Theme'
# Blender: 247
# Group: 'Themes'
# Tooltip: 'Choose printer-friendly theme'
# """

__author__ = "Blenderart Magazine / Christian Guckelsberger"
__version__ = "2.47"
__url__ = ["blender"]
__bpydoc__ = """Printer-friendly Blender theme, adapted from existing Blenderart Magazine by Christian Guckelsberger for c't magazine 20/2008."""

import Blender
from Blender.Window import Theme

theme = Theme.New('Printer-friendly Theme')

ui = theme.get('ui')
ui.action = [185, 185, 185, 255]
ui.menu_back = [210, 210, 210, 255]
ui.menu_hilite = [130, 130, 130, 255]
ui.menu_item = [220, 220, 220, 255]
ui.menu_text = [0, 0, 0, 255]
ui.menu_text_hi = [255, 255, 255, 255]
ui.neutral = [160, 160, 160, 255]
ui.num = [130, 130, 130, 255]
ui.outline = [180, 180, 180, 255]
ui.popup = [150, 150, 150, 255]
ui.setting = [180, 180, 180, 255]
ui.setting1 = [170, 170, 170, 255]
ui.setting2 = [160, 160, 160, 255]
ui.text = [20, 20, 20, 255]
ui.text_hi = [255, 255, 255, 255]
ui.textfield = [140, 140, 140, 255]
ui.textfield_hi = [234, 176, 39, 255]

buts = theme.get('buts')
buts.active = [255, 128, 0, 255]
buts.back = [170, 170, 170, 255]
buts.bone_pose = [0, 0, 0, 0]
buts.bone_solid = [0, 0, 0, 0]
buts.edge = [0, 0, 0, 255]
buts.edge_facesel = [75, 75, 75, 255]
buts.edge_seam = [219, 37, 18, 255]
buts.edge_select = [255, 171, 0, 255]
buts.face = [0, 0, 0, 18]
buts.face_dot = [255, 137, 0, 255]
buts.face_select = [255, 162, 0, 115]
buts.grid = [145, 145, 145, 255]
buts.header = [160, 160, 160, 255]
buts.hilite = [0, 0, 0, 0]
buts.lamp = [0, 0, 0, 0]
buts.normal = [34, 221, 221, 255]
buts.panel = [240, 240, 240, 94]
buts.select = [240, 90, 3, 255]
buts.shade1 = [160, 160, 160, 100]
buts.shade2 = [127, 112, 112, 100]
buts.strip = [0, 0, 0, 0]
buts.strip_select = [0, 0, 0, 0]
buts.syntaxb = [0, 0, 0, 0]
buts.syntaxc = [0, 0, 0, 0]
buts.syntaxl = [0, 0, 0, 0]
buts.syntaxn = [0, 0, 0, 0]
buts.syntaxv = [0, 0, 0, 0]
buts.text = [0, 0, 0, 255]
buts.text_hi = [255, 255, 255, 255]
buts.transform = [255, 255, 255, 255]
buts.vertex = [0, 0, 0, 255]
buts.vertex_select = [255, 137, 0, 255]
buts.vertex_size = 3
buts.wire = [71, 71, 71, 255]

view3d = theme.get('view3d')
view3d.active = [255, 14, 169, 255]
view3d.back = [255, 255, 255, 255]
view3d.bone_pose = [80, 200, 255, 80]
view3d.bone_solid = [200, 200, 200, 255]
view3d.edge = [0, 0, 0, 255]
view3d.edge_facesel = [75, 75, 75, 255]
view3d.edge_seam = [219, 37, 18, 255]
view3d.edge_select = [255, 171, 0, 255]
view3d.face = [0, 0, 0, 18]
view3d.face_dot = [255, 137, 0, 255]
view3d.face_select = [255, 162, 0, 115]
view3d.grid = [120, 120, 120, 255]
view3d.header = [190, 190, 190, 255]
view3d.hilite = [0, 0, 0, 0]
view3d.lamp = [0, 0, 0, 40]
view3d.normal = [34, 221, 221, 255]
view3d.panel = [255, 255, 255, 80]
view3d.select = [255, 160, 220, 255]
view3d.shade1 = [160, 160, 160, 100]
view3d.shade2 = [127, 112, 112, 100]
view3d.strip = [0, 0, 0, 0]
view3d.strip_select = [0, 0, 0, 0]
view3d.syntaxb = [0, 0, 0, 0]
view3d.syntaxc = [0, 0, 0, 0]
view3d.syntaxl = [0, 0, 0, 0]
view3d.syntaxn = [0, 0, 0, 0]
view3d.syntaxv = [0, 0, 0, 0]
view3d.text = [0, 0, 0, 255]
view3d.text_hi = [140, 140, 140, 140]
view3d.transform = [140, 140, 140, 140]
view3d.vertex = [0, 0, 0, 255]
view3d.vertex_select = [255, 255, 0, 255]
view3d.vertex_size = 4
view3d.wire = [71, 71, 71, 255]

file = theme.get('file')
file.active = [255, 128, 0, 255]
file.back = [128, 128, 128, 255]
file.bone_pose = [0, 0, 0, 0]
file.bone_solid = [0, 0, 0, 0]
file.edge = [0, 0, 0, 255]
file.edge_facesel = [75, 75, 75, 255]
file.edge_seam = [219, 37, 18, 255]
file.edge_select = [255, 171, 0, 255]
file.face = [0, 0, 0, 18]
file.face_dot = [255, 137, 0, 255]
file.face_select = [255, 162, 0, 115]
file.grid = [145, 145, 145, 255]
file.header = [194, 194, 194, 255]
file.hilite = [186, 163, 125, 255]
file.lamp = [0, 0, 0, 0]
file.normal = [34, 221, 221, 255]
file.panel = [255, 255, 255, 30]
file.select = [240, 90, 3, 255]
file.shade1 = [160, 160, 160, 100]
file.shade2 = [127, 112, 112, 100]
file.strip = [0, 0, 0, 0]
file.strip_select = [0, 0, 0, 0]
file.syntaxb = [0, 0, 0, 0]
file.syntaxc = [0, 0, 0, 0]
file.syntaxl = [0, 0, 0, 0]
file.syntaxn = [0, 0, 0, 0]
file.syntaxv = [0, 0, 0, 0]
file.text = [0, 0, 0, 255]
file.text_hi = [255, 255, 255, 255]
file.transform = [255, 255, 255, 255]
file.vertex = [0, 0, 0, 255]
file.vertex_select = [255, 137, 0, 255]
file.vertex_size = 3
file.wire = [71, 71, 71, 255]

ipo = theme.get('ipo')
ipo.active = [255, 128, 0, 255]
ipo.back = [120, 120, 120, 255]
ipo.bone_pose = [0, 0, 0, 0]
ipo.bone_solid = [0, 0, 0, 0]
ipo.edge = [0, 0, 0, 255]
ipo.edge_facesel = [75, 75, 75, 255]
ipo.edge_seam = [219, 37, 18, 255]
ipo.edge_select = [255, 171, 0, 255]
ipo.face = [0, 0, 0, 18]
ipo.face_dot = [255, 137, 0, 255]
ipo.face_select = [255, 162, 0, 115]
ipo.grid = [94, 94, 94, 255]
ipo.header = [194, 194, 194, 255]
ipo.hilite = [96, 192, 64, 255]
ipo.lamp = [0, 0, 0, 0]
ipo.normal = [34, 221, 221, 255]
ipo.panel = [255, 255, 255, 35]
ipo.select = [240, 90, 3, 255]
ipo.shade1 = [172, 172, 172, 100]
ipo.shade2 = [112, 112, 112, 100]
ipo.strip = [0, 0, 0, 0]
ipo.strip_select = [0, 0, 0, 0]
ipo.syntaxb = [0, 0, 0, 0]
ipo.syntaxc = [0, 0, 0, 0]
ipo.syntaxl = [0, 0, 0, 0]
ipo.syntaxn = [0, 0, 0, 0]
ipo.syntaxv = [0, 0, 0, 0]
ipo.text = [0, 0, 0, 255]
ipo.text_hi = [255, 255, 255, 255]
ipo.transform = [255, 255, 255, 255]
ipo.vertex = [0, 0, 0, 255]
ipo.vertex_select = [255, 180, 0, 255]
ipo.vertex_size = 3
ipo.wire = [71, 71, 71, 255]

info = theme.get('info')
info.active = [255, 128, 0, 255]
info.back = [182, 182, 182, 255]
info.bone_pose = [0, 0, 0, 0]
info.bone_solid = [0, 0, 0, 0]
info.edge = [0, 0, 0, 255]
info.edge_facesel = [75, 75, 75, 255]
info.edge_seam = [219, 37, 18, 255]
info.edge_select = [255, 171, 0, 255]
info.face = [0, 0, 0, 18]
info.face_dot = [255, 137, 0, 255]
info.face_select = [255, 162, 0, 115]
info.grid = [145, 145, 145, 255]
info.header = [190, 190, 190, 255]
info.hilite = [0, 0, 0, 0]
info.lamp = [0, 0, 0, 0]
info.normal = [34, 221, 221, 255]
info.panel = [255, 255, 255, 30]
info.select = [240, 90, 3, 255]
info.shade1 = [160, 160, 160, 100]
info.shade2 = [127, 112, 112, 100]
info.strip = [0, 0, 0, 0]
info.strip_select = [0, 0, 0, 0]
info.syntaxb = [0, 0, 0, 0]
info.syntaxc = [0, 0, 0, 0]
info.syntaxl = [0, 0, 0, 0]
info.syntaxn = [0, 0, 0, 0]
info.syntaxv = [0, 0, 0, 0]
info.text = [0, 0, 0, 255]
info.text_hi = [255, 255, 255, 255]
info.transform = [255, 255, 255, 255]
info.vertex = [0, 0, 0, 255]
info.vertex_select = [255, 137, 0, 255]
info.vertex_size = 3
info.wire = [71, 71, 71, 255]

sound = theme.get('sound')
sound.active = [255, 128, 0, 255]
sound.back = [153, 153, 153, 255]
sound.bone_pose = [0, 0, 0, 0]
sound.bone_solid = [0, 0, 0, 0]
sound.edge = [0, 0, 0, 255]
sound.edge_facesel = [75, 75, 75, 255]
sound.edge_seam = [219, 37, 18, 255]
sound.edge_select = [255, 171, 0, 255]
sound.face = [0, 0, 0, 18]
sound.face_dot = [255, 137, 0, 255]
sound.face_select = [255, 162, 0, 115]
sound.grid = [140, 140, 140, 255]
sound.header = [194, 194, 194, 255]
sound.hilite = [0, 0, 0, 0]
sound.lamp = [0, 0, 0, 0]
sound.normal = [34, 221, 221, 255]
sound.panel = [255, 255, 255, 30]
sound.select = [240, 90, 3, 255]
sound.shade1 = [173, 173, 173, 255]
sound.shade2 = [127, 112, 112, 100]
sound.strip = [0, 0, 0, 0]
sound.strip_select = [0, 0, 0, 0]
sound.syntaxb = [0, 0, 0, 0]
sound.syntaxc = [0, 0, 0, 0]
sound.syntaxl = [0, 0, 0, 0]
sound.syntaxn = [0, 0, 0, 0]
sound.syntaxv = [0, 0, 0, 0]
sound.text = [0, 0, 0, 255]
sound.text_hi = [255, 255, 255, 255]
sound.transform = [255, 255, 255, 255]
sound.vertex = [0, 0, 0, 255]
sound.vertex_select = [255, 137, 0, 255]
sound.vertex_size = 3
sound.wire = [71, 71, 71, 255]

action = theme.get('action')
action.active = [255, 128, 0, 255]
action.back = [116, 116, 116, 255]
action.bone_pose = [0, 0, 0, 0]
action.bone_solid = [0, 0, 0, 0]
action.edge = [0, 0, 0, 255]
action.edge_facesel = [75, 75, 75, 255]
action.edge_seam = [219, 37, 18, 255]
action.edge_select = [255, 171, 0, 255]
action.face = [166, 166, 166, 255]
action.face_dot = [255, 137, 0, 255]
action.face_select = [255, 162, 0, 115]
action.grid = [94, 94, 94, 255]
action.header = [194, 194, 194, 255]
action.hilite = [95, 66, 37, 100]
action.lamp = [0, 0, 0, 0]
action.normal = [34, 221, 221, 255]
action.panel = [255, 255, 255, 30]
action.select = [240, 90, 3, 255]
action.shade1 = [172, 172, 172, 255]
action.shade2 = [40, 40, 40, 100]
action.strip = [0, 0, 0, 0]
action.strip_select = [0, 0, 0, 0]
action.syntaxb = [0, 0, 0, 0]
action.syntaxc = [0, 0, 0, 0]
action.syntaxl = [0, 0, 0, 0]
action.syntaxn = [0, 0, 0, 0]
action.syntaxv = [0, 0, 0, 0]
action.text = [0, 0, 0, 255]
action.text_hi = [255, 255, 255, 255]
action.transform = [255, 255, 255, 255]
action.vertex = [0, 0, 0, 255]
action.vertex_select = [255, 137, 0, 255]
action.vertex_size = 3
action.wire = [71, 71, 71, 255]

nla = theme.get('nla')
nla.active = [255, 128, 0, 255]
nla.back = [116, 116, 116, 255]
nla.bone_pose = [0, 0, 0, 0]
nla.bone_solid = [0, 0, 0, 0]
nla.edge = [0, 0, 0, 255]
nla.edge_facesel = [75, 75, 75, 255]
nla.edge_seam = [219, 37, 18, 255]
nla.edge_select = [255, 171, 0, 255]
nla.face = [0, 0, 0, 18]
nla.face_dot = [255, 137, 0, 255]
nla.face_select = [255, 162, 0, 115]
nla.grid = [94, 94, 94, 255]
nla.header = [194, 194, 194, 255]
nla.hilite = [95, 66, 37, 100]
nla.lamp = [0, 0, 0, 0]
nla.normal = [34, 221, 221, 255]
nla.panel = [255, 255, 255, 30]
nla.select = [240, 90, 3, 255]
nla.shade1 = [172, 172, 172, 255]
nla.shade2 = [40, 40, 40, 100]
nla.strip = [228, 156, 198, 255]
nla.strip_select = [255, 255, 170, 255]
nla.syntaxb = [0, 0, 0, 0]
nla.syntaxc = [0, 0, 0, 0]
nla.syntaxl = [0, 0, 0, 0]
nla.syntaxn = [0, 0, 0, 0]
nla.syntaxv = [0, 0, 0, 0]
nla.text = [0, 0, 0, 255]
nla.text_hi = [255, 255, 255, 255]
nla.transform = [255, 255, 255, 255]
nla.vertex = [0, 0, 0, 255]
nla.vertex_select = [255, 137, 0, 255]
nla.vertex_size = 3
nla.wire = [71, 71, 71, 255]

seq = theme.get('seq')
seq.active = [255, 128, 0, 255]
seq.back = [175, 175, 175, 255]
seq.bone_pose = [0, 0, 0, 0]
seq.bone_solid = [0, 0, 0, 0]
seq.edge = [0, 0, 0, 255]
seq.edge_facesel = [75, 75, 75, 255]
seq.edge_seam = [219, 37, 18, 255]
seq.edge_select = [255, 171, 0, 255]
seq.face = [0, 0, 0, 18]
seq.face_dot = [255, 137, 0, 255]
seq.face_select = [255, 162, 0, 115]
seq.grid = [145, 145, 145, 255]
seq.header = [194, 194, 194, 255]
seq.hilite = [0, 0, 0, 0]
seq.lamp = [0, 0, 0, 0]
seq.normal = [34, 221, 221, 255]
seq.panel = [255, 255, 255, 30]
seq.select = [240, 90, 3, 255]
seq.shade1 = [160, 160, 160, 100]
seq.shade2 = [127, 112, 112, 100]
seq.strip = [0, 0, 0, 0]
seq.strip_select = [0, 0, 0, 0]
seq.syntaxb = [0, 0, 0, 0]
seq.syntaxc = [0, 0, 0, 0]
seq.syntaxl = [0, 0, 0, 0]
seq.syntaxn = [0, 0, 0, 0]
seq.syntaxv = [0, 0, 0, 0]
seq.text = [0, 0, 0, 255]
seq.text_hi = [255, 255, 255, 255]
seq.transform = [255, 255, 255, 255]
seq.vertex = [0, 0, 0, 255]
seq.vertex_select = [255, 137, 0, 255]
seq.vertex_size = 3
seq.wire = [71, 71, 71, 255]

image = theme.get('image')
image.active = [255, 128, 0, 255]
image.back = [96, 96, 96, 255]
image.bone_pose = [0, 0, 0, 0]
image.bone_solid = [0, 0, 0, 0]
image.edge = [0, 0, 0, 255]
image.edge_facesel = [75, 75, 75, 255]
image.edge_seam = [219, 37, 18, 255]
image.edge_select = [255, 171, 0, 255]
image.face = [0, 0, 0, 14]
image.face_dot = [255, 137, 0, 255]
image.face_select = [255, 162, 0, 50]
image.grid = [145, 145, 145, 255]
image.header = [194, 194, 194, 255]
image.hilite = [0, 0, 0, 0]
image.lamp = [0, 0, 0, 0]
image.normal = [34, 221, 221, 255]
image.panel = [255, 255, 255, 30]
image.select = [240, 90, 3, 255]
image.shade1 = [160, 160, 160, 100]
image.shade2 = [127, 112, 112, 100]
image.strip = [0, 0, 0, 0]
image.strip_select = [0, 0, 0, 0]
image.syntaxb = [0, 0, 0, 0]
image.syntaxc = [0, 0, 0, 0]
image.syntaxl = [0, 0, 0, 0]
image.syntaxn = [0, 0, 0, 0]
image.syntaxv = [0, 0, 0, 0]
image.text = [0, 0, 0, 255]
image.text_hi = [255, 255, 255, 255]
image.transform = [255, 255, 255, 255]
image.vertex = [0, 0, 0, 255]
image.vertex_select = [255, 180, 0, 255]
image.vertex_size = 3
image.wire = [71, 71, 71, 255]

imasel = theme.get('imasel')
imasel.active = [255, 128, 0, 255]
imasel.back = [180, 180, 180, 255]
imasel.bone_pose = [0, 0, 0, 0]
imasel.bone_solid = [0, 0, 0, 0]
imasel.edge = [0, 0, 0, 255]
imasel.edge_facesel = [75, 75, 75, 255]
imasel.edge_seam = [219, 37, 18, 255]
imasel.edge_select = [255, 171, 0, 255]
imasel.face = [0, 0, 0, 18]
imasel.face_dot = [255, 137, 0, 255]
imasel.face_select = [255, 162, 0, 115]
imasel.grid = [145, 145, 145, 255]
imasel.header = [194, 194, 194, 255]
imasel.hilite = [0, 0, 0, 0]
imasel.lamp = [0, 0, 0, 0]
imasel.normal = [34, 221, 221, 255]
imasel.panel = [255, 255, 255, 30]
imasel.select = [240, 90, 3, 255]
imasel.shade1 = [204, 204, 204, 255]
imasel.shade2 = [127, 112, 112, 100]
imasel.strip = [0, 0, 0, 0]
imasel.strip_select = [0, 0, 0, 0]
imasel.syntaxb = [0, 0, 0, 0]
imasel.syntaxc = [0, 0, 0, 0]
imasel.syntaxl = [0, 0, 0, 0]
imasel.syntaxn = [0, 0, 0, 0]
imasel.syntaxv = [0, 0, 0, 0]
imasel.text = [0, 0, 0, 255]
imasel.text_hi = [255, 255, 255, 255]
imasel.transform = [255, 255, 255, 255]
imasel.vertex = [0, 0, 0, 255]
imasel.vertex_select = [255, 137, 0, 255]
imasel.vertex_size = 3
imasel.wire = [71, 71, 71, 255]

text = theme.get('text')
text.active = [255, 128, 0, 255]
text.back = [153, 153, 153, 255]
text.bone_pose = [0, 0, 0, 0]
text.bone_solid = [0, 0, 0, 0]
text.edge = [0, 0, 0, 255]
text.edge_facesel = [75, 75, 75, 255]
text.edge_seam = [219, 37, 18, 255]
text.edge_select = [255, 171, 0, 255]
text.face = [0, 0, 0, 18]
text.face_dot = [255, 137, 0, 255]
text.face_select = [255, 162, 0, 115]
text.grid = [145, 145, 145, 255]
text.header = [194, 194, 194, 255]
text.hilite = [255, 0, 0, 255]
text.lamp = [0, 0, 0, 0]
text.normal = [34, 221, 221, 255]
text.panel = [255, 255, 255, 30]
text.select = [240, 90, 3, 255]
text.shade1 = [143, 143, 143, 255]
text.shade2 = [234, 176, 39, 255]
text.strip = [0, 0, 0, 0]
text.strip_select = [0, 0, 0, 0]
text.syntaxb = [128, 0, 80, 255]
text.syntaxc = [0, 100, 50, 255]
text.syntaxl = [100, 0, 0, 255]
text.syntaxn = [0, 0, 200, 255]
text.syntaxv = [95, 95, 0, 255]
text.text = [0, 0, 0, 255]
text.text_hi = [255, 255, 255, 255]
text.transform = [255, 255, 255, 255]
text.vertex = [0, 0, 0, 255]
text.vertex_select = [255, 137, 0, 255]
text.vertex_size = 3
text.wire = [71, 71, 71, 255]

oops = theme.get('oops')
oops.active = [255, 128, 0, 255]
oops.back = [153, 153, 153, 255]
oops.bone_pose = [0, 0, 0, 0]
oops.bone_solid = [0, 0, 0, 0]
oops.edge = [0, 0, 0, 255]
oops.edge_facesel = [75, 75, 75, 255]
oops.edge_seam = [219, 37, 18, 255]
oops.edge_select = [255, 171, 0, 255]
oops.face = [0, 0, 0, 18]
oops.face_dot = [255, 137, 0, 255]
oops.face_select = [255, 162, 0, 115]
oops.grid = [145, 145, 145, 255]
oops.header = [194, 194, 194, 255]
oops.hilite = [0, 0, 0, 0]
oops.lamp = [0, 0, 0, 0]
oops.normal = [34, 221, 221, 255]
oops.panel = [255, 255, 255, 30]
oops.select = [240, 90, 3, 255]
oops.shade1 = [160, 160, 160, 100]
oops.shade2 = [127, 112, 112, 100]
oops.strip = [0, 0, 0, 0]
oops.strip_select = [0, 0, 0, 0]
oops.syntaxb = [0, 0, 0, 0]
oops.syntaxc = [0, 0, 0, 0]
oops.syntaxl = [0, 0, 0, 0]
oops.syntaxn = [0, 0, 0, 0]
oops.syntaxv = [0, 0, 0, 0]
oops.text = [0, 0, 0, 255]
oops.text_hi = [255, 255, 255, 255]
oops.transform = [255, 255, 255, 255]
oops.vertex = [0, 0, 0, 255]
oops.vertex_select = [255, 137, 0, 255]
oops.vertex_size = 3
oops.wire = [71, 71, 71, 255]

time = theme.get('time')
time.active = [255, 128, 0, 255]
time.back = [153, 153, 153, 255]
time.bone_pose = [0, 0, 0, 0]
time.bone_solid = [0, 0, 0, 0]
time.edge = [0, 0, 0, 255]
time.edge_facesel = [75, 75, 75, 255]
time.edge_seam = [219, 37, 18, 255]
time.edge_select = [255, 171, 0, 255]
time.face = [0, 0, 0, 18]
time.face_dot = [255, 137, 0, 255]
time.face_select = [255, 162, 0, 115]
time.grid = [140, 140, 140, 255]
time.header = [194, 194, 194, 255]
time.hilite = [0, 0, 0, 0]
time.lamp = [0, 0, 0, 0]
time.normal = [34, 221, 221, 255]
time.panel = [255, 255, 255, 30]
time.select = [240, 90, 3, 255]
time.shade1 = [173, 173, 173, 255]
time.shade2 = [127, 112, 112, 100]
time.strip = [0, 0, 0, 0]
time.strip_select = [0, 0, 0, 0]
time.syntaxb = [0, 0, 0, 0]
time.syntaxc = [0, 0, 0, 0]
time.syntaxl = [0, 0, 0, 0]
time.syntaxn = [0, 0, 0, 0]
time.syntaxv = [0, 0, 0, 0]
time.text = [0, 0, 0, 255]
time.text_hi = [255, 255, 255, 255]
time.transform = [255, 255, 255, 255]
time.vertex = [0, 0, 0, 255]
time.vertex_select = [255, 137, 0, 255]
time.vertex_size = 3
time.wire = [71, 71, 71, 255]

Blender.Redraw(-1)