#!/bin/bash
#
# schaltet die Atheros-Karte in den AP-Mode
# und startet wpa_supplicant, der die Benutzer
# authentifiziert
#
# Reiko Kaps <rek@ctmagazin.de> 2008
# Version 0.0.1

. /lib/lsb/init-functions

IW=`which iwconfig`
WC=`which wlanconfig`
BRCTL=`which brctl`
HOSTAP=`which hostapd`
IFCONFIG=`which ifconfig`
DHCP_CLIENT=`which dhclient`
BRCTL=`which brctl`

NM_SCRIPT="/etc/dbus-1/event.d/25NetworkManager"
NM_PID="/var/run/NetworkManager/NetworkManager.pid"

# eventuell anpassen
WLAN="ath0"
WIFI="wifi0"
ETH="eth0"

# SSID ist der Hostname
SSID=`hostname`

# Parameter für WLAN, Netzwerk und Co
AP_MODE="11g"
HOSTAP_CONF="/etc/hostapd/hostapd.conf"
DHCP="yes" # no fuer stattische Adresse @see $STATIC_IP
STATIC_IP="192.168.1.1"
BRIDGE_DEV="br0"

##
# Ethernet und WLAN überbrücken
function start_bridge()
{
	echo -ne "Starting Network-Bridge (${BRIDGE_DEV}: ${ETH}, ${WLAN}) ... "
	${BRCTL} addbr ${BRIDGE_DEV}
	${BRCTL} addif ${BRIDGE_DEV} ${ETH}
	${BRCTL} addif ${BRIDGE_DEV} ${WLAN}
	${BRCTL} setfd ${BRIDGE_DEV} 1

	${IFCONFIG} ${ETH} 0.0.0.0 up
	${IFCONFIG} ${WLAN} 0.0.0.0 up
	echo -ne "[done]\n"
}

##
# IP-Adressen besorgen
function start_net()
{
	echo -ne "Starting Network ... "
	if [ ${DHCP} = "yes" ]; then
		${DHCP_CLIENT} ${BRIDGE_DEV}
	else
		${IFCONFIG} ${BRIDGE_DEV} ${STATIC_IP} up
	fi
	echo -ne "[done]\n"
}

##
# WLAN-Karte auf AP-Modus umschalten
function wlan2apmode()
{
	echo -ne "Switching Adapter ${WLAN} to AP-Mode ... "
	 # Karte in den AP-Mode versetzen
        ${WC} ${WLAN} destroy 2> /dev/null
        ${WC} ${WLAN} create wlandev ${WIFI} wlanmode ap > /dev/null
	sleep 5
        # SSID des APs setzen  (Vorgaben: hostname)
        ${IW} ${WLAN} essid ${SSID}
        iwpriv ${WLAN} mode ${AP_MODE}
	echo -ne "[done]\n"
}

## 
# HostAP starten (feur WPA-PSK)
function wpa()
{
	echo -ne "Starting HostAP (WPA) ... "
	${HOSTAP} -B ${HOSTAP_CONF}
	echo -ne "[done]\n"
}

##
# Networkmanager ab/anschalten
function networkmanager()
{
	local MODE=$1
	case "$MODE" in
		stop)
		if [ -e ${NM_SCRIPT} ]; then
				${NM_SCRIPT} stop
		fi
		;;
		start)
		if [ -e ${NM_SCRIPT} ]; then
                                ${NM_SCRIPT} start
                fi
		;;
	esac
}

##
# Hauptteil, Kommandozeile auswerten

case "$1" in
	start)
	# Networkmanager aus
	networkmanager stop

	# AP mit WPA (HostAP)
	wlan2apmode
	start_bridge
	start_net
	wpa
	;;

	stop)
	# falls hostap läuft, das Programm beenden
	killall dhclient
	killall hostapd
	# Brücke abschalten und loeschen
	echo -ne "Stopping bridge ... "
	${IFCONFIG} ${BRIDGE_DEV} down
	echo "done"
	echo -ne "Deleting bridge  $BRIDGE_DEV ... "
	${BRCTL} delbr ${BRIDGE_DEV}
	echo "done"

	sleep 5
	# WLAN-Gerät loeschen, als karte einrichten
	${WC} ${WLAN} destroy
	${WC} ${WLAN} create wlandev ${WIFI} wlanmode sta

	# Networkmanager anschalten
	networkmanager start

	echo -ne "[done]\n"
	;;

	*)
	echo "usage: $0 start|stop"
	;;
esac

exit 0
