// *****************************************************************
// Filename:  ViewDatabase.h
// Copyright: Pedram Azad, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:	  Pedram Azad
// Date:      02.05.2008
// *****************************************************************


#ifndef _VIEW_DATABASE_H_
#define _VIEW_DATABASE_H_


// *****************************************************************
// necessary includes
// *****************************************************************

#include <string>
//#include "DatabaseEntry.h"


// *****************************************************************
// forward class declarations
// *****************************************************************

class CFloatMatrix;
class CByteImage;
class CDatabaseEntry;
class CDynamicArray;
struct MyRegion;


// *****************************************************************
// defines
// *****************************************************************




// *****************************************************************
// CViewDatabase
// *****************************************************************

class CViewDatabase
{
public:
	// constructor
	CViewDatabase();
	
	// destructor
	~CViewDatabase();
	
	
	// public methods
	
	// for recognition
	bool Init(const char *pConfigurationFilename);

	bool FindBestMatch(const CByteImage *pInputImage, float &correlation, int &nResultClass, int &nResultView);

	// database access
	void DeleteDatabase();
	int AddEntry(const char *pName, const char *pImagePath);
	bool RemoveEntry(const char *pName);
	
	// member access
	int GetNumberOfClasses();
	const CDatabaseEntry* GetDatabaseEntry(int nIndex);

	// helpers
	static void Normalize(const CByteImage *pInputImage, CByteImage *pOutputImage, const MyRegion &region);


private:
	// private methods
	bool ReadConfigurationFile(const char *pConfigurationFilename);
	bool WriteConfigurationFile(const char *pConfigurationFilename);
		
	
	// private attributes
	int m_nImageWidth;
	int m_nImageHeight;
	
	std::string m_sConfigurationFilename;
	
	CDynamicArray *m_pDatabaseEntries;
};



#endif /* _VIEW_DATABASE_H_ */
