// *****************************************************************
// Filename:  DatabaseEntry.h
// Copyright: Pedram Azad, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:	  Pedram Azad
// Date:      02.05.2008
// *****************************************************************


#ifndef _DATABASE_ENTRY_H_
#define _DATABASE_ENTRY_H_


// *****************************************************************
// necessary includes
// *****************************************************************

#include "Math/FloatMatrix.h"
#include "DataStructures/DynamicArray.h"
#include <string>


// *****************************************************************
// forward class declarations
// *****************************************************************

class CByteImage;




// *****************************************************************
// CDatabaseEntry
// *****************************************************************

class CDatabaseEntry : public CDynamicArrayElement
{
public:
	// constructor
	CDatabaseEntry(const char *pName, const char *pPath);
	
	// destructor
	~CDatabaseEntry();
	
	
	// public methods
	bool ReadImages();
	bool AddImage(const CByteImage *pImage);

	int GetNumberOfSamples() const;
	int GetImageWidth() const { return m_nImageWidth; }
	int GetImageHeight() const { return m_nImageHeight; }
	const float* GetImageData(int nIndex) const;
	
	// public attributes
	std::string m_sPath;
	std::string m_sName;

	// static methods
	static void NormalizeIntensity(float *pData, int nLength);
	static int GetNumberOfSamples(const char *pFileName, int &width, int &height);
	
	
private:
	class CDataElement : public CDynamicArrayElement
	{
	public:
		CDataElement(int nDimension)
		{
			data = new float[nDimension];
		}

		~CDataElement()
		{
			delete [] data;
		}

		float *data;
	};

	// private attributes
	CDynamicArray *m_pImages;

	int m_nImageWidth;
	int m_nImageHeight;
};



#endif /* _DATABASE_ENTRY_H_ */
