#include "Image/ImageProcessor.h"
#include "Image/ByteImage.h"
#include <stdio.h>


int main(int argc, char **args)
{
   if (argc != 2)
   {
      printf("Benutzung: helloworld [Pfad zur Datei]\n");
      return 1;
   }

   CByteImage image;
   
   if (!image.LoadFromFile(args[1]))
   {
      printf("Fehler: Datei '%s' konnte nicht geoeffnet werden\n", args[1]);
      return 1;
   }

   CByteImage gray_image(image.width, image.height, CByteImage::eGrayScale);
   ImageProcessor::ConvertImage(&image, &gray_image);

   ImageProcessor::CalculateGradientImageSobel(&gray_image, &gray_image);

   gray_image.SaveToFile("output.bmp");
   printf("Ergebnisbild wurde als 'output.bmp' abgespeichert\n");

   return 0;
}
