#if defined WIN32
#include "VideoCapture/OpenCVCapture.h"
#elif defined __linux
#include "VideoCapture/Linux1394Capture.h"
#else
#include "VideoCapture/QuicktimeCapture.h"
#endif


#include "Image/ByteImage.h"
#include "gui/QTWindow.h"
#include "gui/QTApplicationHandler.h"
#include <stdio.h>


int main(int argc, char **args)
{
   #if defined WIN32
   COpenCVCapture capture(-1);
   #elif defined __linux
   // Beispiel: Firewire unter Linux, COpenCVCapture ginge z.B. auch
   CLinux1394Capture capture(1, CVideoCaptureInterface::e640x480,
     CVideoCaptureInterface::eBayerPatternToRGB24);
   #else
   CQuicktimeCapture capture(CVideoCaptureInterface::e640x480);
   #endif

   // Kamera oeffnen
   if (!capture.OpenCamera())
   {
      printf("Fehler: Kamera konnte nicht geoeffnet werden\n");
      return 1;
   }

   const int width = capture.GetWidth();
   const int height = capture.GetHeight();
   const CByteImage::ImageType type = capture.GetType();

   CByteImage *ppImages[] = { new CByteImage(width, height, type) };

   CQTApplicationHandler qt_application_handler(argc, args);
   qt_application_handler.Reset();

   // Fenster anlegen und anzeigen
   CQTWindow window(width, height);
   window.Show();
 
   while (!qt_application_handler.ProcessEventsAndGetExit())
   {
      // Kamerabild einlesen
      if (!capture.CaptureImage(ppImages))
         break;

      // Bild im Fenster anzeigen
      window.DrawImage(ppImages[0]);
   }

   delete ppImages[0];

   return 0;
}
