# Gast-Konfig aus NVRAM holen
gastwlan=`nvram get gastwlan | sed "s/name\=//g"`
if [ -z "$gastwlan"]; then
  # Default-Konfiguration setzen
  nvram add gastwlan=1
  nvram set gastwlan=set
  # neue WLAN-Schnittstelle
  nvram add gastif=1
  nvram set gastif=ath1
  # IP-Adresse
  nvram add gastgw=1
  nvram set gastgw=192.168.234.1
  # DHCP-Bereich und Subnet
  nvram add gastds=1
  nvram set gastds=192.168.234.101
  nvram add gastde=1
  nvram set gastde=192.168.234.120
  nvram add gastsu=1
  nvram set gastsu=255.255.255.0
  # WLAN-SSID und WPA-PSK
  nvram add gastid=1
  nvram set gastid=GAST
  nvram add gastps=1
  nvram set gastps=gastzugang
  # dauerhaft merken
  nvram commit
fi
gastif=`nvram get gastif | sed "s/name\=//g"`
gastgw=`nvram get gastgw | sed "s/name\=//g"`
gastds=`nvram get gastds | sed "s/name\=//g"`
gastde=`nvram get gastde | sed "s/name\=//g"`
gastsu=`nvram get gastsu | sed "s/name\=//g"`
gastid=`nvram get gastid | sed "s/name\=//g"`
gastps=`nvram get gastps | sed "s/name\=//g"`
router=`nvram get lan_ipaddr | sed "s/name\=//g"`
dnssrv=`cat /etc/resolv.conf | sed "s/nameserver\ //g"`
dnssrv1=`echo $dnssrv | sed "s/\ .*$//g"`
dnssrv2=`echo $dnssrv | sed "s/^.*\ //g"`

# Madwifi-Konfiguration ergaenzen
echo "interface=$gastif" >>/tmp/ext/madwifi-gast.conf
echo "ssid=$gastid" >>/tmp/ext/madwifi-gast.conf
echo "wpa_passphrase=$gastps" >>/tmp/ext/madwifi-gast.conf
# DCHP-Server-Konfiguration erzeugen
echo "server $gastgw" >/tmp/ext/udhcpd-gast.conf
echo "start $gastds" >>/tmp/ext/udhcpd-gast.conf
echo "end $gastde" >>/tmp/ext/udhcpd-gast.conf
echo "interface $gastif" >>/tmp/ext/udhcpd-gast.conf
echo "option subnet $gastsu" >>/tmp/ext/udhcpd-gast.conf
echo "option router $gastgw" >>/tmp/ext/udhcpd-gast.conf
echo "option dns $dnssrv1" >>/tmp/ext/udhcpd-gast.conf
echo "option dns $dnssrv2" >>/tmp/ext/udhcpd-gast.conf
echo "option lease 1800" >>/tmp/ext/udhcpd-gast.conf

# Gast-Zelle starten
/sbin/wlanconfig $gastif create wlandev wifi0 wlanmode ap
# Schnitte aktivieren
ifconfig $gastif $gastgw up
sleep 3
# hostapd starten
/usr/sbin/hostapd -B /tmp/ext/madwifi-gast.conf &
sleep 3
# DHCP-Server fuer $gastif starten
/usr/sbin/udhcpd /tmp/ext/udhcpd-gast.conf &
sleep 3
# FW-Regeln setzen
/tmp/ext/gast-fw.sh
