// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>
// Heise Zeitschriften Verlag, Hannover, Germany

#include <QtGlobal>
#include <QMutexLocker>

#include "WorkerThread.h"


WorkerThread::WorkerThread(ThreadPool* pool, QObject* parent)
: QThread(parent), pool(pool)
{
	doQuit = false;
	idling = false;
}


WorkerThread::~WorkerThread()
{
	terminate();
	wait();
}


void WorkerThread::terminate(void)
{
	triggerMutex.lock();
	doQuit = true;
	triggerCond.wakeOne();
	triggerMutex.unlock();
}


void WorkerThread::run(void)
{
	id = (unsigned int) QThread::currentThreadId();
	// process job queue until queue is empty
	for ( ; !doQuit ; )
	{
		bool wasBusy = false;
		Job* job;
		while ((job = pool->nextJob()) != NULL)
		{
			job->run();
			wasBusy = true;
			pool->jobDone(this);
		}
		if (wasBusy)
		{
			pool->jobsDone();
		}

		qDebug("WorkerThread 0x%04x waits for trigger ..", id);
		triggerMutex.lock();
		idling = true;
		triggerCond.wait(&triggerMutex);
		idling = false;
		triggerMutex.unlock();
		qDebug("WorkerThread 0x%04x triggered ..", id);
	}
	if (doQuit)
	{
		pool->jobDone(this);
	}
}


void WorkerThread::trigger(void)
{
	QMutexLocker locker(&triggerMutex);
	if (!isRunning())
	{
		start();
	}
	else
	{
		triggerCond.wakeOne();
	}
}
