#ifndef OPCODES_H
#define OPCODES_H
#define icat86    1
#define i86       0      
#define i186      1      
#define i286      2      
#define i386      3      
#define i486      4      
#define iP5       5   //+MMX    
#define iP6       6   //+FPUP6    
#define iPII      7   //
#define iPIII     8   //+MMX2+SSE 
#define iP4       9   //+SSE2+MMX3 
#define iP4E      0xA //+SSE3+FPUPNI 
#define i64       0xB // ... +AMD64/EM64 
#define iMer      0xC //+SSSE3 
#define iPen      0xD //+SSE4.1 
#define iNeh      0xE //+SSE4.2

#define i64b64    0x18 //for statistics : 64 Bit Operands
#define i64b32    0x19 //for statistics : 32 Bit Operands
#define i64b16    0x1A //for statistics : 16 Bit Operands
#define i64b8     0x1B //for statistics : 8 Bit Operands

#define icatFPU   2 
#define ioffFPU   0x20
#define i87       ioffFPU+i86   //#as changed
#define i287      ioffFPU+i286  //#as added
#define i387      ioffFPU+i386  //#as changed 
#define iFPUP6    ioffFPU+iP6   //#as added
#define iFPUPNI   ioffFPU+iP4E  //#as added
#define iFPUCX    0x34          //#as added, not included yet

#define icatMMX   3
#define ioffMMX   0x40
#define iMMX      ioffMMX+iP5   // some are included in SSE3
#define iMMX2     ioffMMX+iPIII // together with SSE PIII (Katmai) 
#define iMMX3     ioffMMX+iP4   // together with SSE2 P4 
#define iMMX4     ioffMMX+iMer  // is included in SSSE3 

#define icatSSE   4 
#define ioffSSE   0x60        //# as changed 
#define iSSE      ioffSSE+iPIII   
#define iSSE2     ioffSSE+iP4   
#define iSSE3     ioffSSE+iP4E   
#define iSSSE3    ioffSSE+iMer   
#define iSSE41    ioffSSE+iPen   
#define iSSE42    ioffSSE+iNeh 

#define iSSEss     ioffSSE+0x10 // for statistics 
#define iSSEps     ioffSSE+0x11 // for statistics 
#define iSSE2ss    ioffSSE+0x12 // for statistics  
#define iSSE2ps    ioffSSE+0x13 // for statistics 
#define iSSE2sd    ioffSSE+0x14 // for statistics  
#define iSSE2pd    ioffSSE+0x15 // for statistics 
#define iSSE3ss    ioffSSE+0x16 // for statistics  
#define iSSE3ps    ioffSSE+0x17 // for statistics 
#define iSSE3sd    ioffSSE+0x18 // for statistics  
#define iSSE3pd    ioffSSE+0x19 // for statistics 

#define icatMem   5
#define ioffMem   0x80
#define iMemSSE   ioffMem+iPIII //Memory operations with SSE (i.e. prefetch ...) 
#define iMemSSE2  ioffMem+iP4   //Memory operations with SSE2(i.e. lfence/mfence ...)  
#define iMemSSE3  ioffMem+iP4E  //Memory operations with SSE3 (Monitor/wait )  

#define icatAMD   6
#define ioffAMD   0xA0       //# as changed 
#define iK3D      ioffAMD+1
#define iK3D2     ioffAMD+2 
#define iSSE4a    ioffAMD+4 //#as added
#define iSSE5     ioffAMD+5 

#define imaxinst  0xAF 

#define iPriv     0x800  
#define i64Bit    0x4000 
#define in64Bit   0x8000 
#define i86n64    0x8000
#define i186n64   0x8001
#define i286n64   0x8002

#define i86p      0x800
#define i286p     0x802
#define i386p     0x803
#define i486p     0x804
#define iP5p      0x805  
#define iVMi      0x813 
#endif // #ifndef OPCODES_H