/****************************    opcodes.cpp    *******************************                                                                                                                                                                        
* Author:        Agner Fog                                                                                                                                                                                                                             
* Date created:  2007-02-21                                                                                                                                                                                                                            
* Last modified: 2007-09-04 ; #as some extentions (2007-10-01)                                                                                                                                                                                         
* Project:       objconv                                                                                                                                                                                                                               
* Module:        opcodes.cpp                                                                                                                                                                                                                           
* Description:                                                                                                                                                                                                                                         
* Definition of opcode maps used by disassembler                                                                                                                                                                                                       
*                                                                                                                                                                                                                                                      
* (c) 2007 GNU General Public License www.gnu.org/copyleft/gpl.html                                                                                                                                                                                    
*****************************************************************************/                                                                                                                                                                         
                                                                                                                                                                                                                                                       
/*************************** Define opcode maps ******************************                                                                                                                                                                         
Interpretation of an opcode starts at OpcodeMap0 where the first opcode byte                                                                                                                                                                           
after any prefixes is used as index into the map. If more than one possible                                                                                                                                                                            
instruction starts with this byte then there is a link to a secondary map.                                                                                                                                                                             
The criterion for indexing into the secondary map is given by TableLink.                                                                                                                                                                               
If TableLink is nonzero then the map number for the secondary map is given                                                                                                                                                                             
in the InstructionSet field. The secondary map may contain a link to a                                                                                                                                                                                 
tertiary map, and so on.                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                       
The meaning of each field in the map entries is defined in disasm.h.                                                                                                                                                                                   
                                                                                                                                                                                                                                                       
OpcodeTables[] is an array of pointers to all the maps.                                                                                                                                                                                                
                                                                                                                                                                                                                                                       
OpcodeTableLength[] indicates the size of each map.                                                                                                                                                                                                    
                                                                                                                                                                                                                                                       
If a map is incomplete, then the last entry should indicate a default for                                                                                                                                                                              
the missing entries, i.e. how to display the illegal or unknown instruction                                                                                                                                                                            
codes.                                                                                                                                                                                                                                                 
                                                                                                                                                                                                                                                       
New entries can be added whenever a new extension to the instruction set is                                                                                                                                                                            
introduced.                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                       
*****************************************************************************/                                                                                                                                                                         
                                                                                                                                                                                                                                                       
#include "stdafx.h"   
#include "opcodes.h" 

//     0        1        2         3         4         5       6          7                                                                                                                                                                            
                                                                                                                                                                                                                                                       
/* sorted enumeration of OpCodeTables */                                                                                                                                                                                                                               
 enum {                                                                                                                                                                                                                                                
	   t0,       t0F,      t63,      t80,      t81,      t82,      t83,      t8F,                                                                                                                                                                  
	   t90, 	 t98,      t99,      t9C,      t9D,      tC0,      tC1,      tC6,                                                                                                                                                              
       tC7,      tCF,	   tD0,      tD1,      tD2,      tD3,      tD8,      tD9,                                                                                                                                                                      
       tD9_010,  tD9_100,  tD9_101,  tD9_110,  tD9_111,  tDA,      tDA_101,  tDB,                                                                                                                                                                      
       tDB_100,  tDC,      tDD,      tDE,      tDE_011,  tDF,      tDF_100,  tE3,                                                                                                                                                                      
	   tF6,      tF7,      tFE,      tFF,                                                                                                                                                                                                          
                                                                                                                                                                                                                                                       
       t0F00,    t0F01,    t0F01_0,  t0F01_1,  t0F02,    t0F03,    t0F0F,    t0F10,                                                                                                                                                                    
	   t0F11,    t0F12,    t0F12n,   t0F16,    t0F16n,   t0F18,    t0F24,    t0F25,                                                                                                                                                                
	   t0F2A,    t0F2B,    t0F2C,    t0F2D,    t0F2E,    t0F2F,    t0F38,    t0F38F1,                                                                                                                                                              
	   t0F39,    t0F3A,    t0F3A14,  t0F3A15,  t0F3A16,  t0F3A20,  t0F3B,    t0F5A,                                                                                                                                                                
	   t0F5B,    t0F6E,    t0F6F,    t0F70,    t0F71,    t0F72,    t0F73,    t0F78,                                                                                                                                                                
	   t0F79,    t0F7A,    t0F7B,    t0F7C,    t0F7D,    t0F7E,    t0F7En,   t0F7E_F3,                                                                                                                                                             
	   t0F7F,    t0FAE,    t0FB8,    t0FB9,    t0FBA,    t0FBD,    t0FC2,    t0FC4,                                                                                                                                                                
	   t0FC7,    t0FC7_1,  t0FC7_6,  t0FD0,    t0FD6,    t0FE6,    t0FE7,    t0FF0,                                                                                                                                                                
	   t0FF7                                                                                                                                                                                                                                       
 };                                                                                                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Primary opcode map. This is the start of all opcode lookups                                                                                                                                                                                         
SOpcodeDef OpcodeMap0[256] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"add",       i86,    0x10,   0x13,   0x201,  1,      0,      0  },    // 00                                                                                                                                                                        
   {"add",       i86,    0x1110, 0x13,   0x209,  9,      0,      0  },    // 01                                                                                                                                                                        
   {"add",       i86,    0,      0x12,   1,      0x201,  0,      0  },    // 02                                                                                                                                                                        
   {"add",       i86,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 03                                                                                                                                                                        
   {"add",       i86,    0,      0x41,   0xa1,   0x1000, 0,      0  },    // 04                                                                                                                                                                        
   {"add",       i86,    0x1100, 0x81,   0xa9,   0x3000, 0,     0x80},    // 05                                                                                                                                                                        
   {"push es",   i86n64, 2,         1,   0,      0,      0,      0  },    // 06                                                                                                                                                                        
   {"pop  es",   i86n64, 2,         1,   0,      0,      0,      0  },    // 07                                                                                                                                                                        
   {"or",        i86,    0x10,   0x13,   0x201,  1,      0,      0  },    // 08                                                                                                                                                                        
   {"or",        i86,    0x1110, 0x13,   0x209,  9,      0,      0  },    // 09                                                                                                                                                                        
   {"or",        i86,    0,      0x12,   1,      0x201,  0,      0  },    // 0A                                                                                                                                                                        
   {"or",        i86,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0B                                                                                                                                                                        
   {"or",        i86,    0,      0x41,   0xa1,   0x5000, 0,      0  },    // 0C                                                                                                                                                                        
   {"or",        i86,    0x1100, 0x81,   0xa9,   0x7000, 0,     0x80},    // 0D                                                                                                                                                                        
   {"push cs",   i86n64, 2,         1,   0,      0,      0,      0  },    // 0E                                                                                                                                                                        
   {0,           t0F,    0,         0,   0,      0,      1,      0  },    // 0F link to OpcodeMap1                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"adc",       i86,    0x10,   0x13,   0x201,  1,      0,      0  },    // 10                                                                                                                                                                        
   {"adc",       i86,    0x1110, 0x13,   0x209,  9,      0,      0  },    // 11                                                                                                                                                                        
   {"adc",       i86,    0,      0x12,   1,      0x201,  0,      0  },    // 12                                                                                                                                                                        
   {"adc",       i86,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 13                                                                                                                                                                        
   {"adc",       i86,    0,      0x41,   0xa1,   0x1000, 0,      0  },    // 14                                                                                                                                                                        
   {"adc",       i86,    0x1100, 0x81,   0xa9,   0x3000, 0,     0x80},    // 15                                                                                                                                                                        
   {"push ss",   i86n64, 2,         1,   0,      0,      0,      0  },    // 16                                                                                                                                                                        
   {"pop  ss",   i86n64, 2,         1,   0,      0,      0,      0  },    // 17                                                                                                                                                                        
   {"sbb",       i86,    0x10,   0x13,   0x201,  1,      0,      0  },    // 18                                                                                                                                                                        
   {"sbb",       i86,    0x1110, 0x13,   0x209,  9,      0,      0  },    // 19                                                                                                                                                                        
   {"sbb",       i86,    0,      0x12,   1,      0x201,  0,      0  },    // 1A                                                                                                                                                                        
   {"sbb",       i86,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 1B                                                                                                                                                                        
   {"sbb",       i86,    0,      0x41,   0xa1,   0x1000, 0,      0  },    // 1C                                                                                                                                                                        
   {"sbb",       i86,    0x1100, 0x81,   0xa9,   0x3000, 0,     0x80},    // 1D                                                                                                                                                                        
   {"push ds",   i86n64, 2,         1,   0,      0,      0,      0  },    // 1E                                                                                                                                                                        
   {"pop  ds",   i86n64, 2,         1,   0,      0,      0,      0  },    // 1F                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"and",       i86,    0x10,   0x13,   0x201,  1,      0,      0  },    // 20                                                                                                                                                                        
   {"and",       i86,    0x1110, 0x13,   0x209,  9,      0,      0  },    // 21                                                                                                                                                                        
   {"and",       i86,    0,      0x12,   1,      0x201,  0,      0  },    // 22                                                                                                                                                                        
   {"and",       i86,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 23                                                                                                                                                                        
   {"and",       i86,    0,      0x41,   0xa1,   0x5000, 0,      0  },    // 24                                                                                                                                                                        
   {"and",       i86,    0x1100, 0x81,   0xa9,   0x7000, 0,     0x80},    // 25                                                                                                                                                                        
   {"es:",       i86,    0,    0x8001,   0,      0,      0,      0  },    // 26                                                                                                                                                                        
   {"daa",       i86n64, 0,         2,   0,      0,      0,      8  },    // 27                                                                                                                                                                        
   {"sub",       i86,    0x10,   0x13,   0x201,  1,      0,      0  },    // 28                                                                                                                                                                        
   {"sub",       i86,    0x1110, 0x13,   0x209,  9,      0,      0  },    // 29                                                                                                                                                                        
   {"sub",       i86,    0,      0x12,   1,      0x201,  0,      0  },    // 2A                                                                                                                                                                        
   {"sub",       i86,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 2B                                                                                                                                                                        
   {"sub",       i86,    0,      0x41,   0xa1,   0x1000, 0,      0  },    // 2C                                                                                                                                                                        
   {"sub",       i86,    0x1100, 0x81,   0xa9,   0x3000, 0,     0x80},    // 2D                                                                                                                                                                        
   {"cs:",       i86,    0,    0x8001,   0,      0,      0,      0  },    // 2E                                                                                                                                                                        
   {"das",       i86n64, 0,         2,   0,      0,      0,      8  },    // 2F                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"xor",       i86,    0x10,   0x13,   0x201,  1,      0,      0  },    // 30                                                                                                                                                                        
   {"xor",       i86,    0x1110, 0x13,   0x209,  9,      0,      0  },    // 31                                                                                                                                                                        
   {"xor",       i86,    0,      0x12,   1,      0x201,  0,      0  },    // 32                                                                                                                                                                        
   {"xor",       i86,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 33                                                                                                                                                                        
   {"xor",       i86,    0,      0x41,   0xa1,   0x5000, 0,      0  },    // 34                                                                                                                                                                        
   {"xor",       i86,    0x1100, 0x81,   0xa9,   0x7000, 0,     0x80},    // 35                                                                                                                                                                        
   {"ss:",       i86,    0,    0x8001,   0,      0,      0,      0  },    // 36                                                                                                                                                                        
   {"aaa",       i86n64, 0,         2,   0,      0,      0,      8  },    // 37                                                                                                                                                                        
   {"cmp",       i86,    0x00,   0x13,   0x201,  1,      0,      4  },    // 38                                                                                                                                                                        
   {"cmp",       i86,    0x1100, 0x13,   0x209,  9,      0,      4  },    // 39                                                                                                                                                                        
   {"cmp",       i86,    0,      0x12,   1,      0x201,  0,      4  },    // 3A                                                                                                                                                                        
   {"cmp",       i86,    0x1100, 0x12,   9,      0x209,  0,      4  },    // 3B                                                                                                                                                                        
   {"cmp",       i86,    0,      0x41,   0xa1,   0x1000, 0,      4  },    // 3C                                                                                                                                                                        
   {"cmp",       i86,    0x1100, 0x81,   0xa9,   0x3000, 0,     0x84},    // 3D                                                                                                                                                                        
   {"ds:",       i86,    0,    0x8001,   0,      0,      0,      0  },    // 3E                                                                                                                                                                        
   {"aas",       i86n64, 0,         2,   0,      0,      0,      8  },    // 3F                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 40                                                                                                                                                                        
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 41                                                                                                                                                                        
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 42                                                                                                                                                                        
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 43                                                                                                                                                                        
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 44                                                                                                                                                                        
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 45                                                                                                                                                                        
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 46                                                                                                                                                                        
   {"inc",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 47                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 48                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 49                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 4A                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 4B                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 4C                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 4D                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 4E                                                                                                                                                                        
   {"dec",       i86n64, 0x100,  3,      8,      0,      0,      0  },    // 4F                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 50                                                                                                                                                                        
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 51                                                                                                                                                                        
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 52                                                                                                                                                                        
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 53                                                                                                                                                                        
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 54                                                                                                                                                                        
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 55                                                                                                                                                                        
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 56                                                                                                                                                                        
   {"push",      i86,    0x2102, 3,      0x0A,   0,      0,      4  },    // 57                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 58                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 59                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 5A                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 5B                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 5C                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 5D                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 5E                                                                                                                                                                        
   {"pop",       i86,    0x2102, 3,      0x0A,   0,      0,      0  },    // 5F                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pusha",     i186n64,0x102,  2,      0,      0,      0,      5  },    // 60                                                                                                                                                                        
   {"popa",      i186n64,0x102,  2,      0,      0,      0,      9  },    // 61                                                                                                                                                                        
   {"bound",     i186n64,0x106,  0x12,   8,      0x109,  0,      0  },    // 62                                                                                                                                                                        
   {"arpl/movsxd", t63,  0,      0,      0,      0,      7,      0  },    // 63 Link to map 0x3B #as comment  fix                                                                                                                                      
   {"fs:",       i86,    0,    0x8001,   0,      0,      0,      0  },    // 64                                                                                                                                                                        
   {"gs:",       i86,    0,    0x8001,   0,      0,      0,      0  },    // 65                                                                                                                                                                        
   {"operand size:", i86,0,    0x8000,   0,      0,      0,      0  },    // 66                                                                                                                                                                        
   {"address size:", i86,0,    0x8000,   0,      0,      0,      0  },    // 67                                                                                                                                                                        
   {"push",      i86,    0x2102, 0x82,   0,      0x3000, 0,     0x80},    // 68 push imm word                                                                                                                                                          
   {"imul",      i186,   0x1100, 0x92,   9,      0x2209, 0,     0x80},    // 69 imul r,m,iv                                                                                                                                                            
   {"push",      i86,    0x2102, 0x42,   0,      0x2000, 0,      0  },    // 6A push imm byte                                                                                                                                                          
   {"imul",      i186,   0x1100, 0x52,   9,      0x2209, 0,      0  },    // 6B imul r,m,ib                                                                                                                                                            
   {"insb",      i86,    0x021,  1,      0,      0,      0,      8  },    // 6C insb                                                                                                                                                                   
   {"ins",       i86,    0x121,  1,      0xc2,   0xb2,   0,      8  },    // 6D insw                                                                                                                                                                   
   {"outsb",     i86,    0x021,  1,      0,      0,      0,      8  },    // 6E outsb                                                                                                                                                                  
   {"outs",      i86,    0x121,  1,      0xb2,   0xc2,   0,      8  },    // 6F outs                                                                                                                                                                   
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"jo",        i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 70 conditional short jumps                                                                                                                                                
   {"jno",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 71                                                                                                                                                                        
   {"jc",        i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 72                                                                                                                                                                        
   {"jnc",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 73                                                                                                                                                                        
   {"jz",        i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 74                                                                                                                                                                        
   {"jnz",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 75                                                                                                                                                                        
   {"jbe",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 76                                                                                                                                                                        
   {"ja",        i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 77                                                                                                                                                                        
   {"js",        i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 78                                                                                                                                                                        
   {"jns",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 79                                                                                                                                                                        
   {"jpe",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 7A                                                                                                                                                                        
   {"jpo",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 7B                                                                                                                                                                        
   {"jl",        i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 7C                                                                                                                                                                        
   {"jge",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 7D                                                                                                                                                                        
   {"jle",       i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 7E                                                                                                                                                                        
   {"jg",        i86,    0x88,   0x42,   0x81,   0,      0,      0  },    // 7F                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"grp1",      t80,    0,      0,      0,      0,      2,      0  },    // 80 link to immediate grp 1                                                                                                                                                
   {"grp1",      t81,    0,      0,      0,      0,      2,      0  },    // 81 link to immediate grp 1                                                                                                                                                
   {"grp1",      t82,    0,      0,      0,      0,      2,      0  },    // 82 link to immediate grp 1                                                                                                                                                
   {"grp1",      t83,    0,      0,      0,      0,      2,      0  },    // 83 link to immediate grp 1                                                                                                                                                
   {"test",      i86,    0,      0x13,   0x201,  1,      0,      4  },    // 84                                                                                                                                                                        
   {"test",      i86,    0x1100, 0x13,   0x209,  9,      0,      4  },    // 85                                                                                                                                                                        
   {"xchg",      i86,    0x0010, 0x13,   0x201,  1,      0,     0x48},    // 86                                                                                                                                                                        
   {"xchg",      i86,    0x1110, 0x13,   0x209,  9,      0,     0x48},    // 87                                                                                                                                                                        
   {"mov",       i86,    0,      0x13,   0x201,  1,      0,     0x40},    // 88                                                                                                                                                                        
   {"mov",       i86,    0x1100, 0x13,   0x209,  9,      0,     0x40},    // 89                                                                                                                                                                        
   {"mov",       i86,    0,      0x12,   1,      0x201,  0,     0x40},    // 8A                                                                                                                                                                        
   {"mov",       i86,    0x1100, 0x12,   9,      0x209,  0,     0x40},    // 8B                                                                                                                                                                        
   {"mov",       i86,    0x1100, 0x13,   0x209,  0x91,   0,      0  },    // 8C mov r16,segreg                                                                                                                                                         
   {"lea",       i86,    0x1101, 0x12,   9,      0x109,  0,     0xC0},    // 8D                                                                                                                                                                        
   {"mov",       i86,    0x1100, 0x12,   0x91,   0x209,  0,      0  },    // 8E mov segreg,r16                                                                                                                                                         
   {"pop",       t8F,    0,      0,      0,      0,      2,      0  },    // 8F Link to group 1A                                                                                                                                                       
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"nop",       t90,    0,      0,      0,      0,      9,      0  },    // 90 NOP/Pause. Link to map                                                                                                                                                 
   {"xchg",      i86,    0x1100, 3,      9,      0xa9,   0,      8  },    // 91 xchg cx,ax                                                                                                                                                             
   {"xchg",      i86,    0x1100, 3,      9,      0xa9,   0,      8  },    // 92 xchg dx,ax                                                                                                                                                             
   {"xchg",      i86,    0x1100, 3,      9,      0xa9,   0,      8  },    // 93 xchg bx,ax                                                                                                                                                             
   {"xchg",      i86,    0x1100, 3,      9,      0xa9,   0,      8  },    // 94 xchg sp,ax                                                                                                                                                             
   {"xchg",      i86,    0x1100, 3,      9,      0xa9,   0,      8  },    // 95 xchg bp,ax                                                                                                                                                             
   {"xchg",      i86,    0x1100, 3,      9,      0xa9,   0,      8  },    // 96 xchg si,ax                                                                                                                                                             
   {"xchg",      i86,    0x1100, 3,      9,      0xa9,   0,      8  },    // 97 xchg di,ax                                                                                                                                                             
   {"cbw",       t98,    0x1100, 0,      0,      0,      8,      0  },    // 98 Link to map                                                                                                                                                            
   {"cwd",       t99,    0x1100, 0,      0,      0,      8,      0  },    // 99 Link to map                                                                                                                                                            
   {"call",      i86n64, 0x182,  0x200,  0x85,   0,      0,      8  },    // 9A call far                                                                                                                                                               
   {"fwait",     0x100,  0,      2,      0,      0,      0,      0  },    // 9B                                                                                                                                                                        
   {"pushf",     t9C,    0x2100, 0,      0,      0,      8,      0  },    // 9C Link to map: pushf/d/q                                                                                                                                                 
   {"popf",      t9D,    0x2100, 0,      0,      0,      8,      0  },    // 9D Link to map: popf/d/q                                                                                                                                                  
   {"sahf",      i86,    0,      2,      0,      0,      0,      0  },    // 9E                                                                                                                                                                        
   {"lahf",      i86,    0,      2,      0,      0,      0,      8  },    // 9F                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"mov",       i86,    5,      0x401,  0xa1,   0x101,  0,      0  },    // A0 mov al,mem                                                                                                                                                             
   {"mov",       i86,    0x1105, 0x401,  0xa9,   0x109,  0,      0  },    // A1 mov ax,mem                                                                                                                                                             
   {"mov",       i86,    5,      0x401,  0x101,  0xa1,   0,      0  },    // A2 mov mem,al                                                                                                                                                             
   {"mov",       i86,    0x1105, 0x401,  0x109,  0xa9,   0,      0  },    // A3 mov mem,ax                                                                                                                                                             
   {"movs",      i86,    0x25,   1,      0xc2,   0xc1,   0,      8  },    // A4 movsb                                                                                                                                                                  
   {"movs",      i86,    0x1125, 1,      0xc2,   0xc1,   0,      8  },    // A5 movsw                                                                                                                                                                  
   {"cmps",      i86,    0x45,   1,      0xc2,   0xc1,   0,      8  },    // A6 cmpsb                                                                                                                                                                  
   {"cmps",      i86,    0x1145, 1,      0xc2,   0xc1,   0,      8  },    // A7 cmpsw                                                                                                                                                                  
   {"test",      i86,    0,      0x41,   0xa1,   0x5000, 0,      4  },    // A8 test al,ib                                                                                                                                                             
   {"test",      i86,    0x1100, 0x81,   0xa9,   0x7000, 0,      4  },    // A9 test ax,iw                                                                                                                                                             
   {"stos",      i86,    0x21,   1,      0xc2,   0,      0,      8  },    // AA stosb                                                                                                                                                                  
   {"stos",      i86,    0x1121, 1,      0xc2,   0,      0,      8  },    // AB stosw                                                                                                                                                                  
   {"lods",      i86,    0x25,   1,      0,      0xc1,   0,      8  },    // AC lodsb                                                                                                                                                                  
   {"lods",      i86,    0x1125, 1,      0,      0xc1,   0,      8  },    // AD lodsw                                                                                                                                                                  
   {"scas",      i86,    0x41,   1,      0xc2,   0,      0,      8  },    // AE scasb                                                                                                                                                                  
   {"scas",      i86,    0x1141, 1,      0xc2,   0,      0,      8  },    // AF scasw                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B0 mov al,ib                                                                                                                                                              
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B1 mov cl,ib                                                                                                                                                              
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B2 mov dl,ib                                                                                                                                                              
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B3 mov bl,ib                                                                                                                                                              
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B4 mov ah,ib                                                                                                                                                              
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B5 mov ch,ib                                                                                                                                                              
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B6 mov dh,ib                                                                                                                                                              
   {"mov",       i86,    0,      0x43,   1,      0x1000, 0,      0  },    // B7 mov bh,ib                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // B8 mov ax,iw                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // B9 mov cx,iw                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // BA mov dx,iw                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // BB mov bx,iw                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // BC mov sp,iw                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // BD mov bp,iw                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // BE mov si,iw                                                                                                                                                              
   {"mov",       i86,    0x1100, 0x103,  9,      0x1000, 0,      0  },    // BF mov di,iw                                                                                                                                                              
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"grp2",      tC0,    0,      0,      0,      0,      2,      0  },    // C0 link to grp 2                                                                                                                                                          
   {"grp2",      tC1,    0,      0,      0,      0,      2,      0  },    // C1 link to grp 2                                                                                                                                                          
   {"ret",       i86,    0x102,  0x22,   0,      0x1000, 0,     0x10},    // C2 retn iw                                                                                                                                                                
   {"ret",       i86,    0x102,  2,      0,      0,      0,     0x10},    // C3 retn                                                                                                                                                                   
   {"les",       i86n64, 0x100,  0x812,  9,      0x10c,  0,      0  },    // C4 les                                                                                                                                                                    
   {"lds",       i86n64, 0x100,  0x812,  9,      0x10c,  0,      0  },    // C5 lds                                                                                                                                                                    
   {"mov",       tC6,    0,      0,      0,      0,      2,      0  },    // C6 link to grp 11                                                                                                                                                         
   {"mov",       tC7,    0,      0,      0,      0,      2,      0  },    // C7 link to grp 11                                                                                                                                                         
   {"enter",     i86,    0,      0x62,   0,      0x1000, 0,      8  },    // C8                                                                                                                                                                        
   {"leave",     i86,    0,      2,      0,      0,      0,      8  },    // C9                                                                                                                                                                        
   {"retf",      i86,    2,      0x22,   0,      0x1000, 0,     0x10},    // CA retf iw                                                                                                                                                                
   {"retf",      i86,    2,      2,      0,      0,      0,     0x10},    // CB retf                                                                                                                                                                   
   {"int 3;breakpoint or filler",0,0,2,  0,      0,      0,     0x48},    // CC                                                                                                                                                                        
   {"int",       i86,    0,      0x42,   0,      0x1000, 0,      8  },    // CD                                                                                                                                                                        
   {"into",      i86n64, 0,      2,      0,      0,      0,      0  },    // CE                                                                                                                                                                        
   {0,           tCF,    0x1100, 0,      0,      0,      8,      0  },    // CF link to IRET                                                                                                                                                           
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"grp2",      tD0,    0,      0,      0,      0,      2,      0  },    // D0 link to grp 2                                                                                                                                                          
   {"grp2",      tD1,    0,      0,      0,      0,      2,      0  },    // D1 link to grp 2                                                                                                                                                          
   {"grp2",      tD2,    0,      0,      0,      0,      2,      0  },    // D2 link to grp 2                                                                                                                                                          
   {"grp2",      tD3,    0,      0,      0,      0,      2,      0  },    // D3 link to grp 2                                                                                                                                                          
   {"aam",       i86n64, 0,   0x42,      0,      0x1000, 0,      8  },    // D4. Don't show immediate operand if = 10 !                                                                                                                                
   {"aad",       i86n64, 0,   0x42,      0,      0x1000, 0,      8  },    // D5. Don't show immediate operand if = 10 !                                                                                                                                
   {"salc",      i86n64, 0,   0x4002,    0,      0,      0,      0  },    // D6 salc (undocumented opcode)                                                                                                                                             
   {"xlat",      i86,    5,      1,      0,      0xc0,   0,      8  },    // D7                                                                                                                                                                        
   {"x87 instr", tD8,    0,      0,      0,      0,      4,      0  },    // D8 link to FP grp                                                                                                                                                         
   {"x87 instr", tD9,    0,      0,      0,      0,      4,      0  },    // D9 link to FP grp                                                                                                                                                         
   {"x87 instr", tDA,    0,      0,      0,      0,      4,      0  },    // DA link to FP grp                                                                                                                                                         
   {"x87 instr", tDB,    0,      0,      0,      0,      4,      0  },    // DB link to FP grp                                                                                                                                                         
   {"x87 instr", tDC,    0,      0,      0,      0,      4,      0  },    // DC link to FP grp                                                                                                                                                         
   {"x87 instr", tDD,    0,      0,      0,      0,      4,      0  },    // DD link to FP grp                                                                                                                                                         
   {"x87 instr", tDE,    0,      0,      0,      0,      4,      0  },    // DE link to FP grp                                                                                                                                                         
   {"x87 instr", tDF,    0,      0,      0,      0,      4,      0  },    // DF link to FP grp                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"loopne",    i86,    0x80,   0x42,   0x81,   0,      0,      8  },    // E0                                                                                                                                                                        
   {"loope",     i86,    0x80,   0x42,   0x81,   0,      0,      8  },    // E1                                                                                                                                                                        
   {"loop",      i86,    0x80,   0x42,   0x81,   0,      0,      8  },    // E2                                                                                                                                                                        
   {"j(e/r)cxz", tE3,    0,      0,      0,      0,      0xA,    0  },    // E3 link to map                                                                                                                                                            
   {"in",        i86p,   0,      0x41,   0xa1,   0x1000, 0,      0  },    // E4 in al,ib                                                                                                                                                               
   {"in",        i86p,   0x100,  0x41,   0xa8,   0x1000, 0,      0  },    // E5 in ax,ib                                                                                                                                                               
   {"out",       i86p,   0,      0x41,   0x1000, 0xa1,   0,      0  },    // E6 out ib,al                                                                                                                                                              
   {"out",       i86p,   0x100,  0x41,   0x1000, 0xa8,   0,      0  },    // E7 out ib,ax                                                                                                                                                              
   {"call",      i86,    0x82,   0x82,   0x83,   0,      0,      8  },    // E8 call near                                                                                                                                                              
   {"jmp",       i86,    0x80,   0x82,   0x82,   0,      0,     0x90},    // E9 jmp near                                                                                                                                                               
   {"jmp",       i86n64, 0x80,   0x202,  0x84,   0,      0,     0x10},    // EA jmp far                                                                                                                                                                
   {"jmp",       i86,    0x80,   0x42,   0x81,   0,      0,     0x10},    // EB jmp short                                                                                                                                                              
   {"in",        i86p,   0,      1,      0xa1,   0xb2,   0,      0  },    // EC in al,dx                                                                                                                                                               
   {"in",        i86p,   0x100,  1,      0xa8,   0xb2,   0,      0  },    // ED in ax,dx                                                                                                                                                               
   {"out",       i86p,   0,      1,      0xb2,   0xa1,   0,      0  },    // EE out dx,al                                                                                                                                                              
   {"out",       i86p,   0x100,  1,      0xb2,   0xa8,   0,      0  },    // EF out dx,ax                                                                                                                                                              
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"lock:",     i86,    0,      0x8000, 0,      0,      0,      0  },    // F0 lock prefix                                                                                                                                                            
   {"icebp",     i86n64, 0,      0x4002, 0,      0,      0,      0  },    // F1 ICE breakpoint, undocumented opcode                                                                                                                                    
   {"repne:",    i86,    0,      0x8000, 0,      0,      0,      0  },    // F2 repne prefix                                                                                                                                                           
   {"repe:",     i86,    0,      0x8000, 0,      0,      0,      0  },    // F3 repe  prefix                                                                                                                                                           
   {"hlt",       i86,    0,      2,      0,      0,      0,     0x48},    // F4                                                                                                                                                                        
   {"cmc",       i86,    0,      2,      0,      0,      0,      0  },    // F5                                                                                                                                                                        
   {"grp3",      tF6,    0,      0,      0,      0,      2,      0  },    // F6 link to grp 3                                                                                                                                                          
   {"grp3",      tF7,    0,      0,      0,      0,      2,      0  },    // F7 link to grp 3                                                                                                                                                          
   {"clc",       i86,    0,      2,      0,      0,      0,      0  },    // F8                                                                                                                                                                        
   {"stc",       i86,    0,      2,      0,      0,      0,      0  },    // F9                                                                                                                                                                        
   {"cli",       i86p,   0,      2,      0,      0,      0,      0  },    // FA                                                                                                                                                                        
   {"sti",       i86p,   0,      2,      0,      0,      0,      0  },    // FB                                                                                                                                                                        
   {"cld",       i86,    0,      2,      0,      0,      0,      0  },    // FC                                                                                                                                                                        
   {"std",       i86,    0,      2,      0,      0,      0,      0  },    // FD                                                                                                                                                                        
   {"grp4",      tFE,    0,      0,      0,      0,      2,      0  },    // FE link to grp 4                                                                                                                                                          
   {"grp5",      tFF,    0,      0,      0,      0,      2,      0  }     // FF link to grp 5                                                                                                                                                          
};                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                       
// Secondary opcode map for 2-byte opcode. First byte = 0F                                                                                                                                                                                             
// Indexed by second opcode byte                                                                                                                                                                                                                       
SOpcodeDef OpcodeMap0F[256] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"grp6",      t0F00,  0,      0,      0,      0,      2,      0  },    // 0F 00 link to grp 6; sldt etc.                                                                                                                                            
   {"grp7",      t0F01,  0,      0,      0,      0,      4,      0  },    // 0F 01 link to grp 7; sgdt etc.                                                                                                                                            
   {0,           t0F02,  0,      0,      0,      0,      3,      0  },    // 0F 02 link to lar                                                                                                                                                         
   {0,           t0F03,  0,      0,      0,      0,      3,      0  },    // 0F 03 link to lsl                                                                                                                                                         
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {"syscall",   iP5,    0,      1,      0,      0,      0,      8  },    // 0F 05                                                                                                                                                                     
   {"clts",      iP5p,   0,      1,      0,      0,      0,      0  },    // 0F 06                                                                                                                                                                     
   {"sysret",    iP5p,   0,      1,      0,      0,      0,     0x10},    // 0F 07                                                                                                                                                                     
   {"invd",      i486p,  0,      1,      0,      0,      0,      0  },    // 0F 08                                                                                                                                                                     
   {"wbinvd",    i486p,  0,      1,      0,      0,      0,      0  },    // 0F 09                                                                                                                                                                     
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {"ud2",       i386,   0,      1,      0,      0,      0,     0x10},    // 0F 0B                                                                                                                                                                     
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {"PREFETCH;AMD only",0x1001,0,0x11,   0,      0x106,  0,      0  },    // 0F 0D. AMD only. Works as NOP on Intel                                                                                                                                    
   {"FEMS",      iK3D,   0,      2,      0,      0,      0,      0  },    // 0F OE. AMD only                                                                                                                                                           
   {0,           t0F0F,  0,      0x52,   0,      0,      6,      0  },    // 0F 0F. Link to tertiary map for AMD 3DNow instructions                                                                                                                    
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0F10,  0,      0,      0,      0,      9,      0  },    // Link to tertiary map: movups, etc.                                                                                                                                        
   {0,           t0F11,  0,      0,      0,      0,      9,      0  },    // Link to tertiary map: movups, etc.                                                                                                                                        
   {0,           t0F12,  0,      0,      0,      0,      9,      0  },    // Link to tertiary map: movlps, etc.                                                                                                                                        
   {"movl",      iSSE,   0x200,  0x13,   0x110,  0x6F,   0,      1  },    // 0F 13 movlps/pd                                                                                                                                                           
   {"unpckl",    iSSE,   0x200,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 14 unpcklps/pd                                                                                                                                                         
   {"unpckh",    iSSE,   0x200,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 15 unpckhps/pd                                                                                                                                                         
   {0,           t0F16,  0,      0,      0,      0,      9,      0  },    // Link to tertiary map: movhps, etc.                                                                                                                                        
   {"movh",      iSSE,   0x200,  0x13,   0x110,  0x6F,   0,      1  },    // 0F 17 movhps/pd                                                                                                                                                           
   {0,           t0F18,  0,      0,      0,      0,      2,      0  },    // Link to tertiary map: group 16                                                                                                                                            
   {"hint",      iP6,    0,      0x2012, 0,      0x206,  0,      0  },    // 0F 19. Hint instructions reserved for future use                                                                                                                          
   {"hint",      iP6,    0,      0x2012, 0,      0x206,  0,      0  },    // 0F 1A. Hint instructions reserved for future use                                                                                                                          
   {"hint",      iP6,    0,      0x2012, 0,      0x206,  0,      0  },    // 0F 1B. Hint instructions reserved for future use                                                                                                                          
   {"hint",      iP6,    0,      0x2012, 0,      0x206,  0,      0  },    // 0F 1C. Hint instructions reserved for future use                                                                                                                          
   {"hint",      iP6,    0,      0x2012, 0,      0x206,  0,      0  },    // 0F 1D. Hint instructions reserved for future use                                                                                                                          
   {"hint",      iP6,    0,      0x2012, 0,      0x206,  0,      0  },    // 0F 1E. Hint instructions reserved for future use                                                                                                                          
   {"nop",       iP6,    0,      0x11,   0,      0x200,  0,     0x40},    // 0F 1F. Multi-byte nop                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"mov",       i386p,  0,      0x13,   0xA,    0x92,   0,      0  },    // 0F 20. mov r32/64,cr                                                                                                                                                      
   {"mov",       i386p,  0x1000, 0x13,   9,      0x93,   0,      0  },    // 0F 21. mov r32,dr                                                                                                                                                         
   {"mov",       i386p,  0,      0x12,   0x92,   0xA,    0,      0  },    // 0F 22. mov cr,r32/64                                                                                                                                                      
   {"mov",       i386p,  0x1000, 0x12,   0x93,   9,      0,      0  },    // 0F 23. mov dr,r32                                                                                                                                                         
#if 0 // Opcode 0F 24 has two meanings:                                                                                                                                                                                                                
      // 1: mov r32,tr (obsolete, 80386 only)                                                                                                                                                                                                          
   {"mov;80386 only",0x803,0,    0x4013, 3,      0x94,   0,      0  },    // 0F 24. mov r32,tr (80386 only) !! SSE5 4-operand w DREX                                                                                                                   
#else                                                                                                                                                                                                                                                  
      // 2: start of 3-byte opcode for AMD SSE5 instructions                                                                                                                                                                                           
   {0,           t0F24,   0,      0,      0,      0,      1,      0  },    // 0F 24. Link to tertiary map for 3-byte opcodes AMD SSE5 with four operands                                                                                               
#endif                                                                                                                                                                                                                                                 
   {0,           t0F25,   0,      0,      0,      0,      1,      0  },    // 0F 25. Link to tertiary map for 3-byte opcodes AMD SSE5 with three operands + immediate byte                                                                             
   {"mov;80386 only",i386p,0,    0x4012, 0x94,   3,      0,      0  },    // 0F 26. mov tr,r32 (80386 only)                                                                                                                                            
   {0,           i386p,  0,      0x4012, 3,      3,      0,      0  },    // 0F 27. illegal                                                                                                                                                            
   {"mova",      iSSE,   0x200,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 28. movaps/pd                                                                                                                                                          
   {"mova",      iSSE,   0x200,  0x13,   0x26F,  0x6F,   0,      1  },    // 0F 29. movaps/pd                                                                                                                                                          
   {0,           t0F2A,   0,      0,      0,      0,      9,      0  },    // 0F 2A. Link to tertiary map: cvtpi2ps, etc.                                                                                                                              
  // {"movnt",     SSE   ,   0x200,  0x13,   0x16F,  0x6F,   0,      1  },    // 0F 2B. movntps/pd  #as changed for SSE4a => new OpcodeMap                                                                                                               
   {0,           t0F2B,  0,      0,      0,      0,      9,      0  },    // 0F 2B. Link to tertiary map: movntps/pd/ss/sd #as                                                                                                                         
   {0,           t0F2C,  0,      0,      0,      0,      9,      0  },    // 0F 2C. Link to tertiary map: cvttps2pi, etc.                                                                                                                              
   {0,           t0F2D,  0,      0,      0,      0,      9,      0  },    // 0F 2D. Link to tertiary map: cvtps2pi, etc.                                                                                                                               
   {0,           t0F2E,  0,      0,      0,      0,      9,      0  },    // 0F 2E. Link to tertiary map: ucomiss/sd                                                                                                                                   
   {0,           t0F2F,  0,      0,      0,      0,      9,      0  },    // 0F 2F. Link to tertiary map: comiss/sd                                                                                                                                    
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"wrmsr",     iP5p,   0x1000, 1,      0,      0,      0,      0  },    // 0F 30                                                                                                                                                                     
   {"rdtsc",     iP5,    0,      1,      0,      0,      0,      8  },    // 0F 31                                                                                                                                                                     
   {"rdmsr",     iP5p,   0x1000, 1,      0,      0,      0,      8  },    // 0F 32                                                                                                                                                                     
   {"rdpmc",     iP5,    0,      1,      0,      0,      0,      8  },    // 0F 33                                                                                                                                                                     
   {"sysenter",  iPII,    0,      1,      0,      0,      0,      8  },    // 0F 34                                                                                                                                                                     
   {"sysexit;Same name with or without 48h prefix",0x808,0x1000,1,0,0,0,0},// 0F 35                                                                                                                                                                    
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F 36 Illegal                                                                                                                                                             
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F 37 Illegal                                                                                                                                                             
   {0,           t0F38,  0,      0,      0,      0,      1,      0  },    // 0F 38. Link to tertiary map for 3-byte opcodes                                                                                                                            
   {0,           t0F39,  0,      0,      0,      0,      1,      0  },    // 0F 39. Link to tertiary map for 3-byte opcodes                                                                                                                            
   {0,           t0F3A,  0,      0,      0,      0,      1,      0  },    // 0F 3A. Link to tertiary map for 3-byte opcodes                                                                                                                            
   {0,           t0F3B,  0,      0,      0,      0,      1,      0  },    // 0F 3B. Link to tertiary map for 3-byte opcodes                                                                                                                            
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F 3C Illegal                                                                                                                                                             
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F 3D Illegal                                                                                                                                                             
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F 3E Illegal                                                                                                                                                             
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F 3F Illegal                                                                                                                                                             
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cmovo",     iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 40. cmov                                                                                                                                                               
   {"cmovno",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 41. cmov                                                                                                                                                               
   {"cmovc",     iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 42. cmov                                                                                                                                                               
   {"cmovnc",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 43. cmov                                                                                                                                                               
   {"cmove",     iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 44. cmov                                                                                                                                                               
   {"cmovne",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 45. cmov                                                                                                                                                               
   {"cmovbe",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 46. cmov                                                                                                                                                               
   {"cmova",     iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 47. cmov                                                                                                                                                               
   {"cmovs",     iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 48. cmov                                                                                                                                                               
   {"cmovns",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 49. cmov                                                                                                                                                               
   {"cmovpe",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 4A. cmov                                                                                                                                                               
   {"cmovpo",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 4B. cmov                                                                                                                                                               
   {"cmovl",     iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 4C. cmov                                                                                                                                                               
   {"cmovge",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 4D. cmov                                                                                                                                                               
   {"cmovle",    iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 4E  cmov                                                                                                                                                               
   {"cmovg",     iP6,    0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F 4F. cmov                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movmsk",    iSSE,   0x1200, 0x12,   9,      0x6F,   0,      1  },    // 0F 50. movmskps/pd                                                                                                                                                        
   {"sqrt",      iSSE,   0xE00,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 51. sqrtps/pd/ss/sd                                                                                                                                                    
   {"rsqrt",     iSSE,   0x400,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 52. rsqrtps/ss                                                                                                                                                         
   {"rcp",       iSSE,   0x400,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 53. rcpps/ss                                                                                                                                                           
   {"and",       iSSE,   0x200,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 54. andps/pd                                                                                                                                                           
   {"andn",      iSSE,   0x200,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 55. andnps/pd                                                                                                                                                          
   {"or",        iSSE,   0x200,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 56. orps/pd                                                                                                                                                            
   {"xor",       iSSE,   0x200,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 57. xorps/pd                                                                                                                                                           
   {"add",       iSSE,   0xE00,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 58. addps/pd/ss/sd                                                                                                                                                     
   {"mul",       iSSE,   0xE00,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 59. mulps/pd/ss/sd                                                                                                                                                     
   {0,           t0F5A,  0,      0,      0,      0,      9,      0  },    // 0F 5A. Link to tertiary map: cvtps2pd, etc.                                                                                                                               
   {0,           t0F5B,  0,      0,      0,      0,      9,      0  },    // 0F 5B. Link to tertiary map: cvtdq2ps, etc.                                                                                                                               
   {"sub",       iSSE,   0xE00,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 5C. subps/pd/ss/sd                                                                                                                                                     
   {"min",       iSSE,   0xE00,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 5D. minps/pd/ss/sd                                                                                                                                                     
   {"div",       iSSE,   0xE00,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 5E. divps/pd/ss/sd                                                                                                                                                     
   {"max",       iSSE,   0xE00,  0x12,   0x6F,   0x26F,  0,      1  },    // 0F 5F. maxps/pd/ss/sd                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"punpcklbw", iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F 60                                                                                                                                                                     
   {"punpcklwd", iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 61                                                                                                                                                                     
   {"punpckldq", iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 62                                                                                                                                                                     
   {"packsswb",  iMMX,   0x200,  0x12,   0x31,   0x232,  0,      0  },    // 0F 63                                                                                                                                                                     
   {"pcmpgtb",   iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F 64                                                                                                                                                                     
   {"pcmpgtw",   iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 65                                                                                                                                                                     
   {"pcmpgtd",   iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 66                                                                                                                                                                     
   {"packuswb",  iMMX,   0x200,  0x12,   0x31,   0x232,  0,      0  },    // 0F 67                                                                                                                                                                     
   {"punpckhbw", iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F 68                                                                                                                                                                     
   {"punpckhwd", iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 69                                                                                                                                                                     
   {"punpckhdq", iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 6A                                                                                                                                                                     
   {"packssdw",  iMMX,   0x200,  0x12,   0x32,   0x233,  0,      0  },    // 0F 6B                                                                                                                                                                     
   {"punpcklqdq",iSSE2,  0x8200, 0x12,   0x24,   0x224,  0,      0  },    // 0F 6C. Not valid without 66 prefix                                                                                                                                        
   {"punpckhqdq",iSSE2,  0x8200, 0x12,   0x24,   0x224,  0,      0  },    // 0F 6D. Not valid without 66 prefix                                                                                                                                        
   {0,           t0F6E,  0,      0,      0,      0,      8,      0  },    // 0F 6E. Link to tertiary map: movd/movq                                                                                                                                    
   {0,           t0F6F,  0,      0,      0,      0,      9,      0  },    // 0F 6F. Link to tertiary map: movq/movdqa/movdqu                                                                                                                           
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0F70,  0,      0,      0,      0,      9,      0  },    // 0F 70. Link to tertiary map: pshufw, etc.                                                                                                                                 
   {0,           t0F71,  0,      0,      0,      0,      2,      0  },    // 0F 71. Link to tertiary map for group 12                                                                                                                                  
   {0,           t0F72,  0,      0,      0,      0,      2,      0  },    // 0F 72. Link to tertiary map for group 13                                                                                                                                  
   {0,           t0F73,  0,      0,      0,      0,      2,      0  },    // 0F 73. Link to tertiary map for group 14                                                                                                                                  
   {"pcmpeqb",   iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F 74                                                                                                                                                                     
   {"pcmpeqw",   iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 75                                                                                                                                                                     
   {"pcmpeqd",   iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 76                                                                                                                                                                     
   {"emms",      iMMX,   0,      2,      0,      0,      0,      0  },    // 0F 77                                                                                                                                                                     
 //{"vmread",    iVMi,   0x1000, 0x13,   0x204,  4,      0,      0  },    // 0F 78  #as                                                                                                                                                              
 //{"vmread",    iVMi,   0x1000, 0x12,   4,      0x204,  0,      0  },    // 0F 79 should be vmwrite #as                                                                                                                                             
   {0,           t0F78,  0,      0,      0,      0,      9,      0  },    // 0F 78 Link to tertiary map: vmread,  etc. #as changed => new Opcodemap                                                                                                    
   {0,           t0F79,  0,      0,      0,      0,      9,      0  },    // 0F 79 Link to tertiary map: vmwrite, etc. #as changed => new Opcodemap                                                                                                    
                                                                                                                                                                                                                                                       
   {0,           t0F7A,  0,      0,      0,      0,      1,      0  },    // 0F 7A. Link to tertiary map for 3-byte opcodes AMD SSE5: FRCZPS, etc.                                                                                                     
   {0,           t0F7B,  0,      0,      0,      0,      1,      0  },    // 0F 7B. Link to tertiary map for 3-byte opcodes AMD SSE5: PROTB, etc.                                                                                                      
   {0,           t0F7C,  0xA00,  0,      0,      0,      9,      0  },    // 0F 7C. Link to tertiary map: hadd                                                                                                                                         
   {0,           t0F7D,  0xA00,  0,      0,      0,      9,      0  },    // 0F 7D. Link to tertiary map: hsub                                                                                                                                         
   {0,           t0F7E,  0,      0,      0,      0,      9,      0  },    // 0F 7E. Link to tertiary map: movd/movq                                                                                                                                    
   {0,           t0F7F,  0,      0,      0,      0,      9,      0  },    // 0F 7F. Link to tertiary map: movq/movdqa/movdqu                                                                                                                           
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"jo",        i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 80                                                                                                                                                                     
   {"jno",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 81                                                                                                                                                                     
   {"jb",        i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 82                                                                                                                                                                     
   {"jae",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 83                                                                                                                                                                     
   {"je",        i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 84                                                                                                                                                                     
   {"jne",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 85                                                                                                                                                                     
   {"jbe",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 86                                                                                                                                                                     
   {"ja",        i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 87                                                                                                                                                                     
   {"js",        i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 88                                                                                                                                                                     
   {"jns",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 89                                                                                                                                                                     
   {"jpe",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 8A                                                                                                                                                                     
   {"jpo",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 8B                                                                                                                                                                     
   {"jl",        i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 8C                                                                                                                                                                     
   {"jge",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 8D                                                                                                                                                                     
   {"jle",       i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 8E                                                                                                                                                                     
   {"jg",        i386,   8,      0x80,   0x82,   0,      0,     0x80},    // 0F 8F                                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"seto",      i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 90                                                                                                                                                                     
   {"setno",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 91                                                                                                                                                                     
   {"setb",      i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 92                                                                                                                                                                     
   {"setae",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 93                                                                                                                                                                     
   {"sete",      i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 94                                                                                                                                                                     
   {"setne",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 95                                                                                                                                                                     
   {"setbe",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 96                                                                                                                                                                     
   {"seta",      i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 97                                                                                                                                                                     
   {"sets",      i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 98                                                                                                                                                                     
   {"setns",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 99                                                                                                                                                                     
   {"setpe",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 9A                                                                                                                                                                     
   {"setpo",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 9B                                                                                                                                                                     
   {"setl",      i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 9C                                                                                                                                                                     
   {"setge",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 9D                                                                                                                                                                     
   {"setle",     i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 9E                                                                                                                                                                     
   {"setg",      i386,   0,      0x11,   0x201,  0,      0,      0  },    // 0F 9F                                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"push fs",   i386,   2,      1,      0,      0,      0,      0  },    // 0F A0                                                                                                                                                                     
   {"pop  fs",   i386,   2,      1,      0,      0,      0,      0  },    // 0F A1                                                                                                                                                                     
   {"cpuid",     i486,     0,      1,      0,      0,      0,      8  },    // 0F A2                                                                                                                                                                     
   {"bt",        i386,   0x1100, 0x13,   0x209,  9,      0,      0  },    // 0F A3                                                                                                                                                                     
   {"shld",      i386,   0x1100, 0x53,   0x209,  0x1009, 0,      0  },    // 0F A4                                                                                                                                                                     
   {"shld",      i386,   0x1100, 0x13,   0x209,  0x0809, 0,      0  },    // 0F A5                                                                                                                                                                     
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F A6. Illegal                                                                                                                                                            
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0F A7. Illegal                                                                                                                                                            
   {"push gs",   i386,   2,      1,      0,      0,      0,      0  },    // 0F A8                                                                                                                                                                     
   {"pop  gs",   i386,   2,      1,      0,      0,      0,      0  },    // 0F A9                                                                                                                                                                     
   {"rsm",       i386p,  0,      1,      0,      0,      0,      0  },    // 0F AA                                                                                                                                                                     
   {"bts",       i386,   0x1100, 0x13,   0x209,  9,      0,      0  },    // 0F AB                                                                                                                                                                     
   {"shrd",      i386,   0x1100, 0x53,   0x209,  0x1009, 0,      0  },    // 0F AC                                                                                                                                                                     
   {"shrd",      i386,   0x1100, 0x13,   0x209,  0x0809, 0,      0  },    // 0F AD                                                                                                                                                                     
   {0,           t0FAE,  0,      0,      0,      0,      4,      0  },    // 0F AE. Link to tertiary map for group 15                                                                                                                                  
   {"imul",      i186,     0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F AF                                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cmpxchg",   i386,   0x10,   0x13,   0x101,  1,      0,      0  },    // 0F B0                                                                                                                                                                     
   {"cmpxchg",   i386,   0x1110, 0x13,   0x109,  9,      0,      0  },    // 0F B1                                                                                                                                                                     
   {"lss",       i86,    0x1100, 0x812,  9,      0x10D,  0,      0  },    // 0F B2 (valid in 64-bit mode)                                                                                                                                              
   {"btr",       i386,   0x1100, 0x13,   0x209,  9,      0,      0  },    // 0F B3                                                                                                                                                                     
   {"lfs",       i86,    0x1100, 0x812,  9,      0x10D,  0,      0  },    // 0F B4                                                                                                                                                                     
   {"lgs",       i86,    0x1100, 0x812,  9,      0x10D,  0,      0  },    // 0F B5                                                                                                                                                                     
   {"movzx",     i386,   0x1100, 0x12,   9,      0x201,  0,      0  },    // 0F B6                                                                                                                                                                     
   {"movzx",     i386,   0x1100, 0x12,   9,      0x202,  0,      0  },    // 0F B7                                                                                                                                                                     
   {0,           t0FB8,  0,      0,      0,      0,      9,      0  },    // 0F B8. Link to tertiary map for popcnt, jmpe                                                                                                                              
   {0,           t0FB9,  0,      0,      0,      0,      2,      0  },    // 0F B9. Link to tertiary map for group 10: ud1                                                                                                                             
   {0,           t0FBA,  0,      0,      0,      0,      2,      0  },    // 0F BA. Link to tertiary map for group 8: bt                                                                                                                               
   {"btc",       i386,   0x1100, 0x13,   0x209,  9,      0,      0  },    // 0F BB                                                                                                                                                                     
   {"bsf",       i386,   0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F BC                                                                                                                                                                     
 //{"bsr",       i386,   0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F BD # as Changed => new OpcodeMap 0FBD                                                                                                                                  
   {0,           t0FBD,  0,      0,      0,      0,      9,      0  },    // 0F BD. Link to tertiary map for bsf, LZCNT #as                                                                                                                            
                                                                                                                                                                                                                                                       
   {"movsx",     i386,   0x1100, 0x12,   9,      0x201,  0,      0  },    // 0F BE                                                                                                                                                                     
   {"movsx",     i386,   0x1100, 0x12,   9,      0x202,  0,      0  },    // 0F BF                                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"xadd",      i486,     0x10,   0x13,   0x201,  1,      0,      0  },    // 0F C0                                                                                                                                                                     
   {"xadd",      i486,     0x1110, 0x13,   0x209,  9,      0,      0  },    // 0F C1                                                                                                                                                                     
   {0,           t0FC2,  0,      0x52,   0,      0,      6,      0  },    // 0F C2. Link to tertiary map for cmpps etc.                                                                                                                                
   {"movnti",    iMemSSE2,0x1000,0x13,   0x109,  9,      0,      0  },    // 0F C3                                                                                                                                                                     
   {0,           t0FC4,  0,      0,      0,      0,      3,      0  },    // 0F C4. Link to pinsrw                                                                                                                                                     
   {"pextrw",    iMMX2,  0x1200, 0x52,   9,      0x1032, 0,      0  },    // 0F C5                                                                                                                                                                     
   {"shuf",      iSSE,   0x200,  0x52,   0x6F,   0x126F, 0,      1  },    // 0F C6                                                                                                                                                                     
   {0,           t0FC7,  0,      0,      0,      0,      2,      0  },    // 0F C7. Link to tertiary map for group 9                                                                                                                                   
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F C8. bswap eax                                                                                                                                                          
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F C9. bswap ecx                                                                                                                                                          
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F CA. bswap edx                                                                                                                                                          
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F CB. bswap ebx                                                                                                                                                          
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F CC. bswap esp                                                                                                                                                          
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F CD. bswap ebp                                                                                                                                                          
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F CE. bswap esi                                                                                                                                                          
   {"bswap",     i386,   0x1000, 3,      9,      0,      0,      0  },    // 0F CF. bswap edi                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0FD0,  0xA00,  0,      0,      0,      9,      0  },    // 0F D0. Link to addsubps/pd                                                                                                                                                
   {"psrlw",     iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F D1                                                                                                                                                                     
   {"psrld",     iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F D2                                                                                                                                                                     
   {"psrlq",     iMMX,   0x200,  0x12,   0x34,   0x234,  0,      0  },    // 0F D3                                                                                                                                                                     
   {"paddq",     iSSE2,  0x200,  0x12,   0x34,   0x234,  0,      0  },    // 0F D4                                                                                                                                                                     
   {"pmullw",    iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F D5                                                                                                                                                                     
   {0,           t0FD6,  0,      0,      0,      0,      9,      0  },    // 0F D6. Link to tertiary map for movq2dq etc.                                                                                                                              
   {"pmovmskb",  iMMX2,  0x1200, 0x12,   0x9,    0x030,  0,      0  },    // 0F D7                                                                                                                                                                     
   {"psubusb",   iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F D8                                                                                                                                                                     
   {"psubusw",   iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F D9                                                                                                                                                                     
   {"pminub",    iMMX2,  0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F DA                                                                                                                                                                     
   {"pand",      iMMX,   0x200,  0x12,   0x30,   0x230,  0,      0  },    // 0F DB                                                                                                                                                                     
   {"paddusb",   iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F DC                                                                                                                                                                     
   {"paddusw",   iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F DD                                                                                                                                                                     
   {"pmaxub",    iMMX2,  0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F DE                                                                                                                                                                     
   {"pandn",     iMMX,   0x200,  0x12,   0x30,   0x230,  0,      0  },    // 0F DF                                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pavgb",     iMMX2,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F E0                                                                                                                                                                     
   {"psraw",     iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F E1                                                                                                                                                                     
   {"psrad",     iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F E2                                                                                                                                                                     
   {"pavgw",     iMMX2,  0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F E3                                                                                                                                                                     
   {"pmulhuw",   iMMX2,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F E4                                                                                                                                                                     
   {"pmulhw",    iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F E5                                                                                                                                                                     
   {0,           t0FE6,  0xE00,  0,      0,      0,      9,      0  },    // 0F E6. Link to tertiary map for cvtpd2dq etc.                                                                                                                             
   {0,           t0FE7,  0x200,  0,      0,      0,      9,      0  },    // 0F E7. Link to tertiary map for movntq                                                                                                                                    
   {"psubsb",    iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F E8                                                                                                                                                                     
   {"psubsw",    iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F E9                                                                                                                                                                     
   {"pminsw",    iMMX2,  0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F EA                                                                                                                                                                     
   {"por",       iMMX,   0x200,  0x12,   0x30,   0x230,  0,      0  },    // 0F EB                                                                                                                                                                     
   {"paddsb",    iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F EC                                                                                                                                                                     
   {"paddsw",    iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F ED                                                                                                                                                                     
   {"pmaxsw",    iMMX2,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F EE                                                                                                                                                                     
   {"pxor",      iMMX,   0x200,  0x12,   0x30,   0x230,  0,      0  },    // 0F EF                                                                                                                                                                     
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0FF0,  0x800,  0,      0,      0,      9,      0  },    // 0F F0. Link to tertiary map for lddqu                                                                                                                                     
   {"psllw",     iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F F1                                                                                                                                                                     
   {"pslld",     iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F F2                                                                                                                                                                     
   {"psllq",     iMMX,   0x200,  0x12,   0x34,   0x234,  0,      0  },    // 0F F3 //#as changed was iSSE2???                                                                                                                                                                    
   {"pmuludq",   iMMX3,  0x200,  0x12,   0x34,   0x233,  0,      0  },    // 0F F4                                                                                                                                                                     
   {"pmaddwd",   iMMX2,  0x200,  0x12,   0x33,   0x232,  0,      0  },    // 0F F5                                                                                                                                                                     
   {"psadbw",    iMMX2,  0x200,  0x12,   0x32,   0x231,  0,      0  },    // 0F F6                                                                                                                                                                     
   {0,           t0FF7,  0x200,  0,      0,      0,      9,      0  },    // 0F F7. Link to tertiary map for maskmovq                                                                                                                                  
   {"psubb",     iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F F8                                                                                                                                                                     
   {"psubw",     iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F F9                                                                                                                                                                     
   {"psubd",     iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F FA                                                                                                                                                                     
   {"psubq",     iMMX3,  0x200,  0x12,   0x34,   0x234,  0,      0  },    // 0F FB                                                                                                                                                                     
   {"paddb",     iMMX,   0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F FC                                                                                                                                                                     
   {"paddw",     iMMX,   0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F FD                                                                                                                                                                     
   {"paddd",     iMMX,   0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F FE                                                                                                                                                                     
   {0,           i86,    0,      0,      0,      0,      0,      0  }};   // 0F EF                                                                                                                                                                     
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 38                                                                                                                                                                                      
// Indexed by third opcode byte                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F38[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pshufb",    iSSSE3, 0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F 38 00                                                                                                                                                                  
   {"phaddw",    iSSSE3, 0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 38 01                                                                                                                                                                  
   {"phaddd",    iSSSE3, 0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 38 02                                                                                                                                                                  
   {"phaddsw",   iSSSE3, 0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 38 03                                                                                                                                                                  
   {"pmaddubsw", iSSSE3, 0x200,  0x12,   0x32,   0x231,  0,      0  },    // 0F 38 04                                                                                                                                                                  
   {"phsubw",    iSSSE3, 0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 38 05                                                                                                                                                                  
   {"phsubd",    iSSSE3, 0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 38 06                                                                                                                                                                  
   {"phsubsw",   iSSSE3, 0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 38 07                                                                                                                                                                  
   {"psignb",    iSSSE3, 0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F 38 08                                                                                                                                                                  
   {"psignw",    iSSSE3, 0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 38 09                                                                                                                                                                  
   {"psignd",    iSSSE3, 0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 38 0A                                                                                                                                                                  
   {"pmulhrsw",  iSSSE3, 0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 38 0B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 0C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 0D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 0E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 0F                                                                                                                                                                  
   {"pblendvb",  iSSE41, 0x8200, 0x12,   0x21,   0x221,  0,      0  },    // 0F 38 10                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 11                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 12                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 13                                                                                                                                                                  
   {"blendvps",  iSSE41, 0x8200, 0x12,   0x6B,   0x26B,  0,      0  },    // 0F 38 14                                                                                                                                                                  
   {"blendvpd",  iSSE41, 0x8200, 0x12,   0x6C,   0x26C,  0,      0  },    // 0F 38 15                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 16                                                                                                                                                                  
   {"ptest",     iSSE41, 0x8200, 0x12,   0x20,   0x220,  0,      0  },    // 0F 38 17. Also in AMD SSE5 instruction set                                                                                                                                
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 18                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 19                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 1A                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 1B                                                                                                                                                                  
   {"pabsb",     iSSSE3, 0x200,  0x12,   0x31,   0x231,  0,      0  },    // 0F 38 1C                                                                                                                                                                  
   {"pabsw",     iSSSE3, 0x200,  0x12,   0x32,   0x232,  0,      0  },    // 0F 38 1D                                                                                                                                                                  
   {"pabsd",     iSSSE3, 0x200,  0x12,   0x33,   0x233,  0,      0  },    // 0F 38 1E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 1F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pmovsxbv",  iSSE41, 0x8200, 0x12,   0x22,   0x221,  0,      0  },    // 0F 38 20                                                                                                                                                                  
   {"pmovsxbd",  iSSE41, 0x8200, 0x12,   0x23,   0x221,  0,      0  },    // 0F 38 21                                                                                                                                                                  
   {"pmovsxbq",  iSSE41, 0x8200, 0x12,   0x24,   0x221,  0,      0  },    // 0F 38 22                                                                                                                                                                  
   {"pmovsxwd",  iSSE41, 0x8200, 0x12,   0x23,   0x222,  0,      0  },    // 0F 38 23                                                                                                                                                                  
   {"pmovsxwq",  iSSE41, 0x8200, 0x12,   0x24,   0x222,  0,      0  },    // 0F 38 24                                                                                                                                                                  
   {"pmovsxdq",  iSSE41, 0x8200, 0x12,   0x24,   0x223,  0,      0  },    // 0F 38 25                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 26                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 27                                                                                                                                                                  
   {"pmuldq",    iSSE41, 0x8200, 0x12,   0x24,   0x223,  0,      0  },    // 0F 38 28                                                                                                                                                                  
   {"pcmpeqq",   iSSE42, 0x8200, 0x12,   0x24,   0x224,  0,      0  },    // 0F 38 29                                                                                                                                                                  
   {"movntdqa",  iSSE41, 0x8200, 0x12,   0x20,   0x120,  0,      0  },    // 0F 38 2A                                                                                                                                                                  
   {"packusdw",  iSSE41, 0x8200, 0x12,   0x22,   0x223,  0,      0  },    // 0F 38 2B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 2C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 2D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 2E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 2F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pmovzxbv",  iSSE41, 0x8200, 0x12,   0x22,   0x221,  0,      0  },    // 0F 38 30                                                                                                                                                                  
   {"pmovzxbd",  iSSE41, 0x8200, 0x12,   0x23,   0x221,  0,      0  },    // 0F 38 31                                                                                                                                                                  
   {"pmovzxbq",  iSSE41, 0x8200, 0x12,   0x24,   0x221,  0,      0  },    // 0F 38 32                                                                                                                                                                  
   {"pmovzxwd",  iSSE41, 0x8200, 0x12,   0x23,   0x222,  0,      0  },    // 0F 38 33                                                                                                                                                                  
   {"pmovzxwq",  iSSE41, 0x8200, 0x12,   0x24,   0x222,  0,      0  },    // 0F 38 34                                                                                                                                                                  
   {"pmovzxdq",  iSSE41, 0x8200, 0x12,   0x24,   0x223,  0,      0  },    // 0F 38 35                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 36                                                                                                                                                                  
   {"pcmpgtq",   iSSE42, 0x8200, 0x12,   0x24,   0x224,  0,      0  },    // 0F 38 37                                                                                                                                                                  
   {"pminsb",    iSSE41, 0x8200, 0x12,   0x21,   0x221,  0,      0  },    // 0F 38 38                                                                                                                                                                  
   {"pminsd",    iSSE41, 0x8200, 0x12,   0x23,   0x223,  0,      0  },    // 0F 38 39                                                                                                                                                                  
   {"pminuw",    iSSE41, 0x8200, 0x12,   0x22,   0x222,  0,      0  },    // 0F 38 3A                                                                                                                                                                  
   {"pminud",    iSSE41, 0x8200, 0x12,   0x23,   0x223,  0,      0  },    // 0F 38 3B                                                                                                                                                                  
   {"pmaxsb",    iSSE41, 0x8200, 0x12,   0x21,   0x221,  0,      0  },    // 0F 38 3C                                                                                                                                                                  
   {"pmaxsd",    iSSE41, 0x8200, 0x12,   0x23,   0x223,  0,      0  },    // 0F 38 3D                                                                                                                                                                  
   {"pmaxuw",    iSSE41, 0x8200, 0x12,   0x22,   0x222,  0,      0  },    // 0F 38 3E                                                                                                                                                                  
   {"pmaxud",    iSSE41, 0x8200, 0x12,   0x23,   0x223,  0,      0  },    // 0F 38 3F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pmulld",    iSSE41, 0x8200, 0x12,   0x23,   0x223,  0,      0  },    // 0F 38 40                                                                                                                                                                  
   {"phminposuw",iSSE41,   0x8200, 0x12,   0x22,   0x222,  0,      0  },    // 0F 38 41                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 42                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 43                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 44                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 45                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 46                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 47                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 48                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 49                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 4A                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 4B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 4C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 4D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 4E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 4F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 50                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 51                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 52                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 53                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 54                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 55                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 56                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 57                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 58                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 59                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 5A                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 5B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 5C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 5D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 5E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 5F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 60                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 61                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 62                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 63                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 64                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 65                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 66                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 67                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 68                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 69                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 6A                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 6B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 6C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 6D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 6E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 6F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 70                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 71                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 72                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 73                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 74                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 75                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 76                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 77                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 78                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 79                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 7A                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 7B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 7C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 7D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 7E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 7F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 80                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 81                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 82                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 83                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 84                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 85                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 86                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 87                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 88                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 89                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 8A                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 8B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 8C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 8D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 8E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 8F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 90                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 91                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 92                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 93                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 94                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 95                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 96                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 97                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 98                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 99                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 9A                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 9B                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 9C                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 9D                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 9E                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 9F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A0                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A1                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A2                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A3                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A4                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A5                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A6                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A7                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A8                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 A9                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 AA                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 AB                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 AC                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 AD                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 AE                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 AF                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B0                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B1                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B2                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B3                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B4                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B5                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B6                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B7                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B8                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 B9                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 BA                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 BB                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 BC                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 BD                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 BE                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 BF                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C0                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C1                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C2                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C3                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C4                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C5                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C6                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C7                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C8                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 C9                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 CA                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 CB                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 CC                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 CD                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 CE                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 CF                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D0                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D1                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D2                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D3                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D4                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D5                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D6                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D7                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D8                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 D9                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 DA                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 DB                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 DC                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 DD                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 DE                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 DF                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E0                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E1                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E2                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E3                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E4                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E5                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E6                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E7                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E8                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 E9                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 EA                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 EB                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 EC                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 ED                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 EE                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 EF                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"crc32",     iSSE42, 0x9900, 0x12,   0x9,    0x201,  0,      0  },    // 0F 38 F0                                                                                                                                                                  
   {"crc32",     t0F38F1,0x9900, 0,      0,      0,      8,      0  },    // 0F 38 F1. Link to crc32 16/32/64 bit                                                                                                                                      
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F2                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F3                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F4                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F5                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F6                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F7                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F8                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 F9                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 FA                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 FB                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 FC                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 FD                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  },    // 0F 38 FE                                                                                                                                                                  
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  }};   // 0F 38 FF                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 39                                                                                                                                                                                      
// Not used but reserved by Intel for future extensions                                                                                                                                                                                                
SOpcodeDef OpcodeMap0F39[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2012, 0,      0,      0,      0  }};   // 0F 39 00                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 3A                                                                                                                                                                                      
// Indexed by third opcode byte                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F3A[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 00                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 01                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 02                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 03                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 04                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 05                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 06                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 07                                                                                                                                                                  
   {"roundps",   iSSE41, 0x8200, 0x52,   0x6B,   0x526B, 0,      0  },    // 0F 3A 08. Also in AMD SSE5 instruction set                                                                                                                                
   {"roundpd",   iSSE41, 0x8200, 0x52,   0x6C,   0x526C, 0,      0  },    // 0F 3A 09. Also in AMD SSE5 instruction set                                                                                                                                
   {"roundss",   iSSE41, 0x8200, 0x52,   0x4B,   0x524B, 0,      0  },    // 0F 3A 0A. Also in AMD SSE5 instruction set                                                                                                                                
   {"roundsd",   iSSE41, 0x8200, 0x52,   0x4B,   0x524B, 0,      0  },    // 0F 3A 0B. Also in AMD SSE5 instruction set                                                                                                                                
   {"blendps",   iSSE41, 0x8200, 0x52,   0x6B,   0x526B, 0,      0  },    // 0F 3A 0C                                                                                                                                                                  
   {"blendpd",   iSSE41, 0x8200, 0x52,   0x6C,   0x526C, 0,      0  },    // 0F 3A 0D                                                                                                                                                                  
   {"pblendw",   iSSE41, 0x8200, 0x52,   0x22,   0x5222, 0,      0  },    // 0F 3A 0E                                                                                                                                                                  
   {"palignr",   iSSSE3, 0x200,  0x52,   0x30,   0x5230, 0,      0  },    // 0F 3A 0F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 10                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 11                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 12                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 13                                                                                                                                                                  
   {0,           t0F3A14,0,      0,      0,      0,      3,      0  },    // 0F 3A 14. Link to pextrb                                                                                                                                                  
   {0,           t0F3A15,0,      0,      0,      0,      3,      0  },    // 0F 3A 15. Link to pextrw                                                                                                                                                  
   {0,           t0F3A16,0,      0,      0,      0,      8,      0  },    // 0F 3A 16. Link to pextrd, pextrq                                                                                                                                          
   {"extractps", iSSE41, 0x9200, 0x53,   0x209,  0x506B, 0,      0  },    // 0F 3A 17                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 18                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 19                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 1A                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 1B                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 1C                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 1D                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 1E                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 1F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0F3A20,0,      0,      0,      0,      3,      0  },    // 0F 3A 20. Link to pinsrb                                                                                                                                                  
   {"insertps",  iSSE41, 0x8200, 0x52,   0x6B,   0x5003, 0,      0  },    // 0F 3A 21                                                                                                                                                                  
   {"pinsr",     iSSE41, 0x9200, 0x52,   0x23,   0x5003, 0,      1  },    // 0F 3A 22                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 23                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 24                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 25                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 26                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 27                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 28                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 29                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 2A                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 2B                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 2C                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 2D                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 2E                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 2F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 30                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 31                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 32                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 33                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 34                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 35                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 36                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 37                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 38                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 39                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 3A                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 3B                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 3C                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 3D                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 3E                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 3F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"dpps",      iSSE41, 0x8200, 0x52,   0x6B,   0x526B, 0,      0  },    // 0F 3A 40                                                                                                                                                                  
   {"dppd",      iSSE41, 0x8200, 0x52,   0x6C,   0x526C, 0,      0  },    // 0F 3A 41                                                                                                                                                                  
   {"mpsadbw",   iSSE41, 0x8200, 0x52,   0x22,   0x5221, 0,      0  },    // 0F 3A 42                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 43                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 44                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 45                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 46                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 47                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 48                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 49                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 4A                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 4B                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 4C                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 4D                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 4E                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 4F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 50                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 51                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 52                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 53                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 54                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 55                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 56                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 57                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 58                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 59                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 5A                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 5B                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 5C                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 5D                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 5E                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 5F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pcmpestrm", iSSE42, 0x8200, 0x52,   0x21,   0x5228, 0,      0  },    // 0F 3A 60                                                                                                                                                                  
   {"pcmpestri", iSSE42, 0x8200, 0x52,   0x21,   0x5228, 0,      0  },    // 0F 3A 61                                                                                                                                                                  
   {"pcmpistrm", iSSE42, 0x8200, 0x52,   0x21,   0x5228, 0,      0  },    // 0F 3A 62                                                                                                                                                                  
   {"pcmpistri", iSSE42, 0x8200, 0x52,   0x21,   0x5228, 0,      0  },    // 0F 3A 63                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 64                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 65                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 66                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 67                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 68                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 69                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 6A                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 6B                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 6C                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 6D                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 6E                                                                                                                                                                  
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  },    // 0F 3A 6F                                                                                                                                                                  
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2052, 0,      0,      0,      0  }};   // 0F 3A 70                                                                                                                                                                  
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 3B                                                                                                                                                                                      
// Not used but reserved by Intel for future extensions                                                                                                                                                                                                
SOpcodeDef OpcodeMap0F3B[1] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           i86,    0,      0x2000, 0,      0,      0,      0  }};   // 0F 3B 00                                                                                                                                                                  
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Tertiary opcode map for AMD 3DNow instructions. First two bytes = 0F 0F                                                                                                                                                                             
// Indexed by immediate byte following operands                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F0F[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 00                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 01                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 02                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 03                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 04                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 05                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 06                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 07                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 08                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 09                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 0A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 0B                                                                                                                                                               
   {"PFI2FW",    iK3D,   0,      0x0052, 0x5B,   0x212,  0,      0  },    // 0F 0F op 0C                                                                                                                                                               
   {"PI2FD",     iK3D,   0,      0x0052, 0x5B,   0x213,  0,      0  },    // 0F 0F op 0D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 0E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 0F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 10                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 11                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 12                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 13                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 14                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 15                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 16                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 17                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 18                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 19                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 1A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 1B                                                                                                                                                               
   {"PF2IW",     0x1002, 0,      0x0052, 0x12,   0x25B,  0,      0  },    // 0F 0F op 1C                                                                                                                                                               
   {"PF2ID",     iK3D,   0,      0x0052, 0x13,   0x25B,  0,      0  },    // 0F 0F op 1D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 1E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 1F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 20                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 21                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 22                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 23                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 24                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 25                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 26                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 27                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 28                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 29                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 2A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 2B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 2C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 2D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 2E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 2F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 30                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 31                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 32                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 33                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 34                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 35                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 36                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 37                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 38                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 39                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 3A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 3B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 3C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 3D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 3E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 3F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 40                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 41                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 42                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 43                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 44                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 45                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 46                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 47                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 48                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 49                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 4A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 4B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 4C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 4D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 4E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 4F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 50                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 51                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 52                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 53                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 54                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 55                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 56                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 57                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 58                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 59                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 5A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 5B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 5C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 5D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 5E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 5F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 60                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 61                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 62                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 63                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 64                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 65                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 66                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 67                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 68                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 69                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 6A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 6B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 6C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 6D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 6E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 6F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 70                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 71                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 72                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 73                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 74                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 75                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 76                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 77                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 78                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 79                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 7A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 7B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 7C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 7D                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 7E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 7F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 80                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 81                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 82                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 83                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 84                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 85                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 86                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 87                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 88                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 89                                                                                                                                                               
   {"PFNACC",    iK3D2,  0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 8A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 8B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 8C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 8D                                                                                                                                                               
   {"PFPNACC",   iK3D2,  0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 8E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 8F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"PFCMPGE",   iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 90                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 91                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 92                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 93                                                                                                                                                               
   {"PFMIN",     iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 94                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 95                                                                                                                                                               
   {"PFRCP",     iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 96                                                                                                                                                               
   {"PFRSQRT",   iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 97                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 98                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 99                                                                                                                                                               
   {"PFSUB",     iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 9A                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 9B                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 9C                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 9D                                                                                                                                                               
   {"PFADD",     iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op 9E                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op 9F                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"PFCMPGT",   iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op A0                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op A1                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op A2                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op A3                                                                                                                                                               
   {"PFMAX",     iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op A4                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op A5                                                                                                                                                               
   {"PFRCPIT1",  iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op A6                                                                                                                                                               
   {"PFRSQIT1",  iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op A7                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op A8                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op A9                                                                                                                                                               
   {"PFSUBR",    iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op AA                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op AB                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op AC                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op AD                                                                                                                                                               
   {"PFACC",     iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op AE                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op AF                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"PFCMPEQ",   iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op B0                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op B1                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op B2                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op B3                                                                                                                                                               
   {"PFMUL",     iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op B4                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op B5                                                                                                                                                               
   {"PFRCPIT2",  iK3D,   0,      0x0052, 0x5B,   0x25B,  0,      0  },    // 0F 0F op B6                                                                                                                                                               
   {"PMULHRW",   iK3D,   0,      0x0052, 0x12,   0x212,  0,      0  },    // 0F 0F op B7                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op B8                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op B9                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op BA                                                                                                                                                               
   {"PSWAPD",    iK3D2,  0,      0x0052, 0x10,   0x210,  0,      0  },    // 0F 0F op BB                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op BC                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op BD                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  },    // 0F 0F op BE                                                                                                                                                               
   {"PAVGUSB",   iK3D,   0,      0x0052, 0x11,   0x211,  0,      0  },    // 0F 0F op BF                                                                                                                                                               
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iK3D,   0,      0x2052, 0x10,   0x210,  0,      0  }};   // 0F 0F op C0                                                                                                                                                               
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode D8                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapD8[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fadd",      i87,    0,      0x11,   0,      0x143,  0,      0  },    // fadd m32                                                                                                                                                                  
   {"fmul",      i87,    0,      0x11,   0,      0x143,  0,      0  },    // fmul m32                                                                                                                                                                  
   {"fcom",      i87,    0,      0x11,   0,      0x143,  0,      4  },    // fcom m32                                                                                                                                                                  
   {"fcomp",     i87,    0,      0x11,   0,      0x143,  0,      4  },    // fcomp m32                                                                                                                                                                 
   {"fsub",      i87,    0,      0x11,   0,      0x143,  0,      0  },    // fsub m32                                                                                                                                                                  
   {"fsubr",     i87,    0,      0x11,   0,      0x143,  0,      0  },    // fsubr m32                                                                                                                                                                 
   {"fdiv",      i87,    0,      0x11,   0,      0x143,  0,      0  },    // fdiv m32                                                                                                                                                                  
   {"fdivr",     i87,    0,      0x11,   0,      0x143,  0,      0  },    // fdivr m32                                                                                                                                                                 
   {"fadd",      i87,    0,      0x11,   0xaf,   0x040,  0,      0  },    // fadd st,st(i)                                                                                                                                                             
   {"fmul",      i87,    0,      0x11,   0xaf,   0x040,  0,      0  },    // fmul st,st(i)                                                                                                                                                             
   {"fcom",      i87,    0,      0x11,   0,      0x040,  0,      4  },    // fcom st,st(i)                                                                                                                                                             
   {"fcomp",     i87,    0,      0x11,   0,      0x040,  0,      4  },    // fcomp st,st(i)                                                                                                                                                            
   {"fsub",      i87,    0,      0x11,   0xaf,   0x040,  0,      0  },    // fsub st,st(i)                                                                                                                                                             
   {"fsubr",     i87,    0,      0x11,   0xaf,   0x040,  0,      0  },    // fsubr st,st(i)                                                                                                                                                            
   {"fdiv",      i87,    0,      0x11,   0xaf,   0x040,  0,      0  },    // fdiv st,st(i)                                                                                                                                                             
   {"fdivr",     i87,    0,      0x11,   0xaf,   0x040,  0,      0  }};   // fdivr st,st(i)                                                                                                                                                            
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode D9                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapD9[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fld",       i87,    0,      0x11,   0,      0x143,  0,      0  },    // fld m32                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x143,  0,      0  },    // illegal                                                                                                                                                                   
   {"fst",       i87,    0,      0x11,   0x143,  0,      0,      0  },    // fst m32                                                                                                                                                                   
   {"fstp",      i87,    0,      0x11,   0x143,  0,      0,      0  },    // fstp m32                                                                                                                                                                  
   {"fldenv",    i87,    0,      0x11,   0,      0x106,  0,      0  },    // fldenv m                                                                                                                                                                  
   {"fldcw",     i87,    0,      0x11,   0,      0x102,  0,      0  },    // fldcw m16                                                                                                                                                                 
   {"fnstenv",   i87,    0,      0x11,   0x106,  0,      0,      0  },    // fnstenv m                                                                                                                                                                 
   {"fnstcw",    i87,    0,      0x11,   0x102,  0,      0,      0  },    // fnstcw m16                                                                                                                                                                
   {"fld",       i87,    0,      0x11,   0,      0x040,  0,      0  },    // fld st(i)                                                                                                                                                                 
   {"fxch",      i87,    0,      0x11,   0,      0x040,  0,      0  },    // fxch st(i)                                                                                                                                                                
   {"fnop",      tD9_010,0,      0x10,   0,      0,      5,      0  },    // Link to tertiary map 0x10 fnop                                                                                                                                            
   {0,           0,      0,      0x4011, 0,      0x040,  0,      0  },    // Illegal                                                                                                                                                                   
   {0,           tD9_100,0,      0,      0,      0,      5,      0  },    // Link to tertiary map 0x11 fchs etc.                                                                                                                                       
   {0,           tD9_101,0,      0,      0,      0,      5,      0  },    // Link to tertiary map 0x12 fld1 etc.                                                                                                                                       
   {0,           tD9_110,0,      0,      0,      0,      5,      0  },    // Link to tertiary map 0x13 f2xm1 etc.                                                                                                                                      
   {0,           tD9_111,0,      0,      0,      0,      5,      0  }};   // Link to tertiary map 0x14 fprem etc.                                                                                                                                      
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode DA                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapDA[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fiadd",     i87,    0,      0x11,   0,      0x103,  0,      0  },    // fiadd m32                                                                                                                                                                 
   {"fimul",     i87,    0,      0x11,   0,      0x103,  0,      0  },    // fimul m32                                                                                                                                                                 
   {"ficom",     i87,    0,      0x11,   0,      0x103,  0,      4  },    // ficom m32                                                                                                                                                                 
   {"ficomp",    i87,    0,      0x11,   0,      0x103,  0,      4  },    // ficomp m32                                                                                                                                                                
   {"fisub",     i87,    0,      0x11,   0,      0x103,  0,      0  },    // fisub m32                                                                                                                                                                 
   {"fisubr",    i87,    0,      0x11,   0,      0x103,  0,      0  },    // fisubr m32                                                                                                                                                                
   {"fidiv",     i87,    0,      0x11,   0,      0x103,  0,      0  },    // fidiv m32                                                                                                                                                                 
   {"fidivr",    i87,    0,      0x11,   0,      0x103,  0,      0  },    // fidivr m32                                                                                                                                                                
   {"fcmovb",    iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovb st,st(i)  #as 100=>106                                                                                                                                             
   {"fcmove",    iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovb st,st(i)  #as 100=>106                                                                                                                                             
   {"fcmovbe",   iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovbe st,st(i) #as 100=>106                                                                                                                                             
   {"fcmovu",    iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovbe st,st(i) #as 100=>106                                                                                                                                             
   {0,           0,      0,      0x4011, 0,      0x040,  0,      0  },    // Illegal                                                                                                                                                                   
   {0,           tDA_101,0,      0,      0,      0,      5,      0  },    // Link to tertiary map 0x15 fucompp                                                                                                                                         
   {0,           0,      0,      0x4011, 0,      0x040,  0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x040,  0,      0  }};   // Illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode DB                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapDB[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fild",      i87,    0,      0x11,   0,      0x103,  0,      0  },    // fild m32                                                                                                                                                                  
   {"fisttp",    iFPUPNI,0,      0x11,   0,      0x103,  0,      0  },    // fisttp m32 #as 0x13=>0x113                                                                                                                                                
   {"fist",      i87,    0,      0x11,   0x103,  0,      0,      0  },    // fist m32                                                                                                                                                                  
   {"fistp",     i87,    0,      0x11,   0x103,  0,      0,      0  },    // fistp m32                                                                                                                                                                 
   {0,           0,      0,      0x4011, 0,      0x103,  0,      0  },    // illegal                                                                                                                                                                   
   {"fld",       i87,    0,      0x11,   0,      0x145,  0,      0  },    // fld m80                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x103,  0,      0  },    // illegal                                                                                                                                                                   
   {"fstp",      i87,    0,      0x11,   0x145,  0,      0,      0  },    // fst m80                                                                                                                                                                   
   {"fcmovnb",   iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovnb st,st(i) #as 0x100=>0x106                                                                                                                                         
   {"fcmovne",   iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovne st,st(i) #as 0x100=>0x106                                                                                                                                         
   {"fcmovnbe",  iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovnbe st,st(i)#as 0x100=>0x106                                                                                                                                         
   {"fcmovnu",   iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      0  },    // fcmovnu st,st(i) #as 0x100=>0x106                                                                                                                                         
   {0,           tDB_100,0,      0,      0,      0,      5,      0  },    // Link to tertiary map 0x16 fclex etc.                                                                                                                                      
   {"fucomi",    iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      4  },    // fucomi st,st(i) #as 0x101=>0x106                                                                                                                                          
   {"fcomi",     iFPUP6, 0,      0x11,   0xaf,   0x040,  0,      4  },    // fcomi st,st(i)  #as 0x100=>0x106                                                                                                                                          
   {0,           0,      0,      0x4011, 0,      0x040,  0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode DC                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapDC[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fadd",      i87,    0,      0x11,   0,      0x144,  0,      0  },    // fadd m64                                                                                                                                                                  
   {"fmul",      i87,    0,      0x11,   0,      0x144,  0,      0  },    // fmul m64                                                                                                                                                                  
   {"fcom",      i87,    0,      0x11,   0,      0x144,  0,      4  },    // fcom m64                                                                                                                                                                  
   {"fcomp",     i87,    0,      0x11,   0,      0x144,  0,      4  },    // fcomp m64                                                                                                                                                                 
   {"fsub",      i87,    0,      0x11,   0,      0x144,  0,      0  },    // fsub m64                                                                                                                                                                  
   {"fsubr",     i87,    0,      0x11,   0,      0x144,  0,      0  },    // fsubr m64                                                                                                                                                                 
   {"fdiv",      i87,    0,      0x11,   0,      0x144,  0,      0  },    // fdiv m64                                                                                                                                                                  
   {"fdivr",     i87,    0,      0x11,   0,      0x144,  0,      0  },    // fdivr m64                                                                                                                                                                 
   {"fadd",      i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fadd st(i),st                                                                                                                                                             
   {"fmul",      i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fmul st(i),st                                                                                                                                                             
   {0,           0,      0,      0x4011, 0x040,  0xaf,   0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0x040,  0xaf,   0,      0  },    // illegal                                                                                                                                                                   
   {"fsubr",     i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fsubr st(i),st                                                                                                                                                            
   {"fsub",      i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fsub st(i),st                                                                                                                                                             
   {"fdivr",     i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fdivr st(i),st                                                                                                                                                            
   {"fdiv",      i87,    0,      0x11,   0x040,  0xaf,   0,      0  }};   // fdiv st(i),st                                                                                                                                                             
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode DD                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapDD[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fld",       i87,    0,      0x11,   0,      0x144,  0,      0  },    // fld m64                                                                                                                                                                   
   {"fisttp",    iFPUPNI,0,      0x11,   0x104,  0,      0,      0  },    // fisttp m64 #as 0x13 => 0x113                                                                                                                                              
   {"fst",       i87,    0,      0x11,   0x144,  0,      0,      0  },    // fst m64                                                                                                                                                                   
   {"fstp",      i87,    0,      0x11,   0x144,  0,      0,      0  },    // fstp m64                                                                                                                                                                  
   {"frstor",    i87,    0,      0x11,   0x106,  0,      0,      0  },    // frstor 108 bytes                                                                                                                                                          
   {0,           0,      0,      0x4011, 0,      0x106,  0,      0  },    // illegal                                                                                                                                                                   
   {"fnsave",    i87,    0,      0x11,   0,      0x106,  0,      0  },    // fnsave 108 bytes                                                                                                                                                          
   {"fnstsw",    i87,    0,      0x11,   0x102,  0,      0,      0  },    // fstsw m16                                                                                                                                                                 
   {"ffree",     i87,    0,      0x11,   0x40,   0,      0,      0  },    // ffree st(i)                                                                                                                                                               
   {0,           0,      0,      0x4011, 0,      0x106,  0,      0  },    // illegal                                                                                                                                                                   
   {"fst",       i87,    0,      0x11,   0x40,   0,      0,      0  },    // fst st(i)                                                                                                                                                                 
   {"fstp",      i87,    0,      0x11,   0x40,   0,      0,      0  },    // fstp st(i)                                                                                                                                                                
   {"fucom",     i387,   0,      0x11,   0,      0x40,   0,      0  },    // fucom st(i)  #as 0x101 => 0x103                                                                                                                                           
   {"fucomp",    i387,   0,      0x11,   0,      0x40,   0,      0  },    // fucomp st(i) #as 0x101 => 0x103                                                                                                                                           
   {0,           0,      0,      0x4011, 0,      0x106,  0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x106,  0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode DE                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapDE[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fiadd",     i87,    0,      0x11,   0,      0x102,  0,      0  },    // fiadd m16                                                                                                                                                                 
   {"fimul",     i87,    0,      0x11,   0,      0x102,  0,      0  },    // fimul m16                                                                                                                                                                 
   {"ficom",     i87,    0,      0x11,   0,      0x102,  0,      4  },    // ficom m16                                                                                                                                                                 
   {"ficomp",    i87,    0,      0x11,   0,      0x102,  0,      4  },    // ficomp m16                                                                                                                                                                
   {"fisub",     i87,    0,      0x11,   0,      0x102,  0,      0  },    // fisub m16                                                                                                                                                                 
   {"fisubr",    i87,    0,      0x11,   0,      0x102,  0,      0  },    // fisubr m16                                                                                                                                                                
   {"fidiv",     i87,    0,      0x11,   0,      0x102,  0,      0  },    // fidiv m16                                                                                                                                                                 
   {"fidivr",    i87,    0,      0x11,   0,      0x102,  0,      0  },    // fidivr m16                                                                                                                                                                
   {"faddp",     i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // faddp st(i),st                                                                                                                                                            
   {"fmulp",     i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fmulp st(i),st                                                                                                                                                            
   {0,           0,      0,      0x4011, 0x040,  0xaf,   0,      0  },    // illegal                                                                                                                                                                   
   {0,           tDE_011,0,      0,      0,      0,      5,      0  },    // Link to tertiary map 0x17 fcompp                                                                                                                                          
   {"fsubrp",    i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fsubrp st(i),st (Yes, the order is illogical here)                                                                                                                        
   {"fsubp",     i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fsubp st(i),st                                                                                                                                                            
   {"fdivrp",    i87,    0,      0x11,   0x040,  0xaf,   0,      0  },    // fdivrp st(i),st                                                                                                                                                           
   {"fdivp",     i87,    0,      0x11,   0x040,  0xaf,   0,      0  }};   // fdivp st(i),st                                                                                                                                                            
                                                                                                                                                                                                                                                       
// Secondary opcode map for x87 f.p. instructions. Opcode DF                                                                                                                                                                                           
// Indexed by reg bits and mod == 3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMapDF[16] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fild",      i87,    0,      0x11,   0,      0x102,  0,      0  },    // fild m16                                                                                                                                                                  
   {"fisttp",    iFPUPNI,0,      0x11,   0,      0x102,  0,      0  },    // fisttp m16 #as 0x13 => 0x113                                                                                                                                              
   {"fist",      i87,    0,      0x11,   0x102,  0,      0,      0  },    // fist m16                                                                                                                                                                  
   {"fistp",     i87,    0,      0x11,   0x102,  0,      0,      0  },    // fistp m16                                                                                                                                                                 
   {"fbld",      i87,    0,      0x11,   0,      0x105,  0,      0  },    // fbld m80                                                                                                                                                                  
   {"fild",      i87,    0,      0x11,   0,      0x104,  0,      0  },    // fild m64                                                                                                                                                                  
   {"fbstp",     i87,    0,      0x11,   0x105,  0,      0,      0  },    // fbstp m80                                                                                                                                                                 
   {"fistp",     i87,    0,      0x11,   0x104,  0,      0,      0  },    // fistp m64                                                                                                                                                                 
   {0,           0,      0,      0x4011, 0,      0x40,   0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x40,   0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x40,   0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x40,   0,      0  },    // illegal                                                                                                                                                                   
   {0,           tDF_100,0,      0,      0,      0,      5,      0  },    // Link to tertiary map 0x18 fnstsw ax                                                                                                                                       
   {"fucomip",   i387,   0,      0x11,   0xAF,   0x40,   0,      4  },    // fucomp st,st(i) #as 0x101 => 0x103                                                                                                                                        
   {"fcomip",    i87,    0,      0x11,   0xAF,   0x40,   0,      4  },    // fcomp st,st(i)                                                                                                                                                            
   {0,           0,      0,      0x4011, 0,      0x40,   0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. D9 / reg = 010                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapD9_010[2] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fnop",      i87,    0,      0x10,   0,      0,      0,     0x40},    // fnop                                                                                                                                                                      
   {0,           0,      0,      0,      0,      0,      0,      0  }};   // the rest is illegal                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. D9 / reg = 100                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapD9_100[8] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fchs",      i87,    0,      0x10,   0,      0,      0,      0  },    // fchs                                                                                                                                                                      
   {"fabs",      i87,    0,      0x10,   0,      0,      0,      0  },    // fabs                                                                                                                                                                      
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"ftst",      i87,    0,      0x10,   0,      0,      0,      0  },    // ftst                                                                                                                                                                      
   {"fxam",      i87,    0,      0x10,   0,      0,      0,      0  },    // fxam                                                                                                                                                                      
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4010, 0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. D9 / reg = 101                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapD9_101[8] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fld1",      i87,    0,      0x10,   0,      0,      0,      0  },    // fld1                                                                                                                                                                      
   {"fldl2t",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fldl2e",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fldpi",     i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fldlg2",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fldln2",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fldz",      i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {0,           0,      0,      0x4010, 0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. D9 / reg = 110                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapD9_110[8] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"f2xm1",     i87,    0,      0x10,   0,      0,      0,      0  },    // f2xm1                                                                                                                                                                     
   {"fyl2x",     i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fptan",     i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fpatan",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fxtract",   i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fprem1",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fdecstp",   i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fincstp",   i87,    0,      0x10,   0,      0,      0,      0  }};   //                                                                                                                                                                           
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. D9 / reg = 111                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapD9_111[8] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fprem",     i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fyl2xp1",   i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fsqrt",     i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fsincos",   i387,   0,      0x10,   0,      0,      0,      0  },    // #as 0x101=>0x103                                                                                                                                                          
   {"frndint",   i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fscale",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fsin",      i387,   0,      0x10,   0,      0,      0,      0  },    // #as 0x101=>0x103                                                                                                                                                          
   {"fcos",      i387,   0,      0x10,   0,      0,      0,      0  }};   // #as 0x101=>0x103                                                                                                                                                          
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. DA / reg = 101                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapDA_101[3] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"fucompp",   iFPUP6, 0,      0x10,   0,      0,      0,      0  },    // #as 0x101=0x106                                                                                                                                                           
   {0,           0,      0,      0x4010, 0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. DB / reg = 100                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapDB_100[5] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"fnclex",    i87,    0,      0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"fninit",    i87,    0,      0x10,   0,      0,      0,      8  },    //                                                                                                                                                                           
   {0,           0,      0,      0x4010, 0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. DE / reg = 011                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapDE_011[3] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"fcompp",    i87,    0,      0x10,   0,      0,      0,      4  },    //                                                                                                                                                                           
   {0,           0,      0,      0x4010, 0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for f.p. DF / reg = 100                                                                                                                                                                                                         
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMapDF_100[2] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fnstsw",    i87,    0,      0x11,   0xa2,   0,      0,      0  },    //                                                                                                                                                                           
   {0,           0,      0,      0x4010, 0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for IRET. Opcode byte = 0xCF                                                                                                                                                                                                   
// Indexed by operand size                                                                                                                                                                                                                             
SOpcodeDef OpcodeMapCF[3] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"iret",      0,      0x0102, 2,      0,      0,      0,      0x10},    // CF                                                                                                                                                                       
   {"iretd",     0,      0x0102, 2,      0,      0,      0,      0x10},    // CF                                                                                                                                                                       
   {"iretq",     0,      0x1102, 2,      0,      0,      0,      0x10}};   // CF                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Secondary opcode map for immediate group 1. Opcode byte = 0x80                                                                                                                                                                                      
// Indexed by reg bits = 0 - 7                                                                                                                                                                                                                         
SOpcodeDef OpcodeMap80[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"add",       0,      0x10,   0x51,   0x201,   0x1000, 0,      0  },    // 80 /0                                                                                                                                                                    
   {"or",        0,      0x10,   0x51,   0x201,   0x5000, 0,      0  },    // 80 /1                                                                                                                                                                    
   {"adc",       0,      0x10,   0x51,   0x201,   0x1000, 0,      0  },    // 80 /2                                                                                                                                                                    
   {"sbb",       0,      0x10,   0x51,   0x201,   0x1000, 0,      0  },    // 80 /3                                                                                                                                                                    
   {"and",       0,      0x10,   0x51,   0x201,   0x5000, 0,      0  },    // 80 /4                                                                                                                                                                    
   {"sub",       0,      0x10,   0x51,   0x201,   0x1000, 0,      0  },    // 80 /5                                                                                                                                                                    
   {"xor",       0,      0x10,   0x51,   0x201,   0x5000, 0,      0  },    // 80 /6                                                                                                                                                                    
   {"cmp",       0,      0,      0x51,   0x201,   0x1000, 0,      4  }};   // 80 /7                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Secondary opcode map for immediate group 1. Opcode byte = 0x81                                                                                                                                                                                      
// Indexed by reg bits = 0 - 7                                                                                                                                                                                                                         
SOpcodeDef OpcodeMap81[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"add",       i86,    0x1110, 0x91,   0x209,   0x3000, 0,     0x80},    // 81 /0                                                                                                                                                                    
   {"or",        i86,    0x1110, 0x91,   0x209,   0x7000, 0,     0x80},    // 81 /1                                                                                                                                                                    
   {"adc",       i86,    0x1110, 0x91,   0x209,   0x3000, 0,     0x80},    // 81 /2                                                                                                                                                                    
   {"sbb",       i86,    0x1110, 0x91,   0x209,   0x3000, 0,     0x80},    // 81 /3                                                                                                                                                                    
   {"and",       i86,    0x1110, 0x91,   0x209,   0x7000, 0,     0x80},    // 81 /4                                                                                                                                                                    
   {"sub",       i86,    0x1110, 0x91,   0x209,   0x3000, 0,     0x80},    // 81 /5                                                                                                                                                                    
   {"xor",       i86,    0x1110, 0x91,   0x209,   0x7000, 0,     0x80},    // 81 /6                                                                                                                                                                    
   {"cmp",       i86,    0x1100, 0x91,   0x209,   0x3000, 0,     0x84}};   // 81 /7                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Secondary opcode map for immediate group 1. Opcode byte = 0x82.                                                                                                                                                                                     
// Undocumented opcode. Signed byte instructions do the same as unsigned byte instructions at 0x80                                                                                                                                                     
SOpcodeDef OpcodeMap82[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"add",       i86n64, 0x10,   0x4051, 0x201,   0x2000, 0,      0  },    // 82 /0                                                                                                                                                                    
   {"or",        i86n64, 0x10,   0x4051, 0x201,   0x6000, 0,      0  },    // 82 /1                                                                                                                                                                    
   {"adc",       i86n64, 0x10,   0x4051, 0x201,   0x2000, 0,      0  },    // 82 /2                                                                                                                                                                    
   {"sbb",       i86n64, 0x10,   0x4051, 0x201,   0x2000, 0,      0  },    // 82 /3                                                                                                                                                                    
   {"and",       i86n64, 0x10,   0x4051, 0x201,   0x6000, 0,      0  },    // 82 /4                                                                                                                                                                    
   {"sub",       i86n64, 0x10,   0x4051, 0x201,   0x2000, 0,      0  },    // 82 /5                                                                                                                                                                    
   {"xor",       i86n64, 0x10,   0x4051, 0x201,   0x6000, 0,      0  },    // 82 /6                                                                                                                                                                    
   {"cmp",       i86,    0,      0x4051, 0x201,   0x2000, 0,      4  }};   // 82 /7                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Secondary opcode map for immediate group 1. Opcode byte = 0x83                                                                                                                                                                                      
// Indexed by reg bits = 0 - 7                                                                                                                                                                                                                         
SOpcodeDef OpcodeMap83[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"add",       i86,    0x1110, 0x51,   0x209,   0x2000, 0,      0  },    // 83 /0                                                                                                                                                                    
   {"or",        i86,    0x1110, 0x51,   0x209,   0x7000, 0,      0  },    // 83 /1                                                                                                                                                                    
   {"adc",       i86,    0x1110, 0x51,   0x209,   0x2000, 0,      0  },    // 83 /2                                                                                                                                                                    
   {"sbb",       i86,    0x1110, 0x51,   0x209,   0x2000, 0,      0  },    // 83 /3                                                                                                                                                                    
   {"and",       i86,    0x1110, 0x51,   0x209,   0x7000, 0,      0  },    // 83 /4                                                                                                                                                                    
   {"sub",       i86,    0x1110, 0x51,   0x209,   0x2000, 0,      0  },    // 83 /5                                                                                                                                                                    
   {"xor",       i86,    0x1110, 0x51,   0x209,   0x7000, 0,      0  },    // 83 /6                                                                                                                                                                    
   {"cmp",       i86,    0x1100, 0x51,   0x209,   0x2000, 0,      4  }};   // 83 /7                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Secondary opcode map for shift group 2. Opcode byte = 0xC0                                                                                                                                                                                          
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapC0[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"rol",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  },    // C0 /0 rol byte ptr r/m,ib                                                                                                                                                
   {"ror",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  },    // C0 /1                                                                                                                                                                    
   {"rcl",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  },    // C0 /2                                                                                                                                                                    
   {"rcr",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  },    // C0 /3                                                                                                                                                                    
   {"shl",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  },    // C0 /4                                                                                                                                                                    
   {"shr",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  },    // C0 /5                                                                                                                                                                    
   {"sal",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  },    // C0 /6                                                                                                                                                                    
   {"sar",       i86,    0,      0x51,   0x201,   0x1000, 0,      0  }};   // C0 /7                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Secondary opcode map for shift group 2. Opcode byte = 0xC1                                                                                                                                                                                          
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapC1[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"rol",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  },    // C1 /0 rol word ptr r/m,ib                                                                                                                                                
   {"ror",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  },    // C1 /1                                                                                                                                                                    
   {"rcl",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  },    // C1 /2                                                                                                                                                                    
   {"rcr",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  },    // C1 /3                                                                                                                                                                    
   {"shl",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  },    // C1 /4                                                                                                                                                                    
   {"shr",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  },    // C1 /5                                                                                                                                                                    
   {"sal",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  },    // C1 /6                                                                                                                                                                    
   {"sar",       i86,    0x1100, 0x51,   0x209,   0x1000, 0,      0  }};   // C1 /7                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Secondary opcode map for shift group 2. Opcode byte = 0xD0                                                                                                                                                                                          
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapD0[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"rol",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  },    // C2 /0 rol byte ptr r/m,1                                                                                                                                                
   {"ror",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  },    // C2 /1                                                                                                                                                                   
   {"rcl",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  },    // C2 /2                                                                                                                                                                   
   {"rcr",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  },    // C2 /3                                                                                                                                                                   
   {"shl",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  },    // C2 /4                                                                                                                                                                   
   {"shr",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  },    // C2 /5                                                                                                                                                                   
   {"sal",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  },    // C2 /6                                                                                                                                                                   
   {"sar",       i86,    0,      0x11,   0x201,   0xb1,    0,      0  }};   // C2 /7                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for shift group 2. Opcode byte = 0xD1                                                                                                                                                                                          
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapD1[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"rol",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  },    // C3 /0 rol word ptr r/m,1                                                                                                                                                
   {"ror",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  },    // C3 /1                                                                                                                                                                   
   {"rcl",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  },    // C3 /2                                                                                                                                                                   
   {"rcr",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  },    // C3 /3                                                                                                                                                                   
   {"shl",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  },    // C3 /4                                                                                                                                                                   
   {"shr",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  },    // C3 /5                                                                                                                                                                   
   {"sal",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  },    // C3 /6                                                                                                                                                                   
   {"sar",       i86,    0x1100, 0x11,   0x209,   0xb1,    0,      0  }};   // C3 /7                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for shift group 2. Opcode byte = 0xD2                                                                                                                                                                                          
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapD2[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"rol",       i86,    0,      0x11,   0x201,   0x800,   0,      0  },    // C2 /0 rol byte ptr r/m,cl                                                                                                                                               
   {"ror",       i86,    0,      0x11,   0x201,   0x800,   0,      0  },    // C2 /1                                                                                                                                                                   
   {"rcl",       i86,    0,      0x11,   0x201,   0x800,   0,      0  },    // C2 /2                                                                                                                                                                   
   {"rcr",       i86,    0,      0x11,   0x201,   0x800,   0,      0  },    // C2 /3                                                                                                                                                                   
   {"shl",       i86,    0,      0x11,   0x201,   0x800,   0,      0  },    // C2 /4                                                                                                                                                                   
   {"shr",       i86,    0,      0x11,   0x201,   0x800,   0,      0  },    // C2 /5                                                                                                                                                                   
   {"sal",       i86,    0,      0x11,   0x201,   0x800,   0,      0  },    // C2 /6                                                                                                                                                                   
   {"sar",       i86,    0,      0x11,   0x201,   0x800,   0,      0  }};   // C2 /7                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for shift group 2. Opcode byte = 0xD3                                                                                                                                                                                          
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapD3[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"rol",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  },    // C3 /0 rol word ptr r/m,cl                                                                                                                                               
   {"ror",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  },    // C3 /1                                                                                                                                                                   
   {"rcl",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  },    // C3 /2                                                                                                                                                                   
   {"rcr",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  },    // C3 /3                                                                                                                                                                   
   {"shl",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  },    // C3 /4                                                                                                                                                                   
   {"shr",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  },    // C3 /5                                                                                                                                                                   
   {"sal",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  },    // C3 /6                                                                                                                                                                   
   {"sar",       i86,    0x1100, 0x11,   0x209,   0x800,   0,      0  }};   // C3 /7                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 3. Opcode byte = 0xF6                                                                                                                                                                                                
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapF6[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"test",      i86,    0,      0x51,   0x201,  0x5000, 0,      4  },    // test rm8,ib                                                                                                                                                               
   {"test",      i86,    0,      0x4051, 0x201,  0x5000, 0,      4  },    // test rm8,ib. undocumented                                                                                                                                                 
   {"not",       i86,    0,      0x11,   0x201,  0,      0,      0  },    // not rm8                                                                                                                                                                   
   {"neg",       i86,    0,      0x11,   0x201,  0,      0,      0  },    // neg rm8                                                                                                                                                                   
   {"mul",       i86,    0,      0x11,   0x201,  0,      0,      8  },    // mul rm8                                                                                                                                                                   
   {"imul",      i86,    0,      0x11,   0x201,  0,      0,      8  },    // imul rm8                                                                                                                                                                  
   {"div",       i86,    0,      0x11,   0x201,  0,      0,      8  },    // div rm8                                                                                                                                                                   
   {"idiv",      i86,    0,      0x11,   0x201,  0,      0,      8  }};   // idiv rm8                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 3. Opcode byte = 0xF7                                                                                                                                                                                                
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapF7[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"test",      i86,    0x1100, 0x91,   0x209,  0x7000, 0,      4  },    // test rm,i                                                                                                                                                                 
   {"test",      i86,    0x1100, 0x4091, 0x209,  0x7000, 0,      4  },    // test rm,i. undocumented                                                                                                                                                   
   {"not",       i86,    0x1100, 0x11,   0x209,  0,      0,      0  },    // not rm                                                                                                                                                                    
   {"neg",       i86,    0x1100, 0x11,   0x209,  0,      0,      0  },    // neg rm                                                                                                                                                                    
   {"mul",       i86,    0x1100, 0x11,   0x209,  0,      0,      8  },    // mul rm                                                                                                                                                                    
   {"imul",      i86,    0x1100, 0x11,   0x209,  0,      0,      8  },    // imul rm                                                                                                                                                                   
   {"div",       i86,    0x1100, 0x11,   0x209,  0,      0,      8  },    // div rm                                                                                                                                                                    
   {"idiv",      i86,    0x1100, 0x11,   0x209,  0,      0,      8  }};   // idiv rm                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 4. Opcode byte = 0xFE                                                                                                                                                                                                
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapFE[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"inc",       i86,    0x10,   0x11,   0x201,  0,      0,      0  },    // inc rm8                                                                                                                                                                   
   {"dec",       i86,    0x10,   0x11,   0x201,  0,      0,      0  },    // dec rm8                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0x201,  0,      0,      0  }};   // illegal opcode                                                                                                                                                            
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 5. Opcode byte = 0xFF                                                                                                                                                                                                
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMapFF[8] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"inc",       i86,    0x1110, 0x11,   0x209,  0,      0,     0x80},    // inc rm                                                                                                                                                                    
   {"dec",       i86,    0x1110, 0x11,   0x209,  0,      0,     0x80},    // dec rm                                                                                                                                                                    
   {"call",      i86,    0x2102, 0x11,   0x20C,  0,      0,      8  },    // call indirect rm                                                                                                                                                          
   {"call",      i86,    0x1102, 0x811,  0x10D,  0,      0,      8  },    // call indirect far                                                                                                                                                         
   {"jmp",       i86,    0x2100, 0x11,   0x20B,  0,      0,     0x14},    // jmp indirect rm                                                                                                                                                           
   {"jmp",       i86,    0x1100, 0x811,  0x10D,  0,      0,     0x10},    // jmp indirect far                                                                                                                                                          
   {"push",      i86,    0x2102, 0x11,   0x20A,  0,      0,      4  },    // push rm                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0x209,  0,      0,      0  }};   // illegal opcode                                                                                                                                                            
                                                                                                                                                                                                                                                       
// Secondary opcode map for immediate group 1A. Opcode byte = 0x8F                                                                                                                                                                                     
// Indexed by reg bits = 0 - 7. Values != 0 are discouraged                                                                                                                                                                                            
SOpcodeDef OpcodeMap8F[2] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pop",       i86,    0x2102, 0x11,   0x209,   0,      0,      0  },    // 8F                                                                                                                                                                       
   {"pop",       i86,    0x2102, 0x4011, 0x209,   0,      0,      0  }};   // 8F                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Tertiary opcode map for pinsrw. Opcode byte = 0F C4                                                                                                                                                                                                 
// Indexed by mod bits 0 register vs. memory operand                                                                                                                                                                                                   
SOpcodeDef OpcodeMap0FC4[2] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pinsrw",    iMMX2,  0x1200, 0x52,   0x32,   0x1102, 0,      0  },    // 0F C4 memory operand                                                                                                                                                      
   {"pinsrw",    iMMX2,  0x1200, 0x52,   0x32,   0x1009, 0,      0  }};   // 0F C4 register operand                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Tertiary opcode map for group 6. Opcode byte = 0F 00                                                                                                                                                                                                
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F00[8] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"sldt",      i286,     0x1100, 0x11,   0x202,  0,      0,      0  },    //                                                                                                                                                                           
   {"str",       i286p,  0x0100, 0x11,   0x202,  0,      0,      0  },    //                                                                                                                                                                           
   {"lldt",      i286p,  0x2000, 0x11,   0,      0x102,  0,      0  },    //                                                                                                                                                                           
   {"ltr",       i286p,  0,      0x11,   0,      0x202,  0,      0  },    //                                                                                                                                                                           
   {"verr",      i286p,  0,      0x11,   0,      0x202,  0,      0  },    //                                                                                                                                                                           
   {"verw",      i286p,  0,      0x11,   0,      0x202,  0,      0  },    //                                                                                                                                                                           
   {0,           0,      0,      0x4011, 0,      0x202,  0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0x202,  0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for group 7. Opcode byte = 0F 01                                                                                                                                                                                                
// Indexed by reg bits = 0 - 7 and mod = 11b.                                                                                                                                                                                                          
SOpcodeDef OpcodeMap0F01[16] = {                                                                                                                                                                                                                       
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"sgdt",      i286p,  0x1100, 0x11,   0x10D,  0,      0,      0  },    //                                                                                                                                                                           
   {"sidt",      i286p,  0x1100, 0x11,   0x10D,  0,      0,      0  },    //                                                                                                                                                                           
   {"lgdt",      i286p,  0x1100, 0x11,   0,      0x10D,  0,      0  },    //                                                                                                                                                                           
   {"lidt",      i286p,  0x1100, 0x11,   0,      0x10D,  0,      0  },    //                                                                                                                                                                           
   {"smsw",      i286,     0,      0x11,   0x202,  0,      0,      0  },    //                                                                                                                                                                           
   {0,           0,      0,      0x4011, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"lmsw",      i286p,  0,      0x11,   0,      0x202,  0,      0  },    //                                                                                                                                                                           
   {"invlpg",    i486,     0,      0x11,   0,      0x106,  0,      0  },    //                                                                                                                                                                           
   {0,           t0F01_0,0,      0x4011, 0,      0,      5,      0  },    // link to quarternary map, vmcall etc.                                                                                                                                      
   {0,           t0F01_1,0,      0x4011, 0,      0,      5,      0  },    // link to quarternary map, monitor, mwait                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {0,           0,      0,      0x4011, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"smsw",      i286,     0x1100, 0x11,   0x209,  0,      0,      0  },    //                                                                                                                                                                           
   {0,           0,      0,      0x4011, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"lmsw",      i286p,  0,      0x11,   0,      0x202,  0,      0  },    //                                                                                                                                                                           
   {"swapgs",    i86p,   0,      0x10,   0,      0,      0,      0  }};   // instruction set unknown                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 8. Opcode byte = 0F BA: bt                                                                                                                                                                                           
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0FBA[8] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x51,   0x209,  0,      0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0,      0x51,   0x209,  0,      0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0,      0x51,   0x209,  0,      0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0,      0x51,   0x209,  0,      0,      0  },    // Illegal                                                                                                                                                                   
   {"bt",        i386,   0x1100, 0x51,   0x209,  0x1000, 0,      0  },    //                                                                                                                                                                           
   {"bts",       i386,   0x1100, 0x51,   0x209,  0x1000, 0,      0  },    //                                                                                                                                                                           
   {"btr",       i386,   0x1100, 0x51,   0x209,  0x1000, 0,      0  },    //                                                                                                                                                                           
   {"btc",       i386,   0x1100, 0x51,   0x209,  0x1000, 0,      0  }};   //                                                                                                                                                                           
                                                                                                                                                                                                                                                       
// Secondary opcode map for addsub. Opcode byte = 0F D0                                                                                                                                                                                                
// Indexed by prefix = none, 66, F2, F3                                                                                                                                                                                                                
SOpcodeDef OpcodeMap0FD0[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"addsub",    iSSE3,  0,      0x4012, 0x6F,   0x26F,  0,      0  },    // 0F D0. undefined                                                                                                                                                          
   {"addsubpd",  iSSE3,  0x200,  0x12,   0x6C,   0x26C,  0,      0  },    // 66 0F D0. addsubpd                                                                                                                                                        
   {"addsubps",  iSSE3,  0x800,  0x12,   0x6B,   0x26B,  0,      0  },    // F2 0F D0. addsubps                                                                                                                                                        
   {"addsub",    iSSE3,  0x400,  0x4012, 0x6F,   0x26F,  0,      0  }};   // F3 0F D0. undefined                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 10. Opcode byte = 0F B9                                                                                                                                                                                              
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0FB9[1] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"ud1",       0,      0,      0x4012, 9,      0x206,  0,      0  }};   // Invalid opcode, possibly used for emulation                                                                                                                               
                                                                                                                                                                                                                                                       
// Secondary opcode map for mov group 11. Opcode byte = 0xC6                                                                                                                                                                                           
// Indexed by reg bits = 0 - 7. Values != 0 are discouraged                                                                                                                                                                                            
SOpcodeDef OpcodeMapC6[2] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"mov",       0,      5,      0x51,   0x201,   0x1000, 0,      0  },    // C6 mov m,ib                                                                                                                                                              
   {"mov",       0,      5,      0x4051, 0x201,   0x1000, 0,      0  }};   // C6                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Secondary opcode map for mov group 11. Opcode byte = 0xC7                                                                                                                                                                                           
// Indexed by reg bits = 0 - 7. Values != 0 are discouraged                                                                                                                                                                                            
SOpcodeDef OpcodeMapC7[2] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"mov",       0,      0x1105, 0x91,   0x209,   0x3000, 0,     0  },    // C7 mov m,iw                                                                                                                                                               
   {"mov",       0,      5,      0x4091, 0x209,   0x3000, 0,     0  }};   // C7                                                                                                                                                                        
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 12. Opcode byte = 0F 71                                                                                                                                                                                              
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F71[8] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {0,           iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"psrlw",     iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  },                                                                                                                                                                                 
   {0,           iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"psraw",     iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  },                                                                                                                                                                                 
   {0,           iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"psllw",     iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  },                                                                                                                                                                                 
   {0,           iMMX,   0x200,  0x51,   0x32,   0x1000, 0,      0  }};    // Illegal                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 13. Opcode byte = 0F 72                                                                                                                                                                                              
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F72[8] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"psrld",     iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },                                                                                                                                                                                 
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"psrad",     iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },                                                                                                                                                                                 
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"pslld",     iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },                                                                                                                                                                                 
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  }};    // Illegal                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 14. Opcode byte = 0F 73                                                                                                                                                                                              
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F73[8] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"psrlq",     iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },                                                                                                                                                                                 
   {"psrldq",    iSSE2,  0x8200, 0x51,   0x24,   0x1000, 0,      0  },     // Not valid without 66 prefix                                                                                                                                              
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {0,           iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },     // Illegal                                                                                                                                                                  
   {"psllq",     iSSE2,  0x200,  0x51,   0x33,   0x1000, 0,      0  },                                                                                                                                                                                 
   {"pslldq",    iSSE2,  0x8200, 0x51,   0x24,   0x1000, 0,      0  }};    // Not valid without 66 prefix                                                                                                                                              
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 15. Opcode byte = 0F AE                                                                                                                                                                                              
// Indexed by reg bits = 0 - 7 and mod = 3                                                                                                                                                                                                             
SOpcodeDef OpcodeMap0FAE[16] = {                                                                                                                                                                                                                       
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fxsave",    iSSE,   0,      0x11,   0x106,  0,      0,      0  },     // 0                                                                                                                                                                        
   {"fxrstor",   iSSE,   0,      0x11,   0,      0x106,  0,      8  },     // 1                                                                                                                                                                        
   {"ldmxcsr",   iSSE,   0,      0x11,   0,      0x103,  0,      0  },     // 2                                                                                                                                                                        
   {"stmxcsr",   iSSE,   0,      0x11,   0x103,  0,      0,      0  },     // 3                                                                                                                                                                        
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {"clflush",   iSSE2,  0,      0x11,   0x106,  0,      0,      0  },     // 7                                                                                                                                                                        
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {0,           0,      0,      0x10,   0,      0,      0,      0  },     // Illegal                                                                                                                                                                  
   {"lfence",    iMemSSE2,0,     0x10,   0,      0,      0,      0  },     // 1-5                                                                                                                                                                      
   {"mfence",    iMemSSE2,0,     0x10,   0,      0,      0,      0  },     // 1-6                                                                                                                                                                      
   {"sfence",    iMemSSE2,0,     0x10,   0,      0,      0,      0  }};    // 1-7                                                                                                                                                                      
                                                                                                                                                                                                                                                       
// Secondary opcode map for group 16. Opcode byte = 0F 18                                                                                                                                                                                              
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0F18[5] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"prefetchnta",iMemSSE,0,      0x11,   0,      0x106,  0,      0  },    // 0F 18 /0                                                                                                                                                                  
   {"prefetcht0", iMemSSE,0,      0x11,   0,      0x106,  0,      0  },    // 0F 18 /1                                                                                                                                                                  
   {"prefetcht1", iMemSSE,0,      0x11,   0,      0x106,  0,      0  },    // 0F 18 /2                                                                                                                                                                  
   {"prefetcht2", iMemSSE,0,      0x11,   0,      0x106,  0,      0  },    // 0F 18 /3                                                                                                                                                                  
   {"prefetch",   iMemSSE,0,      0x4011, 0,      0x106,  0,      0  }};   // 0F 18 /4+ illegal                                                                                                                                                         
                                                                                                                                                                                                                                                       
// Quarternary opcode map for group 7. 0F 01 reg = 0                                                                                                                                                                                                   
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMap0F01_0[6] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x4010, 0,      0,      0,      0  },    // illegal                                                                                                                                                                   
   {"vmcall",    iVMi,    0,     0x10,   0,      0,      0,      8  },    // Intel processor only?                                                                                                                                                     
   {"vmlaunch",  iVMi,    0,     0x10,   0,      0,      0,      8  },    // Intel processor only?                                                                                                                                                     
   {"vmresume",  iVMi,    0,     0x10,   0,      0,      0,      0  },    // Intel processor only?                                                                                                                                                     
   {"vmxoff",    iVMi,    0,     0x10,   0,      0,      0,      0  },    // Intel processor only?                                                                                                                                                     
   {0,           0,      0,      0x4010, 0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Quarternary opcode map for group 7. 0F 01 reg = 1                                                                                                                                                                                                   
// Indexed by rm bits of mod/reg/rm byte                                                                                                                                                                                                               
SOpcodeDef OpcodeMap0F01_1[5] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"monitor",   iMemSSE3, 4,    0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {"mwait",     iMemSSE3, 0,    0x10,   0,      0,      0,      0  },    //                                                                                                                                                                           
   {0,           0,        0,    0x10,   0,      0,      0,      0  }};   // illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for floating point CMP instructions. First two bytes = 0F C2                                                                                                                                                                    
// Indexed by immediate byte following operands = 0 - 7                                                                                                                                                                                                
SOpcodeDef OpcodeMap0FC2[9] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cmpeq",     iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 00: cmpeqps/pd                                                                                                                                                   
   {"cmplt",     iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 01:                                                                                                                                                              
   {"cmple",     iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 02:                                                                                                                                                              
   {"cmpunord",  iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 03:                                                                                                                                                              
   {"cmpneq",    iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 04:                                                                                                                                                              
   {"cmpnlt",    iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 05:                                                                                                                                                              
   {"cmpnle",    iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 06:                                                                                                                                                              
   {"cmpord",    iSSE2,  0xE00,  0x52,   0x6F,   0x26F,  0,      1  },    // 0F C2 op 07:                                                                                                                                                              
   {"cmp",       iSSE2,  0xE00,  0x4052, 0x6F,   0x126F, 0,      1  }};   // 0F C2 op > 7: cmpps/pd, imm                                                                                                                                               
                                                                                                                                                                                                                                                       
// Secondary opcode map for cbw/cwde/cdqe. Opcode byte = 0x98                                                                                                                                                                                          
// Indexed by operand size = 16, 32, 64                                                                                                                                                                                                                
SOpcodeDef OpcodeMap98[3] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cbw",       i86,    0x100,  1,      0,      0,      0,      8  },    // 98                                                                                                                                                                        
   {"cwde",      i86,    0x100,  1,      0,      0,      0,      8  },    // 98                                                                                                                                                                        
   {"cdqe",      i64Bit, 0x1000, 1,      0,      0,      0,      8  }};   // 98                                                                                                                                                                        
                                                                                                                                                                                                                                                       
// Secondary opcode map for cwd/cdq/cqo. Opcode byte = 0x99                                                                                                                                                                                            
// Indexed by operand size = 16, 32, 64                                                                                                                                                                                                                
SOpcodeDef OpcodeMap99[3] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cwd",       i86,    0x100,  1,      0,      0,      0,      8  },    // 99                                                                                                                                                                        
   {"cdq",       i86,    0x100,  1,      0,      0,      0,      8  },    // 99                                                                                                                                                                        
   {"cqo",       i64Bit, 0x1000, 1,      0,      0,      0,      8  }};   // 99                                                                                                                                                                        
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Secondary opcode map for arpl/movsxd. Opcode byte = 0x63                                                                                                                                                                                            
// Indexed by mode = 16, 32, 64                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap63[3] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"arpl",      i286n64, 0,     0x13,   0x202,  2,       0,      0  },    // 63                                                                                                                                                                       
   {"arpl",      i286n64, 0,     0x13,   0x202,  2,       0,      0  },    // 63                                                                                                                                                                       
   {"movsxd",    i64Bit, 0x1000, 0x12,   9,      0x203,   0,      0  }};   // 63                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Secondary opcode map for nop/pause. Opcode byte = 0x90                                                                                                                                                                                              
// Indexed by prefix = none, 66, F2, F3                                                                                                                                                                                                                
SOpcodeDef OpcodeMap90[4] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"nop",       i86,    0,      2,      0,      0,      0,     0x40},    // 90                                                                                                                                                                        
   {"nop",       i86,    0x200,  2,      0,      0,      0,     0x40},    // 66 90                                                                                                                                                                     
   {"nop",       i86,    0x800,  2,      0,      0,      0,     0x40},    // F2 90                                                                                                                                                                     
   {"pause",     i86,    0x400,  2,      0,      0,      0,      0  }};   // F3 90. (No instset indicated because backwards compatible)                                                                                                                
                                                                                                                                                                                                                                                       
// Secondary opcode map for jcxz. Opcode byte = 0xE3                                                                                                                                                                                                   
// Indexed by address size                                                                                                                                                                                                                             
SOpcodeDef OpcodeMapE3[4] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"jcxz",      i86,    0x81,   0x42,   0x81,   0,      0,      0  },    // E3                                                                                                                                                                        
   {"jecxz",     i86,    0x81,   0x42,   0x81,   0,      0,      0  },                                                                                                                                                                                 
   {"jrcxz",     i64Bit, 0x81,   0x42,   0x81,   0,      0,      0  }};                                                                                                                                                                                
                                                                                                                                                                                                                                                       
// Secondary opcode map for pushf/d/q. Opcode byte = 0x9C                                                                                                                                                                                              
// Indexed by operand size                                                                                                                                                                                                                             
SOpcodeDef OpcodeMap9C[3] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pushf",     i86,    0x0102, 2,      0,      0,      0,      0  },    // 9C pushf                                                                                                                                                                  
   {"pushf",     i86,    0x2102, 2,      0,      0,      0,      1  },    // 9C pushf/d/q                                                                                                                                                              
   {"pushf",     i86,    0x2102, 2,      0,      0,      0,      1  }};   // 9C pushf/d/q                                                                                                                                                              
                                                                                                                                                                                                                                                       
// Secondary opcode map for poof/d/q. Opcode byte = 0x9D                                                                                                                                                                                               
// Indexed by operand size                                                                                                                                                                                                                             
SOpcodeDef OpcodeMap9D[3] = {                                                                                                                                                                                                                          
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"popf",      i86,    0x0102, 2,      0,      0,      0,      0  },    // 9D popf                                                                                                                                                                   
   {"popf",      i86,    0x2102, 2,      0,      0,      0,      1  },    // 9D popf/d/q                                                                                                                                                               
   {"popf",      i86,    0x2102, 2,      0,      0,      0,      1  }};   // 9D popf/d/q                                                                                                                                                               
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movups etc. Opcode byte = 0F 10                                                                                                                                                                                             
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F10[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movups",    iSSE,   0,      0x12,   0x6B,   0x228,  0,      0  },    // 0F 10                                                                                                                                                                     
   {"movupd",    iSSE2,  0x200,  0x12,   0x6C,   0x228,  0,      0  },    // 66 0F 10                                                                                                                                                                  
   {"movsd",     iSSE2,  0x800,  0x12,   0x4C,   0x24C,  0,      0  },    // F2 0F 10                                                                                                                                                                  
   {"movss",     iSSE2,  0x400,  0x12,   0x4B,   0x24B,  0,      0  }};   // F3 0F 10                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movups etc. Opcode byte = 0F 11                                                                                                                                                                                             
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F11[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movups",    iSSE,   0,      0x13,   0x228,  0x6B,   0,      0  },    // 0F 11                                                                                                                                                                     
   {"movupd",    iSSE2,  0x200,  0x13,   0x228,  0x6C,   0,      0  },    // 66 0F 11                                                                                                                                                                  
   {"movsd",     iSSE2,  0x800,  0x13,   0x24C,  0x4C,   0,      0  },    // F2 0F 11                                                                                                                                                                  
   {"movss",     iSSE2,  0x400,  0x13,   0x24B,  0x4B,   0,      0  }};   // F3 0F 11                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movlps etc. Opcode byte = 0F 12                                                                                                                                                                                             
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F12[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0F12n, 0,      0,      0,      0,      3,      0  },    // Link to quarternary map                                                                                                                                                   
   {"movlpd",    iSSE2,  0x200,  0x12,   0x26C,  0x110,  0,      0  },    // 66 0F 12                                                                                                                                                                  
   {"movddup",   iSSE3,  0x800,  0x12,   0x6C,   0x24C,  0,      0  },    // F2 0F 12                                                                                                                                                                  
   {"movsldup",  iSSE3,  0x400,  0x12,   0x26B,  0x4B,   0,      0  }};   // F3 0F 12                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Quarternary opcode map for movlps and movhlps. Opcode byte = 0F 12 (none)                                                                                                                                                                           
// Indexed by mod bits                                                                                                                                                                                                                                 
SOpcodeDef OpcodeMap0F12n[2] = {                                                                                                                                                                                                                       
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movlps",    iSSE,   0,      0x12,   0x6B,   0x110,  0,      0  },    // 0F 12 (mem)                                                                                                                                                               
   {"movhlps",   iSSE,   0,      0x12,   0x6B,   0x6B,   0,      0  }};   // 0F 12 (reg)                                                                                                                                                               
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movlps etc. Opcode byte = 0F 16#as                                                                                                                                                                                          
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F16[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0F16n, 0,      0,      0,      0,      3,      0  },    // Link to quarternary map                                                                                                                                                   
   {"movhpd",    iSSE2,  0x200,  0x12,   0x6C,   0x14C,  0,      0  },    // 66 0F 16                                                                                                                                                                  
   {0,           iSSE3,  0x800,  0x4012, 0x6C,   0x24C,  0,      0  },    // F2 0F 16                                                                                                                                                                  
   {"movshdup",  iSSE3,  0x400,  0x12,   0x6B,   0x26B,  0,      0  }};   // F3 0F 16                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Quarternary opcode map for movhps and movlhps. Opcode byte = 0F 16 (none)                                                                                                                                                                           
// Indexed by mod bits                                                                                                                                                                                                                                 
SOpcodeDef OpcodeMap0F16n[2] = {                                                                                                                                                                                                                       
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movhps",    iSSE,   0,      0x12,   0x6B,   0x110,  0,      0  },    // 0F 12 (mem)                                                                                                                                                               
   {"movlhps",   iSSE,   0,      0x12,   0x6B,   0x6B,   0,      0  }};   // 0F 12 (reg)                                                                                                                                                               
                                                                                                                                                                                                                                                       
// Tertiary opcode map for cvtpi2ps etc. Opcode byte = 0F 2A                                                                                                                                                                                           
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F2A[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cvtpi2ps",  iSSE,   0,      0x12,   0x6B,   0x213,   0,     0  },    // 0F 2A                                                                                                                                                                     
   {"cvtpi2pd",  iSSE2,  0x200,  0x12,   0x6C,   0x213,   0,     0  },    // 66 0F 2A                                                                                                                                                                  
   {"cvtsi2sd",  iSSE2,  0x1800, 0x12,   0x4C,   0x209,   0,     0  },    // F2 0F 2A                                                                                                                                                                  
   {"cvtsi2ss",  iSSE2,  0x1400, 0x12,   0x4B,   0x209,   0,     0  }};   // F3 0F 2A                                                                                                                                                                  
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Tertiary opcode map for cvttps2pi etc. Opcode byte = 0F 2C                                                                                                                                                                                          
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F2C[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cvttps2pi", iSSE,   0,      0x12,   0x13,   0x26B,  0,      0  },    // 0F 2C                                                                                                                                                                     
   {"cvttpd2pi", iSSE2,  0x200,  0x12,   0x13,   0x26C,  0,      0  },    // 66 0F 2C                                                                                                                                                                  
   {"cvttsd2si", iSSE2,  0x1800, 0x12,   0x09,   0x24C,  0,      0  },    // F2 0F 2C                                                                                                                                                                  
   {"cvttss2si", iSSE2,  0x1400, 0x12,   0x09,   0x24B,  0,      0  }};   // F3 0F 2C                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for cvtps2pi etc. Opcode byte = 0F 2D                                                                                                                                                                                           
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F2D[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cvtps2pi",  iSSE,   0,      0x12,   0x13,   0x26B,  0,      0  },    // 0F 2D                                                                                                                                                                     
   {"cvtpd2pi",  iSSE2,  0x200,  0x12,   0x13,   0x26C,  0,      0  },    // 66 0F 2D                                                                                                                                                                  
   {"cvtsd2si",  iSSE2,  0x1800, 0x12,   0x09,   0x24C,  0,      0  },    // F2 0F 2D                                                                                                                                                                  
   {"cvtss2si",  iSSE2,  0x1400, 0x12,   0x09,   0x24B,  0,      0  }};   // F3 0F 2D                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for cvtps2pd etc. Opcode byte = 0F 5A                                                                                                                                                                                           
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F5A[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cvtps2pd",  iSSE2,  0,      0x12,   0x6C,   0x26B,  0,      0  },    // 0F 5A                                                                                                                                                                     
   {"cvtpd2ps",  iSSE2,  0x200,  0x12,   0x6B,   0x26C,  0,      0  },    // 66 0F 5A                                                                                                                                                                  
   {"cvtsd2ss",  iSSE2,  0x800,  0x12,   0x4B,   0x24C,  0,      0  },    // F2 0F 5A                                                                                                                                                                  
   {"cvtss2sd",  iSSE2,  0x400,  0x12,   0x4C,   0x24B,  0,      0  }};   // F3 0F 5A                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for cvtdq2ps etc. Opcode byte = 0F 5B                                                                                                                                                                                           
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F5B[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cvtdq2ps",  iSSE2,  0,      0x12,   0x6B,   0x223,  0,      0  },    // 0F 5B #as comment fix                                                                                                                                                     
   {"cvtps2dq",  iSSE2,  0x200,  0x12,   0x23,   0x26B,  0,      0  },    // 66 0F 5B                                                                                                                                                                  
   {0,           iSSE2,  0x800,  0x4012, 0x20,   0x220,  0,      0  },    // F2 0F 5B. Illegal                                                                                                                                                         
   {"cvttps2dq", iSSE2,  0x400,  0x12,   0x23,   0x26B,  0,      0  }};   // F3 0F 5B                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for ucomiss/sd etc. Opcode byte = 0F 2E                                                                                                                                                                                         
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F2E[3] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"ucomiss",   iSSE,   0x200,  0x12,   0x6B,   0x24B,  0,      4  },    // 0F 2E. ucomiss                                                                                                                                                            
   {"ucomisd",   iSSE,   0x200,  0x12,   0x6C,   0x24C,  0,      4  },    // 66 0F 2E. ucomisd                                                                                                                                                         
   {0,           0,      0,      0x12,   0x6F,   0x26F,  0,      0  }};   // Illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for comiss/sd etc. Opcode byte = 0F 2F                                                                                                                                                                                          
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F2F[3] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"comiss",    iSSE,   0x200,  0x12,   0x6B,   0x24B,  0,      4  },    // 0F 2F. comiss                                                                                                                                                             
   {"comisd",    iSSE,   0x200,  0x12,   0x6C,   0x24C,  0,      4  },    // 66 0F 2F. comisd                                                                                                                                                          
   {0,           0,      0,      0x12,   0x6F,   0x26F,  0,      0  }};   // Illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movq/movdqa/movdqu. Opcode byte = 0F 6F                                                                                                                                                                                     
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F6F[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movq",      iMMX,   0,      0x12,   0x10,   0x210,  0,      0  },    // 0F 6F                                                                                                                                                                     
   {"movdqa",    iSSE2,  0x100,  0x12,   0x20,   0x220,  0,      0  },    // 66 0F 6F                                                                                                                                                                  
   {0,           iMMX,   0x800,  0x4012, 0x10,   0x210,  0,      0  },    // F2 0F 6F. Illegal                                                                                                                                                         
   {"movdqu",    iSSE2,  0x400,  0x12,   0x20,   0x228,  0,      0  }};   // F3 0F 6F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movq/movdqa/movdqu. Opcode byte = 0F 7F                                                                                                                                                                                     
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F7F[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movq",      iMMX,   0,      0x13,   0x210,  0x10,   0,      0  },    // 0F 7F #as comment fix                                                                                                                                                     
   {"movdqa",    iSSE2,  0x100,  0x13,   0x220,  0x20,   0,      0  },    // 66 0F 7F #as comment fix                                                                                                                                                  
   {0,           iMMX,   0x800,  0x4013, 0x210,  0x10,   0,      0  },    // F2 0F 7F. Illegal #as comment fix                                                                                                                                         
   {"movdqu",    iSSE2,  0x400,  0x13,   0x228,  0x20,   0,      0  }};   // F3 0F 7F #as comment fix                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for pshufw etc. Opcode byte = 0F 70                                                                                                                                                                                             
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F70[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pshufw",    iMMX2,  0,      0x52,   0x12,   0x1212, 0,      0  },    // 0F 70                                                                                                                                                                     
   {"pshufd",    iSSE2,  0x100,  0x52,   0x23,   0x1223, 0,      0  },    // 66 0F 70                                                                                                                                                                  
   {"pshuflw",   iSSE2,  0x800,  0x52,   0x22,   0x1222, 0,      0  },    // F2 0F 70                                                                                                                                                                  
   {"pshufhw",   iSSE2,  0x400,  0x52,   0x22,   0x1222, 0,      0  }};   // F3 0F 70                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for group 9. Opcode byte = 0F C7                                                                                                                                                                                                
// Indexed by reg bits = 0 - 7.                                                                                                                                                                                                                        
SOpcodeDef OpcodeMap0FC7[8] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 0. Illegal                                                                                                                                                                
   {0,           t0FC7_1,0x1010, 0,      0,      0,      8,      0  },    // 1. Link to quarternary map: cmpxchg8b                                                                                                                                     
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {0,           t0FC7_6,0x600,  0,      0,      0,      9,      0  },    // 6. Link to quarternary map: vmptrld                                                                                                                                       
   {"vmptrst",   iVMi,    0,      0x11,   0x110,  0,      0,      0  }};   // 7                                                                                                                                                                         
                                                                                                                                                                                                                                                       
// Quarternary opcode map for cmpxchg8b. Opcode byte = 0F C7 /1                                                                                                                                                                                        
// Indexed by operand size: 16, 32, 64                                                                                                                                                                                                                 
SOpcodeDef OpcodeMap0FC7_1[3] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"cmpxchg8b", iP5,    0x1010, 0x11,   0x110,  0,      0,      0  },    //                                                                                                                                                                           
   {"cmpxchg8b", iP5,    0x1010, 0x11,   0x110,  0,      0,      0  },    //                                                                                                                                                                           
   {"cmpxchg16b",iP5,    0x1010, 0x11,   0x120,  0,      0,      0  }};                                                                                                                                                                                
                                                                                                                                                                                                                                                       
// Quarternary opcode map for cmpxchg8b. Opcode byte = 0F C7 /6                                                                                                                                                                                        
// Indexed by prefix: none/66/F2/F3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMap0FC7_6[4] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"vmptrld",   iVMi,    0,      0x11,   0x110,  0,      0,      0  },    //                                                                                                                                                                           
   {"vmclear",   iVMi,    0x200,  0x11,   0x110,  0,      0,      0  },    //                                                                                                                                                                           
   {0,           iVMi,    0x800,  0x11,   0x110,  0,      0,      0  },    // Illegal                                                                                                                                                                   
   {"vmxon",     iVMi,    0x400,  0x11,   0x110,  0,      0,      0  }};                                                                                                                                                                                
                                                                                                                                                                                                                                                       
// Quarternary opcode map for movdq2q etc. Opcode byte = 0F D6                                                                                                                                                                                         
// Indexed by prefix: none/66/F2/F3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMap0FD6[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {"movq",      iSSE2,  0x200,  0x13,   0x220,  0x20,   0,      0  },    // 66: movq xmm,xmm                                                                                                                                                          
   {"movdq2q",   iSSE2,  0x800,  0x12,   0x10,   0x20,   0,      0  },    // F2                                                                                                                                                                        
   {"movq2dq",   iSSE2,  0x400,  0x12,   0x20,   0x10,   0,      0  }};   // F3                                                                                                                                                                        
                                                                                                                                                                                                                                                       
// Quarternary opcode map for cvtpd2dq etc. Opcode byte = 0F E6                                                                                                                                                                                        
// Indexed by prefix: none/66/F2/F3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMap0FE6[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0,      0,      0,      0,      0  },    // Illegal                                                                                                                                                                   
   {"cvttpd2dq", iSSE2,  0x200,  0x12,   0x23,   0x26C,  0,      0  },    // 66: movq xmm,xmm                                                                                                                                                          
   {"cvtpd2dq",  iSSE2,  0x800,  0x12,   0x23,   0x26C,  0,      0  },    // F2                                                                                                                                                                        
   {"cvtdq2pd",  iSSE2,  0x400,  0x12,   0x6C,   0x223,  0,      0  }};   // F3                                                                                                                                                                        
                                                                                                                                                                                                                                                       
// Quarternary opcode map for movntq etc. Opcode byte = 0F E7                                                                                                                                                                                          
// Indexed by prefix: none/66/F2/F3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMap0FE7[3] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movntq",    iMMX2,  0,      0x13,   0x110,  0x10,   0,      0  },    //   #as changed iSSE=> iMMX2                                                                                                                                                                        
   {"movntdq",   iSSE2,  0x200,  0x13,   0x120,  0x20,   0,      0  },    //                                                                                                                                                                           
   {0,           0,      0,      0,      0,      0,      0,      0  }};   // Illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Quarternary opcode map for lddqu. Opcode byte = 0F F0                                                                                                                                                                                               
// Indexed by prefix: none/66/F2/F3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMap0FF0[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x12,   0x20,   0x020,  0,      0  },    // Illegal                                                                                                                                                                   
   {0,           0,      0x200,  0x12,   0x20,   0x020,  0,      0  },    //                                                                                                                                                                           
   {"lddqu",     iSSE3,  0x800,  0x12,   0x20,   0x128,  0,      0  },    //                                                                                                                                                                           
   {0,           0,      0x400,  0x12,   0x20,   0x020,  0,      0  }};   // Illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Quarternary opcode map for maskmovq. Opcode byte = 0F F7                                                                                                                                                                                            
// Indexed by prefix: none/66/F2/F3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMap0FF7[3] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"maskmovq",  iMMX,   5,      0x12,   0x10,   0x10,   0,      0  },    //                                                                                                                                                                           
   {"maskmovdqu",iSSE2,  0x205,  0x12,   0x20,   0x20,   0,      0  },    //                                                                                                                                                                           
   {0,           0,      0,      0x12,   0x20,   0x120,  0,      0  }};   // Illegal                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movd/movq. Opcode byte = 0F 6E                                                                                                                                                                                              
// Indexed by operand size 16/32/64                                                                                                                                                                                                                    
// First two lines are identical because operand size is determined only by REX.W prefix,                                                                                                                                                              
// while 66 prefix determines mmx or xmm register                                                                                                                                                                                                      
SOpcodeDef OpcodeMap0F6E[3] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movd",      iMMX,   0x1200, 0x12,   0x33,   0x203,  0,      0  },    // 0F 6E                                                                                                                                                                     
   {"movd",      iMMX,   0x1200, 0x12,   0x33,   0x203,  0,      0  },    // 0F 6E                                                                                                                                                                     
   {"movd;Name varies: movq",0x4000,0x1200,0x12,0x33,0x204,0,    0  }};   // 0F 6E. Name varies: movd or movq, though the operand is 64 bits                                                                                                           
                                                                                                                                                                                                                                                       
// Tertiary opcode map for movd/movq. Opcode byte = 0F 7E                                                                                                                                                                                              
// Indexed by prefix: none/66/F2/F3                                                                                                                                                                                                                    
SOpcodeDef OpcodeMap0F7E[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           t0F7En,  0,      0,      0,      0,      8,      0  },    // 0F 7E. Link to map 5A. Name depends on REX.W prefix                                                                                                                      
   {0,           t0F7En,  0,      0,      0,      0,      8,      0  },    // 66 0F 7E. Link to map 5A. Name depends on REX.W prefix                                                                                                                   
   {0,           iMMX,    0,      0x4013, 0x203,  0x33,   0,      0  },    // F2 0F 7E. Doesn't exist                                                                                                                                                  
   {0,           t0F7E_F3,0,      0,      0,      0,      3,      0  }};   // F3 0F 7E. Link to map 5B. movq xmm,xmm/m64                                                                                                                               
                                                                                                                                                                                                                                                       
// Quarternary opcode map for movd/movq. Opcode byte = 66 0F 7E                                                                                                                                                                                        
// Indexed by operand size 16/32/64                                                                                                                                                                                                                    
// First two lines are identical because operand size is determined only by REX.W prefix,                                                                                                                                                              
// while 66 prefix determines mmx or xmm register                                                                                                                                                                                                      
SOpcodeDef OpcodeMap0F7En[3] = {                                                                                                                                                                                                                       
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movd",      iMMX,   0x1200, 0x13,   0x203,  0x33,   0,      0  },    // 0F 7E                                                                                                                                                                     
   {"movd",      iMMX,   0x1200, 0x13,   0x203,  0x33,   0,      0  },    // 0F 7E                                                                                                                                                                     
   {"movd;Name varies: movq",0x4000,0x1200,0x13,0x204,0x34,0,    0  }};   // 0F 7E. Name varies: movd or movq, though the operand is 64 bits                                                                                                           
                                                                                                                                                                                                                                                       
// Quarternary opcode map for movq xmm,xmm/m64. Opcode byte = F3 0F 7E                                                                                                                                                                                 
// Indexed by memory vs. register operand                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F7E_F3[2] = {                                                                                                                                                                                                                     
   {"movq",      iSSE2,  0x400,  0x12,   0x24,   0x210,  0,      0  },    // F3 0F 7E. movq xmm,m                                                                                                                                                      
   {"movq",      iSSE2,  0x400,  0x12,   0x24,   0x224,  0,      0  }};   // F3 0F 7E. movq xmm,xmm                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Tertiary opcode map for haddps/pd etc. Opcode byte = 0F 7C                                                                                                                                                                                          
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F7C[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x4012, 0x6F,   0x26F,  0,      0  },    // 0F 7C                                                                                                                                                                     
   {"haddpd",    iSSE3,  0xA00,  0x12,   0x6C,   0x26C,  0,      0  },    // 66 0F 7C                                                                                                                                                                  
   {"haddps",    iSSE3,  0xA00,  0x12,   0x6B,   0x26B,  0,      0  },    // F2 0F 7C                                                                                                                                                                  
   {0,           0,      0,      0x4012, 0x6F,   0x26F,  0,      0  }};   // F3 0F 7C                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for hsubps/pd etc. Opcode byte = 0F 7D                                                                                                                                                                                          
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F7D[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x4012, 0x6F,   0x26F,  0,      0  },    // 0F 7D                                                                                                                                                                     
   {"hsubpd",    iSSE3,  0xA00,  0x12,   0x6C,   0x26C,  0,      0  },    // 66 0F 7D                                                                                                                                                                  
   {"hsubps",    iSSE3,  0xA00,  0x12,   0x6B,   0x26B,  0,      0  },    // F2 0F 7D                                                                                                                                                                  
   {0,           0,      0,      0x4012, 0x6F,   0x26F,  0,      0  }};   // F3 0F 7D                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for lar. Opcode byte = 0F 02                                                                                                                                                                                                    
// Indexed by memory vs. register operand                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F02[2] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"lar",       i286p,  0x1100, 0x12,   9,      0x102,  0,      0  },    // 0F 02 memory                                                                                                                                                              
   {"lar",       i286p,  0x1100, 0x12,   9,      0x009,  0,      0  }};   // 0F 02 register                                                                                                                                                            
                                                                                                                                                                                                                                                       
// Tertiary opcode map for lsl. Opcode byte = 0F 03                                                                                                                                                                                                    
// Indexed by memory vs. register operand                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F03[2] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"lsl",       i286p,  0x1100, 0x12,   9,      0x102,  0,      0  },    // 0F 03 memory                                                                                                                                                              
   {"lsl",       i286p,  0x1100, 0x12,   9,      0x009,  0,      0  }};   // 0F 03 register                                                                                                                                                            
                                                                                                                                                                                                                                                       
// Tertiary opcode map for popcnt. Opcode byte = 0F B8                                                                                                                                                                                                 
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0FB8[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"jmpe;Itanium only", 0,0,    0x11,   0,      0,      0,      8  },    // 0F B8                                                                                                                                                                     
   {0,           0,      0,      0,      0,      0,      0,      0  },    // 66 0F B8                                                                                                                                                                  
   {0,           0,      0,      0,      0,      0,      0,      0  },    // F2 0F B8                                                                                                                                                                  
   {"popcnt",    iSSE42, 0x1500, 0x12,   9,      0x209,  0,      0  }};   // F3 0F B8 #as and AMD SSE4                                                                                                                                                 
                                                                                                                                                                                                                                                       
// Quarternary opcode map for pextrb. Opcode byte = 0F 3A 14                                                                                                                                                                                           
// Indexed by memory vs. register operand                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F3A14[2] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pextrb",    iSSE41, 0x8200, 0x53,   0x101,  0x5021, 0,      0  },    // 0F 3A 14 memory                                                                                                                                                           
   {"pextrb",    iSSE41, 0x9200, 0x53,   0x009,  0x5021, 0,      0  }};   // 0F 3A 14 register                                                                                                                                                         
                                                                                                                                                                                                                                                       
// Quarternary opcode map for pextrw. Opcode byte = 0F 3A 15                                                                                                                                                                                           
// Indexed by memory vs. register operand                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F3A15[2] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pextrw",    iSSE41, 0x9200, 0x53,   0x101,  0x5022, 0,      0  },    // 0F 3A 15 memory                                                                                                                                                           
   {"pextrw",    iSSE41, 0x9200, 0x53,   0x009,  0x5022, 0,      0  }};   // 0F 3A 15 register                                                                                                                                                         
                                                                                                                                                                                                                                                       
// Quarternary opcode map for pextrd/q. Opcode byte = 0F 3A 16                                                                                                                                                                                         
// Indexed by operand size (16, 32, 64)                                                                                                                                                                                                                
SOpcodeDef OpcodeMap0F3A16[3] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pextrd",    iSSE41, 0x8200, 0x53,   0x203,  0x5023, 0,      1  },    // 0F 3A 16 pextrd                                                                                                                                                           
   {"pextrd",    iSSE41, 0x8200, 0x53,   0x203,  0x5023, 0,      1  },    // 0F 3A 16 pextrd                                                                                                                                                           
   {"pextrq",    iSSE41, 0x9200, 0x53,   0x204,  0x5024, 0,      1  }};   // 0F 3A 16 pextrq                                                                                                                                                           
                                                                                                                                                                                                                                                       
// Quarternary opcode map for pinsrb. Opcode byte = 0F 3A 20                                                                                                                                                                                           
// Indexed by memory vs. register operand                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F3A20[2] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"pinsrb",    iSSE41, 0x8200, 0x52,   0x21,   0x5001, 0,      0  },    // 0F 3A 20 memory                                                                                                                                                           
   {"pinsrb",    iSSE41, 0x8200, 0x52,   0x21,   0x500, 0,       0  }};   // 0F 3A 20 register                                                                                                                                                         
                                                                                                                                                                                                                                                       
// Quarternary opcode map for crc32. Opcode byte = 0F 38 F1                                                                                                                                                                                            
// Indexed by operand size (16, 32, 64)                                                                                                                                                                                                                
SOpcodeDef OpcodeMap0F38F1[3] = {                                                                                                                                                                                                                      
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"crc32",     iSSE42, 0x9900, 0x12,   0x3,    0x202,  0,      0  },    // 0F 38 F1                                                                                                                                                                  
   {"crc32",     iSSE42, 0x9900, 0x12,   0x3,    0x203,  0,      0  },    // 0F 38 F1                                                                                                                                                                  
   {"crc32",     iSSE42, 0x9900, 0x12,   0x4,    0x204,  0,      0  }};   // 0F 38 F1                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 24                                                                                                                                                                                      
// Indexed by third opcode byte                                                                                                                                                                                                                        
// AMD SSE5 instructions with four operands                                                                                                                                                                                                            
SOpcodeDef OpcodeMap0F24[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"fmaddps",   iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 00                                                                                                                                                                  
   {"fmaddpd",   iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 01                                                                                                                                                                  
   {"fmaddss",   iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 02                                                                                                                                                                  
   {"fmaddsd",   iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 03                                                                                                                                                                  
   {"fmaddps",   iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 04                                                                                                                                                                  
   {"fmaddpd",   iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 05                                                                                                                                                                  
   {"fmaddss",   iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 06                                                                                                                                                                  
   {"fmaddsd",   iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 07                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"fmsubps",   iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 08                                                                                                                                                                  
   {"fmsubpd",   iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 09                                                                                                                                                                  
   {"fmsubss",   iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 0A                                                                                                                                                                  
   {"fmsubsd",   iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 0B                                                                                                                                                                  
   {"fmsubps",   iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 0C                                                                                                                                                                  
   {"fmsubpd",   iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 0D                                                                                                                                                                  
   {"fmsubss",   iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 0E                                                                                                                                                                  
   {"fmsubsd",   iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 0F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"fnmaddps",  iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 10                                                                                                                                                                  
   {"fnmaddpd",  iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 11                                                                                                                                                                  
   {"fnmaddss",  iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 12                                                                                                                                                                  
   {"fnmaddsd",  iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 13                                                                                                                                                                  
   {"fnmaddps",  iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 14                                                                                                                                                                  
   {"fnmaddpd",  iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 15                                                                                                                                                                  
   {"fnmaddss",  iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 16                                                                                                                                                                  
   {"fnmaddsd",  iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 17                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"fnmsubps",  iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 18                                                                                                                                                                  
   {"fnmsubpd",  iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 19                                                                                                                                                                  
   {"fnmsubss",  iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 1A                                                                                                                                                                  
   {"fnmsubsd",  iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 1B                                                                                                                                                                  
   {"fnmsubps",  iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 1C                                                                                                                                                                  
   {"fnmsubpd",  iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 1D                                                                                                                                                                  
   {"fnmsubss",  iSSE5,  0,      0x15,   0x4B,   0x24B,  0,      0  },    // 0F 24 1E                                                                                                                                                                  
   {"fnmsubsd",  iSSE5,  0,      0x15,   0x4C,   0x24C,  0,      0  },    // 0F 24 1F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"permps",    iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 20                                                                                                                                                                  
   {"permpd",    iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 21                                                                                                                                                                  
   {"pcmov",     iSSE5,  0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 22                                                                                                                                                                  
   {"pperm",     iSSE5,  0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 23                                                                                                                                                                  
   {"permps",    iSSE5,  0,      0x15,   0x6B,   0x26B,  0,      0  },    // 0F 24 24                                                                                                                                                                  
   {"permpd",    iSSE5,  0,      0x15,   0x6C,   0x26C,  0,      0  },    // 0F 24 25                                                                                                                                                                  
   {"pcmov",     iSSE5,  0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 26                                                                                                                                                                  
   {"pperm",     iSSE5,  0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 27                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 28                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 29                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 2A                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 2B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 2C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 2D                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 2E                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 2F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 30                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 31                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 32                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 33                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 34                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 35                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 36                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 37                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 38                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 39                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 3A                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 3B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 3C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 3D                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 3E                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 3F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"protb",     iSSE5,  0,      0x14,   0x21,   0x221,  0,      0  },    // 0F 24 40                                                                                                                                                                  
   {"protw",     iSSE5,  0,      0x14,   0x22,   0x222,  0,      0  },    // 0F 24 41                                                                                                                                                                  
   {"protd",     iSSE5,  0,      0x14,   0x23,   0x223,  0,      0  },    // 0F 24 42                                                                                                                                                                  
   {"protq",     iSSE5,  0,      0x14,   0x24,   0x224,  0,      0  },    // 0F 24 43                                                                                                                                                                  
   {"pshlb",     iSSE5,  0,      0x14,   0x21,   0x221,  0,      0  },    // 0F 24 44                                                                                                                                                                  
   {"pshlw",     iSSE5,  0,      0x14,   0x22,   0x222,  0,      0  },    // 0F 24 45                                                                                                                                                                  
   {"pshld",     iSSE5,  0,      0x14,   0x23,   0x223,  0,      0  },    // 0F 24 46                                                                                                                                                                  
   {"pshlq",     iSSE5,  0,      0x14,   0x24,   0x224,  0,      0  },    // 0F 24 47                                                                                                                                                                  
   {"pshab",     iSSE5,  0,      0x14,   0x21,   0x221,  0,      0  },    // 0F 24 48                                                                                                                                                                  
   {"pshaw",     iSSE5,  0,      0x14,   0x22,   0x222,  0,      0  },    // 0F 24 49                                                                                                                                                                  
   {"pshad",     iSSE5,  0,      0x14,   0x23,   0x223,  0,      0  },    // 0F 24 4A                                                                                                                                                                  
   {"pshaq",     iSSE5,  0,      0x14,   0x24,   0x224,  0,      0  },    // 0F 24 4B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 4C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 4D                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 4E                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 4F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 50                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 51                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 52                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 53                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 54                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 55                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 56                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 57                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 58                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 59                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 5A                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 5B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 5C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 5D                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 5E                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 5F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 60                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 61                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 62                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 63                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 64                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 65                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 66                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 67                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 68                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 69                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 6A                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 6B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 6C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 6D                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 6E                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 6F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 70                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 71                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 72                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 73                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 74                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 75                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 76                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 77                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 78                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 79                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 7A                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 7B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 7C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 7D                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 7E                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 7F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 80                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 81                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 82                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 83                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 84                                                                                                                                                                  
   {"pmacssww",  iSSE5,  0,      0x15,   0x22,   0x222,  0,      0  },    // 0F 24 85                                                                                                                                                                  
   {"pmacsswd",  iSSE5,  0,      0x15,   0x23,   0x222,  0,      0  },    // 0F 24 86                                                                                                                                                                  
   {"pmacssdql", iSSE5,  0,      0x15,   0x24,   0x223,  0,      0  },    // 0F 24 87                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 88                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 89                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 8A                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 8B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 8C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 8D                                                                                                                                                                  
   {"pmacssdd",  iSSE5,  0,      0x15,   0x23,   0x223,  0,      0  },    // 0F 24 8E                                                                                                                                                                  
   {"pmacssdqh", iSSE5,  0,      0x15,   0x24,   0x223,  0,      0  },    // 0F 24 8F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 90                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 91                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 92                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 93                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 94                                                                                                                                                                  
   {"pmacsww",   iSSE5,  0,      0x15,   0x22,   0x222,  0,      0  },    // 0F 24 95                                                                                                                                                                  
   {"pmacswd",   iSSE5,  0,      0x15,   0x23,   0x222,  0,      0  },    // 0F 24 96                                                                                                                                                                  
   {"pmacsdql",  iSSE5,  0,      0x15,   0x24,   0x223,  0,      0  },    // 0F 24 97                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 98                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 99                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 9A                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 9B                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 9C                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 9D                                                                                                                                                                  
   {"pmacsdd",   iSSE5,  0,      0x15,   0x23,   0x223,  0,      0  },    // 0F 24 9E                                                                                                                                                                  
   {"pmacsdqh",  iSSE5,  0,      0x15,   0x24,   0x223,  0,      0  },    // 0F 24 9F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A0                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A1                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A2                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A3                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A4                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A5                                                                                                                                                                  
   {"pmadcsswd", iSSE5,  0,      0x15,   0x23,   0x222,  0,      0  },    // 0F 24 A6                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A7                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A8                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 A9                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 AA                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 AB                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 AC                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 AD                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 AE                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 AF                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B0                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B1                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B2                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B3                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B4                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B5                                                                                                                                                                  
   {"pmadcswd",  iSSE5,  0,      0x15,   0x23,   0x222,  0,      0  },    // 0F 24 B6                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B7                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B8                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 B9                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 BA                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 BB                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 BC                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 BD                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 BE                                                                                                                                                                  
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  },    // 0F 24 BF                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x15,   0x20,   0x220,  0,      0  }};   // 0F 24 C0+. Reserved for future opcodes                                                                                                                                    
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 25                                                                                                                                                                                      
// Indexed by third opcode byte                                                                                                                                                                                                                        
// AMD SSE5 instructions with three operands + immediate byte                                                                                                                                                                                          
SOpcodeDef OpcodeMap0F25[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 00                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 01                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 02                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 03                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 04                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 05                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 06                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 07                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 08                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 09                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 0A                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 0B                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 0C                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 0D                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 0E                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 0F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 10                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 11                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 12                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 13                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 14                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 15                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 16                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 17                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 18                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 19                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 1A                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 1B                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 1C                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 1D                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 1E                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 1F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 20                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 21                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 22                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 23                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 24                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 25                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 26                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 27                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 28                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 29                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 2A                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 2B                                                                                                                                                                  
   {"comps",     0,      0,      0x54,   0x6B,   0x526B, 0,      0  },    // 0F 25 2C                                                                                                                                                                  
   {"compd",     0,      0,      0x54,   0x6C,   0x526C, 0,      0  },    // 0F 25 2D                                                                                                                                                                  
   {"comss",     0,      0,      0x54,   0x4B,   0x524B, 0,      0  },    // 0F 25 2E                                                                                                                                                                  
   {"comsd",     0,      0,      0x54,   0x4C,   0x524C, 0,      0  },    // 0F 25 2F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 30                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 31                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 32                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 33                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 34                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 35                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 36                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 37                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 38                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 39                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 3A                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 3B                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 3C                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 3D                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 3E                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 3F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 40                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 41                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 42                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 43                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 44                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 45                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 46                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 47                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 48                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 49                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 4A                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 4B                                                                                                                                                                  
   {"pcomb",     iSSE5,  0,      0x54,   0x21,   0x5221, 0,      0  },    // 0F 25 4C                                                                                                                                                                  
   {"pcomw",     iSSE5,  0,      0x54,   0x22,   0x5222, 0,      0  },    // 0F 25 4D                                                                                                                                                                  
   {"pcomd",     iSSE5,  0,      0x54,   0x23,   0x5223, 0,      0  },    // 0F 25 4E                                                                                                                                                                  
   {"pcomq",     iSSE5,  0,      0x54,   0x24,   0x5224, 0,      0  },    // 0F 25 4F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 50                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 51                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 52                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 53                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 54                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 55                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 56                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 57                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 58                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 59                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 5A                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 5B                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 5C                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 5D                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 5E                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 5F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 60                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 61                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 62                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 63                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 64                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 65                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 66                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 67                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 68                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 69                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 6A                                                                                                                                                                  
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  },    // 0F 25 6B                                                                                                                                                                  
   {"pcomub",    iSSE5,  0,      0x54,   0x21,   0x5221, 0,      0  },    // 0F 25 6C                                                                                                                                                                  
   {"pcomuw",    iSSE5,  0,      0x54,   0x22,   0x5222, 0,      0  },    // 0F 25 6D                                                                                                                                                                  
   {"pcomud",    iSSE5,  0,      0x54,   0x23,   0x5223, 0,      0  },    // 0F 25 6E                                                                                                                                                                  
   {"pcomuq",    iSSE5,  0,      0x54,   0x24,   0x5224, 0,      0  },    // 0F 25 6F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x54,   0x20,   0x220,  0,      0  }};   // 0F 25 70+. Reserved for future opcodes                                                                                                                                    
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 7A                                                                                                                                                                                      
// Indexed by third opcode byte                                                                                                                                                                                                                        
// AMD SSE5 instructions with two operands                                                                                                                                                                                                             
SOpcodeDef OpcodeMap0F7A[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 00                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 01                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 02                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 03                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 04                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 05                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 06                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 07                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 08                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 09                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 0A                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 0B                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 0C                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 0D                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 0E                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 0F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"frczps",    iSSE5,  0,      0x12,   0x6B,   0x26B,  0,      0  },    // 0F 7A 10                                                                                                                                                                  
   {"frczpd",    iSSE5,  0,      0x12,   0x6C,   0x26C,  0,      0  },    // 0F 7A 11                                                                                                                                                                  
   {"frczss",    iSSE5,  0,      0x12,   0x4B,   0x24B,  0,      0  },    // 0F 7A 12                                                                                                                                                                  
   {"frczsd",    iSSE5,  0,      0x12,   0x4C,   0x24C,  0,      0  },    // 0F 7A 13                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 14                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 15                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 16                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 17                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 18                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 19                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 1A                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 1B                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 1C                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 1D                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 1E                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 1F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 20                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 21                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 22                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 23                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 24                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 25                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 26                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 27                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 28                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 29                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 2A                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 2B                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 2C                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 2D                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 2E                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 2F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"cvtph2ps",  iSSE5,  0,      0x12,   0x6B,   0x222,  0,      0  },    // 0F 7A 30                                                                                                                                                                  
   {"cvtps2ph",  iSSE5,  0,      0x12,   0x22,   0x26B,  0,      0  },    // 0F 7A 31                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 32                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 33                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 34                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 35                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 36                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 37                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 38                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 39                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 3A                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 3B                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 3C                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 3D                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 3E                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 3F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 40                                                                                                                                                                  
   {"phaddbw",   iSSE5,  0,      0x12,   0x22,   0x221,  0,      0  },    // 0F 7A 41                                                                                                                                                                  
   {"phaddbd",   iSSE5,  0,      0x12,   0x23,   0x221,  0,      0  },    // 0F 7A 42                                                                                                                                                                  
   {"phaddbq",   iSSE5,  0,      0x12,   0x24,   0x221,  0,      0  },    // 0F 7A 43                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 44                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 45                                                                                                                                                                  
   {"phaddwd",   iSSE5,  0,      0x12,   0x23,   0x222,  0,      0  },    // 0F 7A 46                                                                                                                                                                  
   {"phaddwq",   iSSE5,  0,      0x12,   0x24,   0x222,  0,      0  },    // 0F 7A 47                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 48                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 49                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 4A                                                                                                                                                                  
   {"phadddq",   iSSE5,  0,      0x12,   0x24,   0x223,  0,      0  },    // 0F 7A 4B                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 4C                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 4D                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 4E                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 4F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 50                                                                                                                                                                  
   {"phaddubw",  iSSE5,  0,      0x12,   0x22,   0x221,  0,      0  },    // 0F 7A 51                                                                                                                                                                  
   {"phaddubd",  iSSE5,  0,      0x12,   0x23,   0x221,  0,      0  },    // 0F 7A 52                                                                                                                                                                  
   {"phaddubq",  iSSE5,  0,      0x12,   0x24,   0x221,  0,      0  },    // 0F 7A 53                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 54                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 55                                                                                                                                                                  
   {"phadduwd",  iSSE5,  0,      0x12,   0x23,   0x222,  0,      0  },    // 0F 7A 56                                                                                                                                                                  
   {"phadduwq",  iSSE5,  0,      0x12,   0x24,   0x222,  0,      0  },    // 0F 7A 57                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 58                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 59                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 5A                                                                                                                                                                  
   {"phaddudq",  iSSE5,  0,      0x12,   0x24,   0x223,  0,      0  },    // 0F 7A 5B                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 5C                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 5D                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 5E                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 5F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 60                                                                                                                                                                  
   {"phsubbw",   iSSE5,  0,      0x12,   0x22,   0x221,  0,      0  },    // 0F 7A 61                                                                                                                                                                  
   {"phsubbd",   iSSE5,  0,      0x12,   0x23,   0x221,  0,      0  },    // 0F 7A 62                                                                                                                                                                  
   {"phsubbq",   iSSE5,  0,      0x12,   0x24,   0x221,  0,      0  },    // 0F 7A 63                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 64                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 65                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 66                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 67                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 68                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 69                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 6A                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 6B                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 6C                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 6D                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 6E                                                                                                                                                                  
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  },    // 0F 7A 6F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x12,   0x20,   0x220,  0,      0  }};   // 0F 7A ??                                                                                                                                                                  
                                                                                                                                                                                                                                                       
// Tertiary opcode map for 3-byte opcode. First two bytes = 0F 7B                                                                                                                                                                                      
// Indexed by third opcode byte                                                                                                                                                                                                                        
// AMD SSE5 instructions with two operands and an immediate byte operand                                                                                                                                                                               
SOpcodeDef OpcodeMap0F7B[] = {                                                                                                                                                                                                                         
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 00                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 01                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 02                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 03                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 04                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 05                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 06                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 07                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 08                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 09                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 0A                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 0B                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 0C                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 0D                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 0E                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 0F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 10                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 11                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 12                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 13                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 14                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 15                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 16                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 17                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 18                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 19                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 1A                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 1B                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 1C                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 1D                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 1E                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 1F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 20                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 21                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 22                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 23                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 24                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 25                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 26                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 27                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 28                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 29                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 2A                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 2B                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 2C                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 2D                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 2E                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 2F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 30                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 31                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 32                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 33                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 34                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 35                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 36                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 37                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 38                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 39                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 3A                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 3B                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 3C                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 3D                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 3E                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 3F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {"protb"  ,   iSSE5,  0,      0x52,   0x21,  0x2221,  0,      0  },    // 0F 7A 40                                                                                                                                                                  
   {"protw"  ,   iSSE5,  0,      0x52,   0x22,  0x2222,  0,      0  },    // 0F 7A 41                                                                                                                                                                  
   {"protd"  ,   iSSE5,  0,      0x52,   0x23,  0x2223,  0,      0  },    // 0F 7A 42                                                                                                                                                                  
   {"protq"  ,   iSSE5,  0,      0x52,   0x24,  0x2224,  0,      0  },    // 0F 7A 43                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 44                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 45                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 46                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 47                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 48                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 49                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 4A                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 4B                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 4C                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 4D                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 4E                                                                                                                                                                  
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  },    // 0F 7B 4F                                                                                                                                                                  
                                                                                                                                                                                                                                                       
   {0,           0,      0,      0x52,   0x20,   0x220,  0,      0  }};   // 0F 7B 50+                                                                                                                                                                 
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// #as                                                                                                                                                                                                                                                 
// Tertiary opcode map for movntps etc. Opcode byte = 0F 2B                                                                                                                                                                                            
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0F2B[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"movntps",   iSSE,    0,      0x13,   0x16B,   0x6B,   0,     0  },    // 0F 2B                                                                                                                                                                      
   {"movntpd",   iSSE,    0x200,  0x13,   0x16C,   0x6C,   0,     0  },    // 66 0F 2B                                                                                                                                                                   
   {"movntsd",   iSSE4a,  0x1800, 0x13,   0x14B,   0x4B,   0,     0  },    // F2 0F 2B                                                                                                                                                                   
   {"movntss",   iSSE4a,  0x1400, 0x13,   0x14C,   0x4C,   0,     0  }};   // F3 0F 2B                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Tertiary opcode map for vmread, EXTRQ/INSERTQ Opcode byte = 0F 78                                                                                                                                                                                   
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
  //{"vmread",  iVMi,     0x1000, 0x13,   0x204,  4,      0,      0  },    // 0F 78                                                                                                                                                                    
  //{"vmread",  iVMi,     0x1000, 0x12,   4,      0x204,  0,      0  },    // 0F 79 should be vmwrite                                                                                                                                                 
                                                                                                                                                                                                                                                       
SOpcodeDef OpcodeMap0F78[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"vmread",    iVMi,    0x1000, 0x13,   0x204,   0x04,   0,     0  },    // 0F 78                                                                                                                                                                      
   {"EXTRQ"  ,   iSSE4a, 0x200,  0x31,   0x20,       0,   0,     0  },    // 66 0F 78 : EXTRQ V[63:0],ib,ib                                                                                                                                             
   {"INSERTQ",   iSSE4a, 0x800,  0x31,   0x20,    0x20,   0,     0  },    // F2 0F 78 ; INSERTQ V[63:0],V[63:0],ib,ib                                                                                                                                   
   {0,           0,      0,      0,      0,       0,      0,     0  }};   // F3 0F 78 illegal                                                                                                                                                           
                                                                                                                                                                                                                                                       
// Tertiary opcode map for vmwrite, EXTRQ/INSERTQ Opcode byte = 0F 79                                                                                                                                                                                  
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
                                                                                                                                                                                                                                                       
SOpcodeDef OpcodeMap0F79[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
   {"vmwrite",   iVMi,   0x1000, 0x12,   0x04,    0x204,  0,     0  },    // 0F 79                                                                                                                                                                     
   {"EXTRQ",     iSSE4a, 0x200,  0x12,   0x20,    0x20,   0,     0  },    // 66 0F 79 ; EXTRQ   V[63:0],V[13:8,5:0]                                                                                                                                    
   {"INSERTQ",   iSSE4a, 0x800,  0x12,   0x20,    0x20,   0,     0  },    // F2 0F 79 ; INSERTQ V[63:0],V[77:72,69:64,63:0]                                                                                                                            
   {0,           0,      0,      0,      0,       0,      0,     0  }};   // F3 0F 79 illegal                                                                                                                                                          
                                                                                                                                                                                                                                                       
// Tertiary opcode map for bsr, LZCNT Opcode byte = 0F BD                                                                                                                                                                                              
// Indexed by prefixes (none, 66, F2, F3)                                                                                                                                                                                                              
SOpcodeDef OpcodeMap0FBD[4] = {                                                                                                                                                                                                                        
//  name         instset prefix  format  dest.   source  link    options                                                                                                                                                                               
//  {"bsr",       i386,   0x1100, 0x12,   9,      0x209,  0,      0  },    // 0F BD                                                                                                                                                                    
                                                                                                                                                                                                                                                       
   {"bsr",       i386,   0x1100, 0x12,   9,      0x209,   0,      0  },    //  0F BD    ??                                                                                                                                                             
   {"bsr",       i386,   0x1100, 0x12,   9,      0x209,   0,      0  },    //  66 0F BD ??                                                                                                                                                             
   {0,           0,      0,      0,      0,      0,       0,      0  },    //  F2 0F BD illegal                                                                                                                                                        
   {"lzcnt",     iSSE4a, 0x1500, 0x12,   9,      0x209,   0,      0  }};    // F3 0F BD                                                                                                                                                                
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
/************** Make pointers to all opcode maps ***************************/                                                                                                                                                                          
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
const SOpcodeDef * const OpcodeTables[] = {                                                                                                                                                                                                            
	   OpcodeMap0,       OpcodeMap0F,      OpcodeMap63,      OpcodeMap80,      OpcodeMap81,      OpcodeMap82,      OpcodeMap83,      OpcodeMap8F,                                                                                                  
	   OpcodeMap90,      OpcodeMap98,      OpcodeMap99,      OpcodeMap9C,      OpcodeMap9D,      OpcodeMapC0,      OpcodeMapC1,      OpcodeMapC6,                                                                                              
       OpcodeMapC7,      OpcodeMapCF,      OpcodeMapD0,      OpcodeMapD1,      OpcodeMapD2,      OpcodeMapD3,      OpcodeMapD8,      OpcodeMapD9,                                                                                                      
       OpcodeMapD9_010,  OpcodeMapD9_100,  OpcodeMapD9_101,  OpcodeMapD9_110,  OpcodeMapD9_111,  OpcodeMapDA,      OpcodeMapDA_101,  OpcodeMapDB,                                                                                                      
       OpcodeMapDB_100,  OpcodeMapDC,      OpcodeMapDD,      OpcodeMapDE,      OpcodeMapDE_011,  OpcodeMapDF,      OpcodeMapDF_100,  OpcodeMapE3,                                                                                                      
	   OpcodeMapF6,      OpcodeMapF7,      OpcodeMapFE,      OpcodeMapFF,                                                                                                                                                                          
                                                                                                                                                                                                                                                       
       OpcodeMap0F00,    OpcodeMap0F01,    OpcodeMap0F01_0,  OpcodeMap0F01_1,  OpcodeMap0F02,    OpcodeMap0F03,    OpcodeMap0F0F,    OpcodeMap0F10,                                                                                                    
	   OpcodeMap0F11,    OpcodeMap0F12,    OpcodeMap0F12n,   OpcodeMap0F16,    OpcodeMap0F16n,   OpcodeMap0F18,    OpcodeMap0F24,    OpcodeMap0F25,                                                                                                
	   OpcodeMap0F2A,    OpcodeMap0F2B,    OpcodeMap0F2C,    OpcodeMap0F2D,    OpcodeMap0F2E,    OpcodeMap0F2F,    OpcodeMap0F38,    OpcodeMap0F38F1,                                                                                              
	   OpcodeMap0F39,    OpcodeMap0F3A,    OpcodeMap0F3A14,  OpcodeMap0F3A15,  OpcodeMap0F3A16,  OpcodeMap0F3A20,  OpcodeMap0F3B,    OpcodeMap0F5A,                                                                                                
	   OpcodeMap0F5B,    OpcodeMap0F6E,    OpcodeMap0F6F,    OpcodeMap0F70,    OpcodeMap0F71,    OpcodeMap0F72,    OpcodeMap0F73,    OpcodeMap0F78,                                                                                                
	   OpcodeMap0F79,    OpcodeMap0F7A,    OpcodeMap0F7B,    OpcodeMap0F7C,    OpcodeMap0F7D,    OpcodeMap0F7E,    OpcodeMap0F7En,   OpcodeMap0F7E_F3,                                                                                             
	   OpcodeMap0F7F,    OpcodeMap0FAE,    OpcodeMap0FB8,    OpcodeMap0FB9,    OpcodeMap0FBA,    OpcodeMap0FBD,    OpcodeMap0FC2,    OpcodeMap0FC4,                                                                                                
	   OpcodeMap0FC7,    OpcodeMap0FC7_1,  OpcodeMap0FC7_6,  OpcodeMap0FD0,    OpcodeMap0FD6,    OpcodeMap0FE6,    OpcodeMap0FE7,    OpcodeMap0FF0,                                                                                                
	   OpcodeMap0FF7                                                                                                                                                                                                                               
 };                                                                                                                                                                                                                                                    
// Macro to calculate the size of an array                                                                                                                                                                                                             
#define TableSize(x) sizeof(x)/sizeof(x[0])                                                                                                                                                                                                            
                                                                                                                                                                                                                                                       
// size of each table pointed to by OpcodeTables[]                                                                                                                                                                                                     
const  uint32 OpcodeTableLength[] = {                                                                                                                                                                                                                  
	   TableSize(OpcodeMap0),       TableSize(OpcodeMap0F),      TableSize(OpcodeMap63),      TableSize(OpcodeMap80),      TableSize(OpcodeMap81),      TableSize(OpcodeMap82),      TableSize(OpcodeMap83),      TableSize(OpcodeMap8F),          
	   TableSize(OpcodeMap90), 		TableSize(OpcodeMap98),      TableSize(OpcodeMap99),      TableSize(OpcodeMap9C),      TableSize(OpcodeMap9D),      TableSize(OpcodeMapC0),      TableSize(OpcodeMapC1),      TableSize(OpcodeMapC6),  
       TableSize(OpcodeMapC7),      TableSize(OpcodeMapCF),		 TableSize(OpcodeMapD0),      TableSize(OpcodeMapD1),      TableSize(OpcodeMapD2),      TableSize(OpcodeMapD3),      TableSize(OpcodeMapD8),      TableSize(OpcodeMapD9),      
       TableSize(OpcodeMapD9_010),  TableSize(OpcodeMapD9_100),  TableSize(OpcodeMapD9_101),  TableSize(OpcodeMapD9_110),  TableSize(OpcodeMapD9_111),  TableSize(OpcodeMapDA),      TableSize(OpcodeMapDA_101),  TableSize(OpcodeMapDB),              
       TableSize(OpcodeMapDB_100),  TableSize(OpcodeMapDC),      TableSize(OpcodeMapDD),      TableSize(OpcodeMapDE),      TableSize(OpcodeMapDE_011),  TableSize(OpcodeMapDF),      TableSize(OpcodeMapDF_100),  TableSize(OpcodeMapE3),              
	   TableSize(OpcodeMapF6),      TableSize(OpcodeMapF7),      TableSize(OpcodeMapFE),      TableSize(OpcodeMapFF),                                                                                                                              
                                                                                                                                                                                                                                                       
       TableSize(OpcodeMap0F00),    TableSize(OpcodeMap0F01),    TableSize(OpcodeMap0F01_0),  TableSize(OpcodeMap0F01_1),  TableSize(OpcodeMap0F02),    TableSize(OpcodeMap0F03),    TableSize(OpcodeMap0F0F),    TableSize(OpcodeMap0F10),            
	   TableSize(OpcodeMap0F11),    TableSize(OpcodeMap0F12),    TableSize(OpcodeMap0F12n),   TableSize(OpcodeMap0F16),    TableSize(OpcodeMap0F16n),   TableSize(OpcodeMap0F18),    TableSize(OpcodeMap0F24),    TableSize(OpcodeMap0F25),        
	   TableSize(OpcodeMap0F2A),    TableSize(OpcodeMap0F2B),    TableSize(OpcodeMap0F2C),    TableSize(OpcodeMap0F2D),    TableSize(OpcodeMap0F2E),    TableSize(OpcodeMap0F2F),    TableSize(OpcodeMap0F38),    TableSize(OpcodeMap0F38F1),      
	   TableSize(OpcodeMap0F39),    TableSize(OpcodeMap0F3A),    TableSize(OpcodeMap0F3A14),  TableSize(OpcodeMap0F3A15),  TableSize(OpcodeMap0F3A16),  TableSize(OpcodeMap0F3A20),  TableSize(OpcodeMap0F3B),    TableSize(OpcodeMap0F5A),        
	   TableSize(OpcodeMap0F5B),    TableSize(OpcodeMap0F6E),    TableSize(OpcodeMap0F6F),    TableSize(OpcodeMap0F70),    TableSize(OpcodeMap0F71),    TableSize(OpcodeMap0F72),    TableSize(OpcodeMap0F73),    TableSize(OpcodeMap0F78),        
	   TableSize(OpcodeMap0F79),    TableSize(OpcodeMap0F7A),    TableSize(OpcodeMap0F7B),    TableSize(OpcodeMap0F7C),    TableSize(OpcodeMap0F7D),    TableSize(OpcodeMap0F7E),    TableSize(OpcodeMap0F7En),   TableSize(OpcodeMap0F7E_F3),     
	   TableSize(OpcodeMap0F7F),    TableSize(OpcodeMap0FAE),    TableSize(OpcodeMap0FB8),    TableSize(OpcodeMap0FB9),    TableSize(OpcodeMap0FBA),    TableSize(OpcodeMap0FBD),    TableSize(OpcodeMap0FC2),    TableSize(OpcodeMap0FC4),        
	   TableSize(OpcodeMap0FC7),    TableSize(OpcodeMap0FC7_1),  TableSize(OpcodeMap0FC7_6),  TableSize(OpcodeMap0FD0),    TableSize(OpcodeMap0FD6),    TableSize(OpcodeMap0FE6),    TableSize(OpcodeMap0FE7),    TableSize(OpcodeMap0FF0),        
	   TableSize(OpcodeMap0FF7)                                                                                                                                                                                                                    
 };                                                                                                                                                                                                                                                    
// number of entries in OpcodeTables                                                                                                                                                                                                                   
const uint32 NumOpcodeTables1 = TableSize(OpcodeTables);                                                                                                                                                                                               
const uint32 NumOpcodeTables2 = TableSize(OpcodeTableLength);                                                                                                                                                                                          
                                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                       
// Define register names                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                       
// Names of 8 bit registers                                                                                                                                                                                                                            
const char * RegisterNames8[8] = {                                                                                                                                                                                                                     
   "al", "cl", "dl", "bl", "ah", "ch", "dh", "bh" };                                                                                                                                                                                                   
                                                                                                                                                                                                                                                       
// Names of 8 bit registers with REX prefix                                                                                                                                                                                                            
const char * RegisterNames8x[16] = {                                                                                                                                                                                                                   
   "al", "cl", "dl", "bl", "spl", "bpl", "sil", "dil",                                                                                                                                                                                                 
   "r8b", "r9b", "r10b", "r11b", "r12b", "r13b", "r14b", "r15b"  };                                                                                                                                                                                    
                                                                                                                                                                                                                                                       
// Names of 16 bit registers                                                                                                                                                                                                                           
const char * RegisterNames16[16] = {                                                                                                                                                                                                                   
   "ax", "cx", "dx", "bx", "sp", "bp", "si", "di",                                                                                                                                                                                                     
   "r8w", "r9w", "r10w", "r11w", "r12w", "r13w", "r14w", "r15w" };                                                                                                                                                                                     
                                                                                                                                                                                                                                                       
// Names of 32 bit registers                                                                                                                                                                                                                           
const char * RegisterNames32[16] = {                                                                                                                                                                                                                   
   "eax", "ecx", "edx", "ebx", "esp", "ebp", "esi", "edi",                                                                                                                                                                                             
   "r8d", "r9d", "r10d", "r11d", "r12d", "r13d", "r14d", "r15d" };                                                                                                                                                                                     
                                                                                                                                                                                                                                                       
// Names of 64 bit registers                                                                                                                                                                                                                           
const char * RegisterNames64[16] = {                                                                                                                                                                                                                   
   "rax", "rcx", "rdx", "rbx", "rsp", "rbp", "rsi", "rdi",                                                                                                                                                                                             
   "r8",  "r9",  "r10", "r11", "r12", "r13", "r14", "r15" };                                                                                                                                                                                           
                                                                                                                                                                                                                                                       
// Names of segment registers                                                                                                                                                                                                                          
const char * RegisterNamesSeg[8] = {                                                                                                                                                                                                                   
   "es", "cs", "ss", "ds", "fs", "gs", "hs?", "is?" }; // Last two are illegal or undocumented                                                                                                                                                         
                                                                                                                                                                                                                                                       
// Names of control registers                                                                                                                                                                                                                          
const char * RegisterNamesCR[16] = {                                                                                                                                                                                                                   
   "cr0", "cr1 ?", "cr2", "cr3", "cr4", "cr5 ?", "cr6 ?", "cr7 ?",                                                                                                                                                                                     
   "cr8", "cr9 ?", "cr10 ?", "cr11 ?", "cr12 ?", "cr13 ?", "cr14 ?", "cr15 ?" }; // Those with ? are illegal                                                                                                                                           