<?php

class CFileSystem {

    /**
    * Returns a list of subfolders of the given path
    * The function is static, it can be used like this:
    * $arrFolders = CFileSystem::getFolders('/cataclog_files/subfolder/test');
    *
    * @param string $strPath The path for that the subfolders should be returned
    * @param array An array of strings with the foler names
    */
    public static function getFolders($strPath)
    {
        if (file_exists($strPath))
		{
    		if ("/" != 	substr($strPath, -1, 1))
    		{
    			$strPath = $strPath."/";
    		}

    		$handle = opendir($strPath);

    		while (false !== ($folder = readdir($handle)))
    		{
    			if(is_dir($strPath.$folder))
    			{
    				if ( ($folder != "..") && ($folder != ".") )
    				{
    					$dirlist[] = $folder;
    				}
    			}
    		}
    		closedir($handle);

    		return $dirlist;
		}
    }
    
    
    public static function getFiles($strCurFolder)
	{
		if (file_exists($strCurFolder))
		{
    		if ("/" != 	substr($strCurFolder, -1, 1))
    		{
    			$strCurFolder = $strCurFolder."/";
    		}
    		$handle=opendir ($strCurFolder);

    		while (false !== ($file = readdir ($handle)))
    		{
    			if(is_file($strCurFolder.$file))
    			{
				if (strcasecmp("Thumbs.db", $file) != 0)
				{
					$filelist[] = $file;
				}
    			}
    		}
    		closedir($handle);

    		return $filelist;
		}
	}
    
}
?>
