// $Id: ShowTIB.cpp 250 2007-04-26 09:12:18Z olau $

//==========================================================================
// File: SHOWTIB.CPP
// Author: Matt Pietrek
//
// Changes by Oliver Lau <ola@ct.heise.de>:
// * Added function InitTIBViewer()
// * Added function CleanupTIBViewer()
// * Disabled warnings 4312, 4313
//==========================================================================
#include "stdafx.h"

#define SHOWTIB_MAX_THREADS 64

CRITICAL_SECTION gDisplayTIB_CritSect;

void DisplayTIB( PSTR pszThreadName )
{
    PTIB pTIB;
    WORD fsSel;

    EnterCriticalSection( &gDisplayTIB_CritSect );

    __asm
    {
        mov     EAX, FS:[18h]
        mov     [pTIB], EAX
        mov     [fsSel], FS
    }
        
    printf( "Contents of thread %s\n", pszThreadName );

#pragma warning(push)
#pragma warning(disable: 4313 4312)
    
    printf( "  TIB %04X (Address: %08X)\n", fsSel, pTIB );
    printf( "  SEH chain: %08X\n", pTIB->pvExcept );
    printf( "  Stack top: %08X\n", pTIB->pvStackUserTop );
    printf( "  Stack base: %08X\n", pTIB->pvStackUserBase );
    printf( "  pvArbitray: %08X\n", pTIB->pvArbitrary );
    printf( "  TLS array *: %08X\n", pTIB->pvTLSArray );

    printf( "  ----OS Specific fields----\n" );
    if ( 0xC0000000 == (GetVersion() & 0xC0000000) )    // Is this Win95 ?
    {
        printf( "  TDB: %04X\n", pTIB->TIB_UNION1.WIN95.pvTDB );
        printf( "  Thunk SS: %04X\n", pTIB->TIB_UNION1.WIN95.pvThunkSS );
        printf( "  TIB flags: %04X\n", pTIB->TIB_UNION2.WIN95.TIBFlags );
        printf( "  Win16Mutex count: %04X\n",
                    pTIB->TIB_UNION2.WIN95.Win16MutexCount );
        printf( "  DebugContext: %08X\n", pTIB->TIB_UNION2.WIN95.DebugContext );
        printf( "  Current Priority *: %08X (%u)\n",
                    pTIB->TIB_UNION2.WIN95.pCurrentPriority,
                    *(PDWORD)(pTIB->TIB_UNION2.WIN95.pCurrentPriority) );
        printf( "  Queue: %04X\n", pTIB->TIB_UNION2.WIN95.pvQueue );
        printf( "  Process *: %08X\n", pTIB->TIB_UNION3.WIN95.pProcess );
    }
    else if ( 0 == (GetVersion() & 0xC0000000) )    // Is this WinNT?
    {
        printf("  SubSystem TIB: %08X\n", pTIB->TIB_UNION1.WINNT.SubSystemTib);
        printf("  FiberData: %08X\n", pTIB->TIB_UNION1.WINNT.FiberData );
        printf("  unknown1: %08X\n", pTIB->TIB_UNION2.WINNT.unknown1);
        printf("  process ID: %08X\n", pTIB->TIB_UNION2.WINNT.processID);
        printf("  thread ID: %08X\n", pTIB->TIB_UNION2.WINNT.threadID);
        printf("  unknown2: %08X\n", pTIB->TIB_UNION2.WINNT.unknown2);
    }
    else
    {
        printf("  Unsupported Win32 implementation\n" );
    }

    printf( "\n" );

    LeaveCriticalSection( &gDisplayTIB_CritSect );

#pragma warning(pop)
}


void InitTIBViewer(void)
{
    InitializeCriticalSection( &gDisplayTIB_CritSect );
}


void CleanupTIBViewer(void)
{
    DeleteCriticalSection( &gDisplayTIB_CritSect );
}
