// $Id: ColorScheme.cpp 276 2007-04-30 09:30:44Z olau $

#include "stdafx.h"

Mutex ColorScheme::mutex;
bool ColorScheme::initialized = false;

ColorScheme::ColorScheme(int which)
{
    mutex.lock();
    if (!initialized)
    {
        const int stripes = 512;
        for (int i = 0; i < stripes; ++i)
        {
            rainbow[i] = rgbFromWaveLength(380.0 + (i * 400.0 / stripes));
        }
        initialized = true;
    }
    mutex.unlock();
    choose(which);
}

void ColorScheme::choose(int which)
{
    switch (which)
    {
    case PastelGreen:
        numColors = 4;
        table = pastelGreens;
        break;
    case GreenTomato:
        numColors = 8;
        table = greenTomato;
        break;
    case VioletTriade:
        numColors = 12;
        table = violetTriade;
        break;
    case Tetrade90:
        numColors = 16;
        table = tetrade90;
        break;
    case Rainbow:
    default:
        numColors = 512;
        table = rainbow;
        break;
    }
}


// color schemes generated by
// http://wellstyled.com/tools/colorscheme2/index-en.html

COLORREF ColorScheme::pastelGreens[] = {
    RGB(0xcc, 0xff, 0x00),
    RGB(0x8f, 0xb3, 0x00),
    RGB(0xf2, 0xff, 0xbf),
    RGB(0xe6, 0xff, 0x80),
};

COLORREF ColorScheme::greenTomato[] = {
    RGB(0xff, 0x00, 0x00),
    RGB(0xb3, 0x00, 0x00),
    RGB(0xff, 0xbf, 0xbf),
    RGB(0xff, 0x80, 0x80),
    RGB(0x00, 0xcc, 0x00),
    RGB(0x00, 0x8f, 0x00),
    RGB(0xbf, 0xff, 0xbf),
    RGB(0x80, 0xff, 0x80),
};

COLORREF ColorScheme::violetTriade[] = {
    RGB(0xba, 0x00, 0x98),
    RGB(0x82, 0x00, 0x6b),
    RGB(0xff, 0xbf, 0xf3),
    RGB(0xff, 0x80, 0xe8),
    RGB(0xbe, 0xff, 0x00),
    RGB(0x85, 0xb3, 0x00),
    RGB(0xef, 0xff, 0xbf),
    RGB(0xdf, 0xff, 0x80),
    RGB(0x92, 0xff, 0x00),
    RGB(0x66, 0xb3, 0x00),
    RGB(0xe4, 0xff, 0xbf),
    RGB(0xc9, 0xff, 0x80),
};

COLORREF ColorScheme::tetrade90[] = {
    RGB(0xff, 0xcc, 0x00),
    RGB(0xb3, 0x8f, 0x00),
    RGB(0xff, 0xf2, 0xbf),
    RGB(0xff, 0xfe, 0x80),
    RGB(0x33, 0x00, 0x99),
    RGB(0x24, 0x00, 0x6b),
    RGB(0xd5, 0xbf, 0xff),
    RGB(0xaa, 0x80, 0xff),
    RGB(0x99, 0x00, 0x99),
    RGB(0x6b, 0x00, 0x6b),
    RGB(0xfb, 0xbf, 0xff),
    RGB(0xff, 0x80, 0xff),
    RGB(0xcc, 0xff, 0x00),
    RGB(0x8f, 0xb3, 0x00),
    RGB(0xf2, 0xff, 0xbf),
    RGB(0xe6, 0xff, 0x80),
};

COLORREF ColorScheme::rainbow[512];

COLORREF ColorScheme::rgbFromWaveLength(double wave)
{
    double r = 0.0;
    double g = 0.0;
    double b = 0.0;

    if (wave >= 380.0 && wave <= 440.0) {
        r = -1.0 * (wave - 440.0) / (440.0 - 380.0);
        b = 1.0;
    }
    else if (wave >= 440.0 && wave <= 490.0) {
        g = (wave - 440.0) / (490.0 - 440.0);
        b = 1.0;
    }
    else if (wave >= 490.0 && wave <= 510.0) {
        g = 1.0;
        b = -1.0 * (wave - 510.0) / (510.0 - 490.0);
    }
    else if (wave >= 510.0 && wave <= 580.0) {
        r = (wave - 510.0) / (580.0 - 510.0);
        g = 1.0;
    }
    else if (wave >= 580.0 && wave <= 645.0) {
        r = 1.0;
        g = -1.0 * (wave - 645.0) / (645.0 - 580.0);
    }
    else if (wave >= 645.0 && wave <= 780.0) {
        r = 1.0;
    }

    double s = 1.0;
    if (wave > 700.0)
        s = 0.3 + 0.7 * (780.0 - wave) / (780.0 - 700.0);
    else if (wave <  420.0)
        s = 0.3 + 0.7 * (wave - 380.0) / (420.0 - 380.0);

    r = pow(r * s, 0.8);
    g = pow(g * s, 0.8);
    b = pow(b * s, 0.8);

    return RGB(r * 255, g * 255, b * 255);
}
