// $Id: ThreadPool.cpp 302 2007-05-03 15:20:29Z olau $

#include "stdafx.h"

#pragma region WorkerThreadClass
///////////////////////////////////////////////////////////////////
// class WorkerThread
///////////////////////////////////////////////////////////////////

THREADRESULT WorkerThread::run(void)
{
    if (name != NULL)
    {
        setName(name);
    }
    else
    {
        const int buflen = 20;
        char strbuf[buflen];
        sprintf_s(strbuf, buflen, "WorkerThread-0x%04x", GetCurrentThreadId());
        setName(strbuf);
    }

    // process job queue until queue is empty
    for (;;)
    {
        printf("  WorkerThread 0x%x waits for trigger ..\n", GetCurrentThreadId());
        waitForTrigger();
        printf("  WorkerThread 0x%x triggered ..\n", GetCurrentThreadId());

        if (doQuit)
            break;

        Job *job;
        while ((job = pool->nextJob()) != NULL)
        {
            job->run();
        }

        printf("  WorkerThread 0x%x is ready ..\n", GetCurrentThreadId());
        signalReady();
    }
    return 0;
}


void WorkerThread::waitForTrigger(void)
{
    WaitForSingleObject(hTriggerEvent, INFINITE);
}


int WorkerThread::signalReady(void)
{
    if (!SetEvent(hReadyEvent))
    {
        return SetEventFailed;
    }
    return NoError;
}
#pragma endregion


#pragma region ThreadPoolClass

///////////////////////////////////////////////////////////////////
// class ThreadPool
///////////////////////////////////////////////////////////////////


ThreadPool::ThreadPool(int maxThreads) : maximumNumberOfThreads(maxThreads)
{
    m_mutex = new Mutex;
    numberOfThreads = 0;

    for (int i = 0; i < maximumNumberOfThreads; ++i)
    {
        HANDLE hTE = CreateEvent(NULL, FALSE, FALSE, NULL);
        hTriggerEvent[numberOfThreads] = hTE;

        HANDLE hRE = CreateEvent(NULL, FALSE, FALSE, NULL);
        hReadyEvent[numberOfThreads] = hRE;

        const int buflen = 20;
        char *strbuf = new char[buflen];
        sprintf_s(strbuf, buflen, "WorkerThread %2d", i);
        pool[numberOfThreads++] = new WorkerThread(this, hTE, hRE, strbuf);
    }
}


ThreadPool::~ThreadPool()
{
    for (int i = 0; i < numberOfThreads; ++i)
    {
        if (pool[i] != NULL)
        {
            pool[i]->wait();
        }
    }
    numberOfThreads = 0;
    m_mutex->lock();
    jobs.empty();
    m_mutex->unlock();
    delete m_mutex;
}


void ThreadPool::enqueue(Job *job)
{
    m_mutex->lock();
    jobs.push(job);
    m_mutex->unlock();
}


int ThreadPool::run()
{
    for (int i = 0; i < numberOfThreads; ++i)
    {
        pool[i]->start();
    }
    return signalAll();
}


void ThreadPool::quitAll()
{
    for (int i = 0; i < numberOfThreads; ++i)
    {
        pool[i]->doQuit = true;
    }
}


void ThreadPool::stop()
{
    quitAll();
    signalAll();
}


int ThreadPool::signalAll()
{
    for (int i = 0; i < numberOfThreads; ++i)
    {
        if (!SetEvent(hTriggerEvent[i]))
        {
            return SetEventFailed;
        }
    }
    return NoError;
}


void ThreadPool::waitForAll()
{
    printf("ThreadPool::waitForAll() ENTRY\n");
    WaitForMultipleObjects(numberOfThreads, hReadyEvent, TRUE, INFINITE);
    printf("ThreadPool::waitForAll() READY\n");
}


Job *ThreadPool::nextJob()
{
    Job *job = NULL; 
    m_mutex->lock();
    if (!jobs.empty())
    {
        job = jobs.front();
        jobs.pop();
    }
    m_mutex->unlock();
    return job;
}

#pragma endregion
