#pragma once

#include "resource.h"
#include "stdafx.h"

#ifdef _DEBUG
#define NOP() __asm nop
#else
#define NOP()
#endif //_DEBUG

#ifndef MAXITERATIONS
#define MAXITERATIONS (1000)
#endif

#ifndef NUMTHREADS
#define NUMTHREADS (2)
#endif

#ifndef JOBSPERTHREAD
#define JOBSPERTHREAD (8)
#endif

#ifndef MAXNUMTHREADS
#define MAXNUMTHREADS (32)
#endif

#ifndef DEFAULTDEBUGLEVEL
#define DEFAULTDEBUGLEVEL (1)
#endif

#define CACHELINE_SIZE (128)

class Stopwatch;

enum ZoomDirection {
    NotZooming = FALSE,
    ZoomingIn,
    ZoomingOut,
};

enum TriggerAction {
    TriggerZoom,
    TriggerPan,
};


// typedefs

struct TriggerParam
{
    int action;
    union
    {
        // data for action "TriggerZoom"
        double zoom;
        // data for action "TriggerPan"
        struct _TriggerParaPanData {
            double offsetR;
            double offsetI;
        };
    };
};


struct MandelbrotSetParam
{
    __declspec(align(128)) int id;
    int width;
    int height;
    int totalHeight;
    __declspec(align(16)) __int64 iterations;
    __declspec(align(16)) double deltaT;
    __declspec(align(4)) bool ready;
    __declspec(align(4)) bool active;
    __declspec(align(4)) bool restart;
    double reC;
    double imC;
    double scale;
    HBITMAP hBitmap;
    HDC hdc;
    BITMAP bitmap;
    BITMAPINFO bi;
};

// scale=1.87743e-011, re(c)=0.36380648408020388, im(c)=0.66475706843006455, depth=1000
// scale=1.33808e-010, re(c)=0.36380610767021038, im(c)=0.66475707767637837, depth=1000
// scale=5.56812e-005, re(c)=-0.29867429711244042, im(c)=0.65802390315065062, depth=2000
// scale=5.48077e-007, re(c)=-0.29848481021924284, im(c)=0.65842949779550752, depth=2000
// scale=9.84313e-006, re(c)=-0.34303741935106974, im(c)=0.63988823083861535, depth=2000

// constants
const int MaxNumThreads = MAXNUMTHREADS;
const int DefaultNumThreads = NUMTHREADS;
const int DefaultJobsPerThread = JOBSPERTHREAD;
const int MaxDebugLevel = 5;
const double AutomaticZoomInFactor  = 0.94387431268169349664191315666753; // 1/(2^(1/12))
const double AutomaticZoomOutFactor = 1.0 / 0.94387431268169349664191315666753;
const double AutomaticCenterR = 0.35218629245760352;
const double AutomaticCenterI = 0.42202865733439998;
const double ZoomInFactor  = 0.8;
const double ZoomOutFactor = 1.0 / ZoomInFactor;
const double MinZoom = 1e-3;
const double MaxZoom = 1e-15;
const double DefaultCenterR     = -0.66;
const double DefaultCenterI     = 0.0;
const double DefaultScaleFactor = MinZoom;
const double DefaultThreshold   = 4.0;
const int DefaultMaxIterations  = MAXITERATIONS;


// variables
extern HWND hMainWindow;
extern MandelbrotSetParam param[];
extern __declspec(align(16)) double threshold;
extern __declspec(align(16)) double scaleFactor;
extern __declspec(align(16)) double centerR;
extern __declspec(align(16)) double centerI;
extern int jobsPerThread;
extern int maxIterations;
extern int numThreads;
extern bool doAbort;
extern bool doPause;
extern int debugLevel;
extern ParallelLog logBuf;
extern int zooming;
extern CRITICAL_SECTION critSecAbort;
extern CRITICAL_SECTION critSecZooming;
extern double zoomDelta;
extern ThreadPool *pool;
extern HANDLE hTriggerEvent;
extern Stopwatch *stopwatch;
extern void FillPool();

// functions
extern double CalcItersPerSecond();
