/*
============================================================================
 Name        : HelloworldApp.h
 Author      : Frank Fitzek And Morten V. Pedseren
 Copyright   : Mobile Devices Team - AAU
 Description : Declares main application class.
============================================================================
*/

#ifndef HELLOWORLDAPP_H
#define HELLOWORLDAPP_H

// INCLUDES
#include <aknapp.h>

// CONSTANTS
// UID of the application
const TUid KUidHelloworld = { 0x0240C2B7 };

// CLASS DECLARATION

/**
* CHelloworldApp application class.
* Provides factory to create concrete document object.
*
*/
class CHelloworldApp : public CAknApplication
    {

    public: // Functions from base classes
    private:

        /**
        * From CApaApplication, creates CHelloworldDocument document object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();

        /**
        * From CApaApplication, returns application's UID (KUidHelloworld).
        * @return The value of KUidHelloworld.
        */
        TUid AppDllUid() const;
    };

#endif



