/*
============================================================================
 Author      : Frank Fitzek And Morten V. Pedseren
 Copyright   : Mobile Devices Team - AAU
============================================================================
*/

#ifndef FILEPUSHER_H_
#define FILEPUSHER_H_

#include <e32base.h>
#include <bttypes.h> // TBTDevAddr

// Forward declarations
class CObexClient;
class CObexFileObject;

class CFilepusher : public CActive
{
public: 
    static CFilepusher* NewL();
    void StartL(); 

    ~CFilepusher();    

private:
    void ConstructL();
    CFilepusher();
    
private: // From CActive
    void RunL();
    void DoCancel();
    TInt RunError(TInt);
    
private:
    enum TState{ EIdle, EConnecting, ETransferring, EDisconnecting };
    TState iState;
    
    CObexClient *iClient;
    CObexFileObject *iObexFile;
   
    TBTDevAddr iBTAddr;       
};

#endif /*FILEPUSHER_H_*/
