'Namespace fr vereinfachten RegEx-Zugriff einbinden
Imports System.Text.RegularExpressions

Public Class ThisDocument

    'Ereignisfhige Objektvariable fr die SmartTag-Aktion anlegen
    WithEvents aktion As Microsoft.Office.Tools.Word.Action

    Private Sub ThisDocument_Startup(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Startup
        'Aktion definieren
        aktion = New Microsoft.Office.Tools.Word.Action("In Bytes umrechnen")

        'Neues SmartTag anlegen und diesem...
        Dim st As New Microsoft.Office.Tools.Word.SmartTag("www.microsoft.com/Beispiel#BeispielSmartTag", "Demo-SmartTag")
        With st
            '... die Aktion hinzufgen
            .Actions = New Microsoft.Office.Tools.Word.Action() {aktion}
            'Einen regulren Ausdruck zur Inhaltserkennung hinzufgen
            .Expressions.Add(New Regex("(?'megabytes'\b[0-9]+)?\s?( MB| mb)\b"))
        End With

        'Fertiges SmartTag dem Dokument hinzufgen
        Me.VstoSmartTags.Add(st)
    End Sub

    Private Sub ThisDocument_Shutdown(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Shutdown

    End Sub

    Sub aktion_Click(ByVal sender As Object, ByVal e As Microsoft.Office.Tools.Word.ActionEventArgs) Handles aktion.Click
        'Wert aus megabytes-Key des SmartTags lesen
        Dim wert As String = e.Properties.Read("megabytes")
        'String in Double konvertieren
        Dim mbytes As Long = Convert.ToInt64(wert)
        'Umrechnen in Bytes
        Dim bytes As Long = mbytes * 1024 * 1024

        'Markierten SmartTag-Text ersetzen
        e.Range.Text = bytes.ToString("0,0 Bytes")
    End Sub
End Class
