﻿Imports System
Imports System.Collections.Generic
Imports System.Diagnostics
Imports System.IO
Imports System.Text
Imports System.Reflection
Imports System.Runtime.InteropServices
Imports System.Windows.Forms
Imports Office = Microsoft.Office.Core

' TODO:
' Dies ist eine Überschreibung der RequestService-Methode in der ThisAddIn-Klasse.
' Um die benutzerdefinierte Multifunktionsleiste einzubinden, heben Sie die Auskommentierung dieses Codes auf.
Partial Public Class ThisAddIn

    Private ribbon As Ribbon1

    Protected Overrides Function RequestService(ByVal serviceGuid As Guid) As Object
        If serviceGuid = GetType(Office.IRibbonExtensibility).GUID Then
            If ribbon Is Nothing Then
                ribbon = New Ribbon1()
            End If
            Return ribbon
        End If

        Return MyBase.RequestService(serviceGuid)
    End Function

End Class

<ComVisible(True)> _
    Public Class Ribbon1
    Implements Office.IRibbonExtensibility

    Private ribbon As Office.IRibbonUI

    Public Sub New()
    End Sub

    Public Function GetCustomUI(ByVal ribbonID As String) As String Implements Office.IRibbonExtensibility.GetCustomUI
        Return GetResourceText("WordAddIn1.Ribbon1.xml")
    End Function

#Region "Multifunktionsleisten-Callbacks"

    Public Sub OnLoad(ByVal ribbonUI As Office.IRibbonUI)
        Me.ribbon = ribbonUI
    End Sub

    Public Sub OnToggleButton1(ByVal control As Office.IRibbonControl, ByVal isPressed As Boolean)
        'Wenn RibbonX-ToggleButton gedrückt ist, dann...
        If isPressed Then
            '... entsprechende Statusmeldung ausgeben
            MessageBox.Show("Toggle-Button gedrückt")

            'Ansonsten...
        Else
            '... entsprechende Statusmeldung ausgeben
            MessageBox.Show("Toggle-Button losgelassen")
        End If
    End Sub

    Public Sub OnNormalButton1(ByVal control As Office.IRibbonControl)
        'Wenn normaler RibbonX-Button gedrückt, dann Meldung ausgeben
        MessageBox.Show("Button gedrückt")
    End Sub

#End Region

#Region "Hilfsfunktionen"

    Private Shared Function GetResourceText(ByVal resourceName As String) As String
        Dim asm As Assembly = Assembly.GetExecutingAssembly()
        Dim resourceNames() As String = asm.GetManifestResourceNames()
        For i As Integer = 0 To resourceNames.Length - 1
            If String.Compare(resourceName, resourceNames(i), StringComparison.OrdinalIgnoreCase) = 0 Then
                Using resourceReader As StreamReader = New StreamReader(asm.GetManifestResourceStream(resourceNames(i)))
                    If resourceReader IsNot Nothing Then
                        Return resourceReader.ReadToEnd()
                    End If
                End Using
            End If
        Next
        Return Nothing
    End Function

#End Region

End Class
