/*	Projekt UacTest
	SpeedProject
	Copyright  1995 - 2006. Alle Rechte vorbehalten.

	Datei:		UacTestDlg.cpp
	Autor:		Sven Ritter
	Datum:		08.11.2006 - 19:41:44


	UEBERBLICK
	==========
	Quelltextdatei fuer die Implementation von CUacTestDlg	(CDialog).
*/


#include "StdAfx.h"

//
#include "UacTest.h"
#include "UacTestDlg.h"

// UAC-Helper
#include "..\UacHelper\UacHelperInterfaces.h"


// ****************************************************************************
// ******                  DEBUG-Makro (ASSERT und VERIFY)               ******
// ****************************************************************************
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


// ****************************************************************************
// ******                   DEBUG-Makro (Speicherfreigabe)               ******
// ****************************************************************************
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// ****************************************************************************
// ******                  Konstanten und globale Variablen              ******
// ****************************************************************************


// ****************************************************************************
// ******                     Definition der MessageMap                  ******
// ****************************************************************************
BEGIN_MESSAGE_MAP(CUacTestDlg, CDialog)
	//{{AFX_MSG_MAP(CUacTestDlg)
	ON_BN_CLICKED(IDC_UACTEST_ELEVATE, OnOnBnClickedElevate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// UAC-Objekt instantiieren
HRESULT GetElevationObject(HWND hWnd, REFCLSID rclsid, REFIID riid, void** ppvObject)
{
	// Lokale Variablen
	BIND_OPTS3 bo; WCHAR wszCLSID[50], wszMonikerName[300];

	// GUID in Zeichenform
	StringFromGUID2(rclsid, wszCLSID, countof(wszCLSID)); 
	StringCchPrintfW(wszMonikerName, countof(wszMonikerName), L"Elevation:Administrator!new:%s", wszCLSID);

	// Desktop-Fenster verwenden, falls das Hauptfenster nicht sichtbar ist
	if (!IsWindowVisible(hWnd))
	{
		hWnd = HWND_DESKTOP;
	}

	// Bind-Struktur initialisieren
	memset(&bo, 0, sizeof(bo));
	bo.cbStruct = sizeof(bo);
	bo.hwnd = hWnd;
	bo.dwClassContext = CLSCTX_LOCAL_SERVER;

	// Objekt erstellen
	return CoGetObject(wszMonikerName, &bo, riid, ppvObject);
}


// ****************************************************************************
// ******                   Implementation zu CUacTestDlg                ******
// ****************************************************************************
CUacTestDlg::CUacTestDlg(CWnd* pParent)
	: CDialog(CUacTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUacTestDlg)
	//}}AFX_DATA_INIT
}

// Datenaustausch
void CUacTestDlg::DoDataExchange(CDataExchange* pDX)
{
	// Standardverarbeitung
	CDialog::DoDataExchange(pDX);
	
	//{{AFX_DATA_MAP(CUacTestDlg)
	//}}AFX_DATA_MAP
}

// WM_INITDIALOG
//
//	-> Dialog initialisieren
BOOL CUacTestDlg::OnInitDialog()
{
	// Standardverarbeitung
	CDialog::OnInitDialog();

	// Icon laden
	HICON hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	// Programmsymbol fuer Dialogfeld setzen
	SetIcon(hIcon, TRUE); SetIcon(hIcon, FALSE);

	// Schild-Symbol setzen
	Button_SetElevationRequiredState(::GetDlgItem(m_hWnd, IDC_UACTEST_ELEVATE), TRUE);

	// Tests durchfuehren
	CheckElevation(); CheckFileAccess(); CheckRegistryAccess();

	// Alles ok
	return TRUE;
}

// WM_COMMAND: IDC_UACTEST_ELEVATE (BN_CLICKED)
//
//	-> Test mit Adminrechten
void CUacTestDlg::OnOnBnClickedElevate() 
{
	// COM-Objekt erstellen
	IUacWorkerPtr pUacWorker;
	HRESULT hResult = GetElevationObject(m_hWnd, CLSID_UacWorker, IID_IUacWorker, (void**) &pUacWorker);

	// Fehler
	if (FAILED(hResult))
	{
		// Fehlermeldung ermitteln
		TCHAR szLastError[260];
		FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, hResult, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), szLastError, countof(szLastError), NULL);

		// Fehler formatieren
		TCHAR szError[260]; 
		StringCchPrintf(szError, countof(szError), _T("COM-Objekt kann nicht erstellt werden.\r\n\r\nFehler: 0x%.8x - %s"), hResult, szLastError);

		// Fehlermeldung anzeigen
		AfxMessageBox(szError, MB_ICONEXCLAMATION);

		// Fehler
		return;
	}

	// Elevation-Status ermitteln
	TOKEN_ELEVATION_TYPE eTokenElevation = TokenElevationTypeDefault;
	hResult = pUacWorker->CheckElevation((UINT*) &eTokenElevation);
	if (SUCCEEDED(hResult))
	{
		// Entsprechend des Typs...
		switch (eTokenElevation)
		{
			// Normaler Benutzer oder UAC deaktiviert
			case TokenElevationTypeDefault:

				SetDlgItemText(IDC_UACTEST_ELEVATION, _T("Einfacher Benutzer bzw. UAC ist deaktiviert"));
				break;

			// Volle Adminrechte
			case TokenElevationTypeFull:

				SetDlgItemText(IDC_UACTEST_ELEVATION, _T("Administrator"));
				break;

			// Limitierter Account
			case TokenElevationTypeLimited:

				SetDlgItemText(IDC_UACTEST_ELEVATION, _T("Eingeschrnkter Administrator"));
				break;
		}
	}

	// Fehler
	else
	{
		SetLastErrorMsg(IDC_UACTEST_ELEVATION, hResult);
	}

	// Dateizugriff pruefen
	hResult = pUacWorker->CheckFileAccess();
	if (SUCCEEDED(hResult))
	{
		SetDlgItemText(IDC_UACTEST_FILE, _T("Erfolg"));
	}

	// Fehler
	else
	{
		SetLastErrorMsg(IDC_UACTEST_FILE, hResult);
	}

	// Registryzugriff pruefen
	hResult = pUacWorker->CheckRegistryAccess();
	if (SUCCEEDED(hResult))
	{
		SetDlgItemText(IDC_UACTEST_REGISTRY, _T("Erfolg"));
	}

	// Fehler
	else
	{
		SetLastErrorMsg(IDC_UACTEST_REGISTRY, hResult);
	}

	// Schaltflaeche deaktivieren
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_UACTEST_ELEVATE), FALSE);
}

// Elevation-Status ermitteln
void CUacTestDlg::CheckElevation()
{
	// Prozesstoken oeffnen
	HANDLE hToken = NULL;
	if (OpenProcessToken(GetCurrentProcess(), TOKEN_QUERY, &hToken))
	{
		// Tokeninfo abrufen
		TOKEN_ELEVATION_TYPE eTokenElevation; DWORD dwReturnLength = 0;
		if (GetTokenInformation(hToken, (TOKEN_INFORMATION_CLASS) TokenElevationType, &eTokenElevation, sizeof(eTokenElevation), &dwReturnLength))
		{
			// Entsprechend des Typs...
			switch (eTokenElevation)
			{
				// Normaler Benutzer oder UAC deaktiviert
				case TokenElevationTypeDefault:

					SetDlgItemText(IDC_UACTEST_ELEVATION, _T("Einfacher Benutzer bzw. UAC ist deaktiviert"));
					break;

				// Volle Adminrechte
				case TokenElevationTypeFull:

					SetDlgItemText(IDC_UACTEST_ELEVATION, _T("Administrator"));
					break;

				// Limitierter Account
				case TokenElevationTypeLimited:

					SetDlgItemText(IDC_UACTEST_ELEVATION, _T("Eingeschrnkter Administrator"));
					break;
			}

			// Keine Erhoehung moeglich
			if (TokenElevationTypeFull == eTokenElevation)
			{
				::EnableWindow(::GetDlgItem(m_hWnd, IDC_UACTEST_ELEVATE), FALSE);
			}
		}

		// Fehler oder aelteres System
		else
		{
			SetLastErrorMsg(IDC_UACTEST_ELEVATION, GetLastError());
		}

		// Handle schliessen
		CloseHandle(hToken);
	}

	// Fehler
	else
	{
		SetLastErrorMsg(IDC_UACTEST_ELEVATION, GetLastError());
	}
}

// Schreibzugriff auf Windows-Verzeichnis
void CUacTestDlg::CheckFileAccess()
{
	// Windows-Verzeichnis ermitteln
	TCHAR szFileName[MAX_PATH]; GetWindowsDirectory(szFileName, MAX_PATH);
	PathAppend(szFileName, _T("setuperr.log"));

	// Datei mit Schreibzugriff oeffnen
	HANDLE hFile = CreateFile(szFileName, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, 0, NULL);
	if (INVALID_HANDLE_VALUE != hFile)
	{
		// Hinweis
		SetDlgItemText(IDC_UACTEST_FILE, _T("Erfolg"));

		// Handle schliessen
		CloseHandle(hFile);
	}

	// Fehler
	else
	{
		SetLastErrorMsg(IDC_UACTEST_FILE, GetLastError());
	}
}

// Schreibzugriff auf Registry
void CUacTestDlg::CheckRegistryAccess()
{
	//
	HKEY hKey = NULL;

	// Schluessel fuer Schreibzugriff oeffnen
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software"), 0, KEY_WRITE, &hKey))
	{
		// Hinweis
		SetDlgItemText(IDC_UACTEST_REGISTRY, _T("Erfolg"));

		// Handle schliessen
		RegCloseKey(hKey);
	}

	// Fehler
	else
	{
		SetLastErrorMsg(IDC_UACTEST_REGISTRY, GetLastError());
	}
}

// Fehlermeldung setzen
void CUacTestDlg::SetLastErrorMsg(UINT nDlgItem, DWORD dwLastError)
{
	// Fehlermeldung ermitteln
	TCHAR szLastError[260];
	FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwLastError, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), szLastError, countof(szLastError), NULL);

	// Fehler formatieren
	TCHAR szError[260]; 
	StringCchPrintf(szError, countof(szError), _T("Fehler: 0x%.8x - %s"), dwLastError, szLastError);

	// Hinweis
	SetDlgItemText(nDlgItem, szError);
}


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CUacTestDlg

