/*	Projekt UacHelper
	SpeedProject
	Copyright  1995 - 2006. Alle Rechte vorbehalten.

	Datei:		UacWorker.cpp
	Autor:		Sven Ritter
	Datum:		09.11.2006 - 11:14:46


	UEBERBLICK
	==========
	Quelltextdatei fuer die Implementation von CUacWorker	(IUacWorker).
*/


#include "StdAfx.h"

//
#include "UacHelper.h"
#include "UacWorker.h"


// ****************************************************************************
// ******                    Implementation zu CUacWorker                ******
// ****************************************************************************
CUacWorker::CUacWorker()
{
}

// Elevation-Status ermitteln
STDMETHODIMP CUacWorker::CheckElevation(UINT *pElevationType)
{
	// Prozesstoken oeffnen
	HANDLE hToken = NULL;
	if (OpenProcessToken(GetCurrentProcess(), TOKEN_QUERY, &hToken))
	{
		// Tokeninfo abrufen
		TOKEN_ELEVATION_TYPE eTokenElevation; DWORD dwReturnLength = 0;
		if (GetTokenInformation(hToken, (TOKEN_INFORMATION_CLASS) TokenElevationType, &eTokenElevation, sizeof(eTokenElevation), &dwReturnLength))
		{
			// Tokeninfo speichern
			*pElevationType = eTokenElevation;

			// Handle schliessen
			CloseHandle(hToken);

			// Alles Ok
			return S_OK;
		}

		// Aufgetretener Fehler
		HRESULT hResult = HRESULT_FROM_WIN32(GetLastError());

		// Handle schliessen
		CloseHandle(hToken);

		// Fehler
		return HRESULT_FROM_WIN32(hResult);
	}

	// Fehler
	return HRESULT_FROM_WIN32(GetLastError());
}

// Schreibzugriff auf Windows-Verzeichnis
STDMETHODIMP CUacWorker::CheckFileAccess()
{
	// Windows-Verzeichnis ermitteln
	TCHAR szFileName[MAX_PATH]; GetWindowsDirectory(szFileName, MAX_PATH);
	PathAppend(szFileName, _T("setuperr.log"));

	// Datei mit Schreibzugriff oeffnen
	HANDLE hFile = CreateFile(szFileName, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, 0, NULL);
	if (INVALID_HANDLE_VALUE != hFile)
	{
		// Handle schliessen
		CloseHandle(hFile);

		// Alles ok
		return S_OK;
	}

	// Fehler
	return HRESULT_FROM_WIN32(GetLastError());
}

// Schreibzugriff auf Registry
STDMETHODIMP CUacWorker::CheckRegistryAccess()
{
	// Schluessel
	HKEY hKey = NULL;

	// Schluessel fuer Schreibzugriff oeffnen
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software"), 0, KEY_WRITE, &hKey))
	{
		// Handle schliessen
		RegCloseKey(hKey);

		// Alles ok
		return S_OK;
	}

	// Fehler
	return HRESULT_FROM_WIN32(GetLastError());
}

/////////////////////////////////////////////////////////////////////////////
// CUacWorker


