import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.Invocable;
import javax.script.Bindings;
import java.text.DateFormat;

/**
 * @author Michael Tamm
 */
public class JavaScriptDemo {
	public static void main(String... args) throws Exception {
		ScriptEngineManager factory = new ScriptEngineManager();
		ScriptEngine engine = factory.getEngineByExtension("js");
		// Einfaches Skript ausfhren mit Zugriff auf Java-Objekt ...
		engine.put("name", "Michael");
		engine.eval("println('Hallo ' + name)");
		// Benutzung eines expliziten Bindings und der impliziten Variable java ...
		DateFormat df = DateFormat.getTimeInstance();
		Bindings bindings = engine.createBindings();
		bindings.put("df", df);
		engine.eval("var now = new java.util.Date();" +
			"println('Es ist ' + df.format(now)) + ' Uhr.'", bindings);
		// Aufruf einer JavaScript-Funktion ...
		String script = "function calc(x,y) { return x + y; }";
		engine.eval(script);
		Object result = ((Invocable) engine).invokeFunction("calc", 1, 1.5);
		System.out.println("calc(1, 1.5): " + result);
	}
}
