/* $Id: timer.h 1211 2006-10-16 16:06:27Z olau $ */

/* Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>,
                      Heise Zeitschriften Verlag.
   Alle Rechte vorbehalten.
*/


#ifndef __TIMER_H_
#define __TIMER_H_


#define T_RESULT_RESOLUTION       (1000000ULL /* microseconds */)

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
#include <windows.h>
typedef LARGE_INTEGER TIMER;
extern LONGLONG tickFreq;

#define startTimer(t) QueryPerformanceCounter(t)

#else

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#ifdef __GNUC__
#include <sys/time.h>
#endif

typedef struct timeval TIMER;
typedef long long LONGLONG;
typedef unsigned long long ULONGLONG;

extern struct timezone tz;

extern LONGLONG tv2l(TIMER *);
extern void     startTimer(TIMER *t);

#endif /* WIN32 */

extern LONGLONG stopTimer(TIMER *);
extern TIMER _stopwatch;

/* get timer resolution in microseconds */
extern LONGLONG getTimerResolution(void);

#define START()           startTimer(&_stopwatch)
#define STOP(result)      result = stopTimer(&_stopwatch)


#ifdef __cplusplus
}
#endif

#endif /* __TIMER_H_ */
