Imports System.Windows.Forms

<ComClass(DialogFunktionen.ClassId, DialogFunktionen.InterfaceId, DialogFunktionen.EventsId)> _
Public Class DialogFunktionen

#Region "COM GUIDs"
    ' These  GUIDs provide the COM identity for this class 
    ' and its COM interfaces. If you change them, existing 
    ' clients will no longer be able to access the class.
    Public Const ClassId As String = "e38f9ee6-bae7-47b4-b0a2-479ad93fa90a"
    Public Const InterfaceId As String = "2b8e51da-1a53-4123-a177-f94d0a7bae5b"
    Public Const EventsId As String = "d00ca394-c098-4f05-972a-2ca05badb4fe"
#End Region

    'Standard-Konstruktor fr COM-Klasse
    Public Sub New()
        MyBase.New()
    End Sub

    '**************************************************************
    'Windows-Standarddialoge
    '**************************************************************

    Public Function OrdnerWhlen(Optional ByVal Meldetext As String = "Bitte whlen Sie einen Ordner:", Optional ByVal GewhlterOrdner As String = "") As String
        Dim dlgFolderBrowser As New FolderBrowserDialog
        Dim strPfad As String = ""

        'Ordner-whlen-Dialog konfigurieren
        With dlgFolderBrowser
            'Button "Neuer Ordner" anzeigen
            .ShowNewFolderButton = True
            'Desktop als Root-Folder verwenden
            .RootFolder = Environment.SpecialFolder.Desktop

            'Pfad vorwhlen
            .SelectedPath = GewhlterOrdner
            'Prompt-Text definieren
            .Description = Meldetext
            'Wenn Dialog mit OK-Button beendet, dann...
            If .ShowDialog() = DialogResult.OK Then
                '... gewhlten Pfad bernehmen
                strPfad = .SelectedPath.ToString
            End If
        End With

        'Gewhlten Pfad zurckgeben
        Return strPfad
    End Function

    Public Function Dateiffnen(ByVal GewhlterOrdner As String, ByVal Filter As String, Optional ByVal AktiverFilter As Integer = 1) As String
        Dim dlgOpenFileDialog As New OpenFileDialog
        Dim strPfadname As String = ""

        'Datei-ffnen-Dialog konfigurieren
        With dlgOpenFileDialog
            'Startordner bergeben
            .InitialDirectory = GewhlterOrdner
            'Dateifilter bergeben
            .Filter = Filter
            'Filterindex bergeben
            .FilterIndex = AktiverFilter
            'Zuletzt gewhlten Ordner eingestellt lassen
            .RestoreDirectory = True

            'Dialog anzeigen. Wenn dieser mit OK beendet wurde, dann...
            If .ShowDialog() = DialogResult.OK Then
                '... gewhlten Pfadnamen bernehmen
                strPfadname = .FileName
            End If
        End With

        'Gewhlten Pfadnamen zurckgeben
        Return strPfadname
    End Function

    Public Function DateiSpeichern(ByVal GewhlterOrdner As String, ByVal Dateiname As String, ByVal Filter As String, Optional ByVal AktiverFilter As Integer = 1) As String
        Dim dlgSaveFileDialog As New SaveFileDialog
        Dim strPfadname As String = ""

        'Datei-speichern-Dialog konfigurieren
        With dlgSaveFileDialog
            'Startordner bergeben
            .InitialDirectory = GewhlterOrdner
            'Vorschlag fr Dateinamen bergeben
            .FileName = Dateiname
            'Dateifilter bergeben
            .Filter = Filter
            'Filterindex bergeben
            .FilterIndex = AktiverFilter
            'Wenn Datei schon besteht, dann Erlaubnis zum berschreiben anfordern
            .OverwritePrompt = True
            'Erweiterung notfalls ergnzen
            .AddExtension = True

            'Dialog anzeigen. Wenn dieser mit OK beendet wurde, dann...
            If .ShowDialog() = DialogResult.OK Then
                '... gewhlten Pfadnamen bernehmen
                strPfadname = .FileName
            End If
        End With

        'Gewhlten Pfadnamen zurckgeben
        Return strPfadname
    End Function

End Class


