/* $Id: main.cpp 1145 2006-09-08 14:03:02Z olau $ */

/* Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag */

#include <iostream>
#include <climits>

#include "tbb/task_scheduler_init.h"
#include "tbb/blocked_range.h"
#include "tbb/parallel_for.h"
#include "tbb/parallel_reduce.h"
#include "tbb/parallel_while.h"
#include "tbb/pipeline.h"

#include "../tbb_demos.h"
#include "Printer.h"
#include "Summarizer.h"
#include "Printer2.h"


int main(int argc, char *argv[])
{
  int numThreads = getNumTBBThreads();
  cout << "#threads: ";
  if (numThreads == task_scheduler_init::automatic)
    cout << "automatisch" << endl;
  else
    cout << numThreads << endl;

  task_scheduler_init init(numThreads);

  cout << endl;

  // Array anlegen und fllen
  int v[] = {0,1,2,3,4,5,6,7,8,9};
  int vl =sizeof(v)/sizeof v[0];
  //Funktional-Objekt der Klasse Printer erzeugen
  Printer whattodo (v);
  // Array ausgeben
  cout <<"Array-Elemente via Threads ausgeben (i.A. in zufaelliger Reihenfolge):" <<endl; 
  parallel_for(blocked_range<size_t>(0, vl, 3), whattodo);
  cout << endl;

  // Array-Elemente aufsummieren
  Summarizer s(v);
  parallel_reduce(blocked_range<size_t>(0, vl ,3 ), s);
  cout << "Summe: " << s.sum() << endl;
  cout << "Minimum: " << s.minimum() << endl;
  cout << "Maximum: " << s.maximum() << endl;

  cout << endl;

  // verkettete Liste erzeugen
  Item *root = new Item(0);
  root->append(1);
  root->append(2);
  root->append(3);
  root->append(4);
  root->append(5);
  root->append(6);
  root->append(7);
  root->append(8);
  root->append(9);

  // Liste ausgeben
  cout <<"Listenelemente via Threads ausgeben (i.A. in zufaelliger Reihenfolge):" <<endl; 
  parallel_while<Printer2> w;
  ItemStream stream(root);
  Printer2 printer;
  w.run(stream, printer);

  cout << endl;
  return 0;
}
