/* $Id: Summarizer.h 1135 2006-09-06 07:53:02Z olau $ */

/* Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag */

#ifndef __SUMMARIZER_H_
#define __SUMMARIZER_H_

#include <climits>
#include <vector>

#include "tbb/blocked_range.h"

#include "../tbb_demos.h"

class Summarizer {
  int * const m_v;
  int m_sum, m_max, m_min;
public:
  Summarizer(int v[]) :  m_v(v), m_sum(0), m_max(INT_MIN), m_min(INT_MAX) {}
  void operator() (const blocked_range<size_t>& r)
  {
    for (size_t i = r.begin(); i != r.end(); ++i) {
      m_sum += m_v[i];
      m_max = max(m_v[i], m_max);
      m_min = min(m_v[i], m_min);
    }
  }
  Summarizer(Summarizer& x, split) : m_v(x.m_v), m_sum(0), m_max(INT_MIN), m_min(INT_MAX) {}
  void join(const Summarizer& other)
  {
    m_sum += other.m_sum;
    m_max = max(other.m_max, m_max);
    m_min = min(other.m_min, m_min);
  }
  int sum(void)
  {
    return m_sum;
  }
  int maximum(void)
  {
    return m_max;
  }
  int minimum(void)
  {
    return m_min;
  }
};


#endif /* __SUMMARIZER_H_ */
