/* $Id: Printer2.h 1137 2006-09-06 12:54:57Z olau $ */

/* Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag */

#ifndef __PRINTER2_H_
#define __PRINTER2_H_

#include <iostream>

#include "../tbb_demos.h"

using namespace std;
using namespace tbb;

class Item {
  Item *m_next;
  int m_data;
public:
  Item(void) : m_data(0), m_next(NULL) { }
  Item(int data) : m_data(data), m_next(NULL) { }
  void append(int data) {
    Item *new_item = new Item(data);
    Item *next_item = this->m_next;
    if (next_item == NULL) {
      this->m_next = new_item;
    }
    else {
      while (next_item->m_next != NULL)
        next_item = next_item->m_next; 
      next_item->m_next = new_item;
    }
  }
  inline int data(void) { return m_data; }
  inline Item *next() { return m_next; }
};


class ItemStream {
  Item* m_ptr;
public:
  ItemStream(Item *root) :  m_ptr(root) {}
  bool pop_if_present(Item*& item)
  {
    bool result = m_ptr != NULL;
    if (result) {
      item = m_ptr;
      m_ptr = m_ptr->next();
    }
    return result;
  }
};


class Printer2 {
public:
  typedef Item* argument_type;
  inline void operator() (Item *item) const
  {
    std::cout << item->data();
  }
};


#endif /* __PRINTER2_H_ */
