/* $Id: main.cpp 1142 2006-09-07 16:18:57Z olau $ */

#include <vector>
#include <queue>

#include "tbb/concurrent_hash_map.h"
#include "tbb/concurrent_vector.h"
#include "tbb/concurrent_queue.h"
#include "tbb/blocked_range.h"
#include "tbb/parallel_for.h"
#include "tbb/tick_count.h"
#include "tbb/task_scheduler_init.h"

#include <string>
#include <cctype>
#include <iostream>
#include <cstdio>

using namespace tbb;
using namespace std;


class ELFHashCompare {
public:
  static size_t hash(const char *s) {
    size_t h = 0, g;
    while (*s) {
      h = (h << 4) + *s++;
      if (g = h & 0xf0000000)
        h ^= g >> 24;
      h &= ~g;
    }
    return h;
  }
  static bool equal(const char *x, const char *y) {
    return strcmp(x, y) == 0;
  }
};

typedef concurrent_hash_map<char *, int, ELFHashCompare> StringTable;
typedef concurrent_vector<int> IntVector;
typedef concurrent_queue<double> DoubleQueue;

int main(int argc, char *argv[])
{
  IntVector v;
    
  StringTable tab;
 
  StringTable::accessor a;
  StringTable::const_accessor ca;

  tab.insert(a, "Index eins");
  a->second = 31337;
  cout << " " << a->first << endl;

  if (tab.find(a, "Index eins"))
    cout << "\"Index eins\" gefunden" << endl;
  else
    cout << "\"Index eins\" nicht gefunden" << endl;

  tab.erase("Index eins");
  cout << "\"Index eins\" entfernt" << endl;

  if (tab.find(a, "Index eins"))
    cout << "\"Index eins\" gefunden" << endl;
  else
    cout << "\"Index eins\" nicht gefunden" << endl;


  tab.insert(a, "Index zwei");
  a->second = 42;
  cout << " " << a->first << endl;

  return 0;
}

