// GenerischerStack.cpp : main project file.

// Generische Typen in C++/CLI
#include "stdafx.h"

using namespace System;


generic <typename ItemType>
ref struct Stack {
public:	
    ref struct Item { // Elementtyp
        Item(ItemType _item, Item ^_prev){
            item = _item; 
            prev = _prev;
        }
        ItemType item; 
        Item ^prev; 
    };
private:
    Item ^top;  // zeigt anfangs auf nullptr
public:
    void push(ItemType item) {
        top = gcnew Item(item, top); 
    }
    ItemType pop(){ 
        ItemType item = top->item; 
        top = top->prev; 
        return item;
    } 
    bool IsEmpty(){
        return top == nullptr;
    } 
};


int main() {
    Stack<String ^> ^s0 = gcnew Stack<String ^>; // auf verwaltetem Heap
    s0->push("C++/CLI"); 
    s0->push("Hallo"); 
    while(!s0->IsEmpty())
        Console::WriteLine(s0->pop()); 
    Console::WriteLine(); 

    Stack<Object ^> s1; 	                     // auf Stack 
    s1.push(1);  // automatisches boxing
    s1.push("nach der Zahl noch ein String"); 
    while(!s1.IsEmpty())
        Console::WriteLine(s1.pop()); 
    Console::ReadKey(); 
}
