#!/usr/bin/perl -w
#
# Demonstration einer Thread-Barriere.
#
# Copyright (C) 2006 Heise Zeitschriften Verlag, Oliver Lau <ola@ctmagazin.de>
# Alle Rechte vorbehalten.
#
# $Id: barrier.pl 967 2006-08-01 08:46:50Z olau $

use strict;
use threads;
use threads::shared;

my $NUM_THREADS = 8;

my $threadCounter : shared = 0;


sub worker {
    my $id = threads->self->tid;
    print "Thread $id geht auf die Schranke zu ...\n";
    {
    	lock($threadCounter);
	   	$threadCounter++;
		if ($threadCounter < $NUM_THREADS) {
			print "Thread $id wartet vor der Schranke ...\n";
			cond_wait($threadCounter);
		}
		else {
			print "Thread $id hebt Schranke ...\n";
			cond_broadcast($threadCounter);
		}
	}
	print "Thread $id ist durch die Schranke gegangen.\n";
}

my @threads;
for (my $i = 0; $i < $NUM_THREADS; $i++) {
	$threads[$i] = threads->create('thread');
}

print "$NUM_THREADS Threads starten ...\n";
my @thread;
for (my $i = 0; $i < $NUM_THREADS; $i++) {
	$thread[$i] = threads->new(\&worker);
}

print "... alle Threads laufen ...\n";

for (my $i = 0; $i < $NUM_THREADS; $i++) {
	$thread[$i]->join;
}
