#/* $Id: mutex.c 885 2006-07-09 16:20:31Z olau $ */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include "../helper.h"

#define MAX_THREADS        12
#define LOOPS         5000000

typedef struct _threadparam {
  int id;
} THREADPARAM;


typedef struct _tag_t {
  pthread_mutex_t mutex;
  volatile int value;
} tag_t;

tag_t data = { PTHREAD_MUTEX_INITIALIZER, 0 };



void *counter(void *params)
{
  int i;

  for (i = 0; i < LOOPS; ++i) {
    pthread_mutex_lock(&data.mutex);
    ++data.value;
    pthread_mutex_unlock(&data.mutex);
  }
  return NULL;
}



int main(int argc, char *argv[])
{
  pthread_t tid[MAX_THREADS];
  THREADPARAM param[MAX_THREADS];
  int i;
  int rc;

  printf("Starten von %d Threads ...\n", MAX_THREADS);
  /* Threads starten */
  for (i = 0; i < MAX_THREADS; ++i) {
    rc = pthread_create(&tid[i], NULL, counter, &param[i]);
    if (rc != 0)
      err_abort(rc, "pthread_create() fehlgeschlagen");
  }

  /* auf Beendigung der Threads warten */
  for (i = 0; i < MAX_THREADS; ++i) {
    rc = pthread_join(tid[i], NULL);
    if (rc != 0)
      err_abort(rc, "pthread_join() fehlgeschlagen");
  }

  printf("Ist: %d (Soll: %d)\n", data.value, MAX_THREADS * LOOPS);

  pthread_mutex_destroy(&data.mutex);
  return 0;
}
