/* $Id: barrier.c 910 2006-07-13 07:36:36Z olau $ */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include "../helper.h"


#define MAX_THREADS   3


typedef struct _threadparam {
  int id;
} THREADPARAM;


typedef struct _barrier_t {
  pthread_mutex_t mutex;
  pthread_cond_t  cond;
  int counter;
} barrier_t;

static barrier_t barrier =
  { PTHREAD_MUTEX_INITIALIZER, PTHREAD_COND_INITIALIZER, 0 };


void *aThread(void *params)
{
  int rc;
  int id = ((THREADPARAM *)params)->id;
  printf("Thread %2d geht auf die Schranke zu ...\n", id);

  /* Mutex sperren, um Zugriff auf Zhler zu schtzen */
  rc = pthread_mutex_lock(&barrier.mutex);
  if (rc != 0)
    err_abort(rc, "pthread_mutex_lock() fehlgeschlagen");

  /* durch Hochzhlen der globalen Variable signalisieren, 
     dass ein weiterer Thread gestartet wurde */
  ++barrier.counter;

  // sched_yield();

  if (barrier.counter < MAX_THREADS) {
    /* es sind noch nicht alle Threads an der Barriere angekommen,
       also warten ... */
    printf("Thread %2d wartet vor der Schranke ...\n", id);
    rc = pthread_cond_wait(&barrier.cond, &barrier.mutex);
    if (rc != 0)
      err_abort(rc, "pthread_cond_wait() fehlgeschlagen");
  }
  else {
    /* der als letzter an der Barriere angelangte Thread
       ffnet die Schranke */
    printf("Thread %2d hebt Schranke ...\n", id);
    rc = pthread_cond_broadcast(&barrier.cond);
    if (rc != 0)
      err_abort(rc, "pthread_cond_broadcast() fehlgeschlagen");
  }

  /* pthread_cond_wait() und pthread_cond_broadcast() kehren mit
     gesperrtem Mutex zurck, weshalb der Mutex hier entsperrt
     werden muss */
  pthread_mutex_unlock(&barrier.mutex);

  printf("Thread %2d ist durch die Schranke gegangen.\n", id);
  return NULL;
}


int main(int argc, char *argv[])
{
  pthread_t tid[MAX_THREADS];
  THREADPARAM param[MAX_THREADS];
  int i;
  int rc;

  /* Threads starten */
  for (i = 0; i < MAX_THREADS; ++i) {
    param[i].id = i + 1;
    rc = pthread_create(&tid[i], NULL, aThread, &param[i]);
    if (rc != 0)
      err_abort(rc, "pthread_create() fehlgeschlagen");
  }

  /* auf Beendigung der Threads warten */
  for (i = 0; i < MAX_THREADS; ++i) {
    rc = pthread_join(tid[i], NULL);
    if (rc != 0)
      err_abort(rc, "pthread_join() fehlgeschlagen");
  }

  pthread_cond_destroy(&barrier.cond);
  pthread_mutex_destroy(&barrier.mutex);

  printf("\n");
  return 0;
}
