/* $Id$ */

#include <stdio.h>
#include <pthread.h>
#include "../globaldefs.h"
#include "../helper.h"

#define DEFAULT_NUMTHREADS   10


typedef struct _threadparam
{
  CACHE_ALIGN int myrank;
} THREADPARAM;


void *samplethread(void *params)
{
  int myrank = ((THREADPARAM *) params)->myrank;
  printf("Thread %2d\n", myrank);
  return NULL;
}

int main(int argc, char *argv[])
{
  int i;
  int rc;
  pthread_t tid[DEFAULT_NUMTHREADS];
  THREADPARAM params[DEFAULT_NUMTHREADS];
  pthread_attr_t attr;

  pthread_attr_init(&attr);
  rc = pthread_attr_setscope(&attr, PTHREAD_SCOPE_SYSTEM);
  if (rc != 0)
    err_abort(rc, "pthread_attr_setscope() fehlgeschlagen");
  rc = pthread_attr_setschedpolicy(&attr, SCHED_OTHER);
  if (rc != 0)
    err_abort(rc, "pthread_attr_setschedpolicy() fehlgeschlagen");

  /* Achtung! Auf einen als 'detached' gestarteten Thread kann man nicht
     mit pthread_join() warten */ 
  rc = pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
  if (rc != 0)
    err_abort(rc, "pthread_attr_setdetachstate() fehlgeschlagen");

 /* Threads starten */
  for (i = 0; i < DEFAULT_NUMTHREADS; ++i) {
    params[i].myrank = i;
    rc = pthread_create(&tid[i], &attr, samplethread, &params[i]);
    if (rc != 0)
      err_abort(rc, "pthread_create() fehlgeschlagen");
  }

  /* damit die laufenden Threads nicht einfach beendet werden, wenn
     main() zum Aufrufer zurckkehrt, darf man main() nicht einfach
     mit return beenden, sondern muss pthread_exit() aufrufen */
  pthread_exit(NULL);

  return 0; /* wird nicht ausgefhrt; nur da, um Compiler zufriedenzustellen */
}
