/* $Id: openmp-timer.c 821 2006-06-09 13:39:21Z olau $ */

#include <stdio.h>
#ifdef _OPENMP
#include <omp.h>
#include "ompdefs.h"
#endif
#include "globaldefs.h"
#include "timer/timer.h"

#define NUM_MEASUREMENTS    10

int main(int argc, char *argv[])
{
  double t0, t1, dt, tbest;
  int i;

  printf("Auflsung der Systemuhr: %lld s\n",
    getTimerResolution()); 
  printf("Auflsung von omp_get_wtime():\n");
  tbest = 1e30;
  for (i = 1; i <= NUM_MEASUREMENTS; i++) {
    t0 = omp_get_wtime();
    do {
      t0 = omp_get_wtime();
      do {
        t1 = omp_get_wtime();
      }
      while (t1 == t0);
    }
    while (t1 < t0); /* nochmal, falls Timer "gestolpert" ist */
    dt = t1 - t0;
#ifdef DEBUG
    printf("Messung %3d: %.6lf s\n", i, 1e6 * dt);
#endif /* DEBUG */
    if (dt < tbest)
      tbest = dt;
  }
  printf("Bester Wert aus %d Messungen: %.6lf s (%.1lf MHz) \n\n",
    NUM_MEASUREMENTS, 1e6 * tbest, 1.0 / tbest / 1e6);
  return 0;
}
