<?php

/**
 * Wortschatz Client
 */
class WortschatzClient{
	private $login;
	private $password;
	
	private $webserviceResult;
	private $result;
	
	const BASE_URL = 'http://anonymous:anonymous@pcai055.informatik.uni-leipzig.de:8100/axis/services/';
	
	/**
	 * Der Konstruktor
	 * 
	 * @param string $login Falls bentigt der Username
	 * @param string $password Falls bentigt das Passwort
	 */
	function __construct($login=null, $password=null){
		$this->login = $login?$login:'anonymous';
		$this->password = $password?$password:'anonymous';
	}
	
	/**
	 * Gibt Synonyme zurck
	 * 
	 * @param string $corpus Der Corpus (de, en)
	 * @param string $wort Das gesuchte Wort
	 * @param string $limit Limitiert das Suchergebnis 
	 * 
	 * @return array Das Resultat
	 */
	public function getSynonyme($corpus, $wort, $limit = 10){
		$requestParameter = new RequestParameter($corpus);
		$dataMatrix = new DataMatrix();
		
		// Wort
		$dataVector = new DataVector();
		$dataVector->addDataRow('Wort');
		$dataVector->addDataRow($wort);
		$dataMatrix->addDataVector($dataVector);
		
		// Limit
		$dataVector = new DataVector();
		$dataVector->addDataRow('Limit');
		$dataVector->addDataRow($limit);
		$dataMatrix->addDataVector($dataVector);
		
		$requestParameter->addParameter($dataMatrix);
		try {
			$this->request('Synonyms', $requestParameter->getXML() );
			$this->processResult();
			return $this->result; 
			
		}  catch (SOAPFault $f) {
			throw $f;
		}
	}
	
	/**
	 * Verarbeitet die Rckgabe des Webservices
	 */
	private function processResult(){
		$this->result = array();
		if(!empty($this->webserviceResult->result->dataVectors)){
			foreach ($this->webserviceResult->result->dataVectors as $vector){
				$this->result[] = $vector->dataRow;
			}
		}
	}
	
	/**
	 * Gibt das Resultat zurck
	 * 
	 * @return array Das verarbeitete Resultat
	 */
	public function getResult(){
		return $this->result;
	}
	
	
	/**
	 * Der eigentliche Webservice Aufruf
	 * 
	 * @param string $service Der Name des Service
	 * @param string $xml Der Request als XML
	 */
	private function request($service, $xml){
		try {
			$client = new SoapClient(null, 
				array('location' => self::BASE_URL.$service,
					'uri'      	=> "http://datatypes.webservice.wortschatz.uni-leipzig.de",
					'login'		=> $this->login, 
					'password' 	=> $this->password
					) );
					
			$var =	new SoapVar($xml, XSD_ANYXML, 'RequestParameter', "http://datatypes.webservice.wortschatz.uni-leipzig.de", 'parameters');
			$this->webserviceResult = $client->execute(new SoapParam($var, 'objRequestParameters'));
		} catch (SOAPFault $f) {
			throw $f;
		}
	}
}

/**
 * 
 */
class RequestParameter {
	/**
	 * @var string Der Corpus
	 */
	public $corpus;
	/**
	 * @var DataMatrix[] Die DataMatrix 
	 */
	public $parameters;
	
	/**
	 * Konstruktor
	 * 
	 * @param string $corpus
	 */
	function __construct($corpus){
		$this->corpus = $corpus;
	}
	
	/**
	 * Fgt Parameter hinzu
	 * 
	 * @param DataMatrix $param Ein Parameter
	 */
	public function addParameter(DataMatrix $param){
		$this->parameters[] = $param;
	}
	
	/**
	 * 
	 */
	public function getXML(){
		$xml = '<objRequestParameters><corpus>'.$this->corpus.'</corpus>';
		foreach($this->parameters as $param){
			$xml .= '<parameters>'.$param->getXML().'</parameters>';
		}
		$xml .=	'</objRequestParameters>';
		return $xml;
	}
}

/**
 * DataMatrix
 */
class DataMatrix {
	/**
	 * @var DataVector[] DataVetor Array
	 */
	public $dataVectors;
	
	/**
	 * Fgt einen Data Vector hinzu
	 * 
	 * @param DataVector $vector
	 */
	public function addDataVector(DataVector $vector){
		$this->dataVectors[] = $vector;
	}
	
	/**
	 * 
	 */
	public function getXML(){
		$xml = '';
		foreach($this->dataVectors as $vector){
			$xml .= '<dataVectors>'.$vector->getXML().'</dataVectors>';
		}
		return $xml;
	}	
}

/**
 * DataVector
 */
class DataVector {
	/**
	 * @var string[] Ein DataRow Array
	 */
	public $dataRow;
	
	/**
	 * Fgt eine DataRow hinzu
	 * 
	 * @param string $row DataRow
	 */
	public function addDataRow($row){
		$this->dataRow[] = $row; 
	}
	
	/**
	 * 
	 */
	public function getXML(){
		$xml = '';
		foreach($this->dataRow as $row){
			$xml .= '<dataRow>'.$row.'</dataRow>';
		}
		return $xml;
	}
}



?>
