/*
 * Created on 05.02.2006
 */
package hibernate.ct.beispiele;

import hibernate.ct.Angestellter;
import hibernate.ct.FreierMitarbeiter;
import hibernate.ct.Mitarbeiter;

import java.util.Iterator;

import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;

public class Beispiel_Vererbung {

	public static void main(String[] args) throws Exception {
		Configuration configuration = new net.sf.hibernate.cfg.Configuration();
		configuration.addFile("Mapping.hbm.xml");
		SessionFactory factory = configuration.buildSessionFactory();
		Session session = factory.openSession();
		try {
			// Speichern von 2 Beispielmitarbeitern (je einer als FreierMitarbeiter bzw. Angestellter
			FreierMitarbeiter freierMitarbeiter = new FreierMitarbeiter(
					"Mller", "Manfred");
			freierMitarbeiter.setStundensatz(Integer.valueOf(100));
			session.save(freierMitarbeiter);

			Angestellter angestellter = new Angestellter("Meier", "Michael");
			angestellter.setGehalt(Integer.valueOf(5000));
			session.save(angestellter);

			// Abfrage und Ausgabe aller Mitarbeiter (also beide)
			for (Iterator iter = session.find("from Mitarbeiter").iterator(); iter
					.hasNext();) {
				Mitarbeiter m = (Mitarbeiter) iter.next();
				System.out.println("Mitarbeiter: " + m.getNachname() + ", "
						+ m.getVorname());
			}

			// Abfrage und Ausgabe aller Angestllten (also nur Michael Meier)
			for (Iterator iter = session.find("from Angestellter").iterator(); iter
					.hasNext();) {
				Angestellter a = (Angestellter) iter.next();
				System.out.println("Angestellter: " + a.getNachname() + ", "
						+ a.getVorname());
			}

		} finally {
			session.close();
			factory.close();
		}
	}
}
