package hibernate.ct.beispiele;

import hibernate.ct.Angestellter;
import hibernate.ct.FreierMitarbeiter;
import hibernate.ct.Mitarbeiter;

import java.util.Iterator;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Example;

public class Beispiel_QBE {

	public static void main(String[] args) throws Exception {
		Configuration configuration = new net.sf.hibernate.cfg.Configuration();
		configuration.addFile("Mapping.hbm.xml");
		SessionFactory factory = configuration.buildSessionFactory();
		Session session = factory.openSession();
		try {

			session.save(new FreierMitarbeiter("Mller", "Manfred"));
			session.save(new Angestellter("Meier", "Michael"));
			
			// Criteria liefert zu nchst alle Objecte der Klasse Mitarbeiter 
			Criteria criteria = session.createCriteria(Mitarbeiter.class);

			// Ein Mitarbeiter wird als Beispiel erzeugt und mit Daten gefllt...
			Mitarbeiter beispielMitarbeiter = new Mitarbeiter();
			beispielMitarbeiter.setVorname("Michael");
			
			// und daraus ein Criterion erzeugt
			criteria.add(Example.create(beispielMitarbeiter));
			
			// Abfrage und Ausgabe
			for (Iterator iter = criteria.list().iterator(); iter.hasNext();) {
				Mitarbeiter m = (Mitarbeiter) iter.next();
				System.out.println("Mitarbeiter: " + m.getNachname() + ", "
						+ m.getVorname());
			}

		} finally {
			session.close();
			factory.close();
		}
	}
}
