package hibernate.ct;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;

/** @author Hibernate CodeGenerator */
public class Mitarbeiter implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** identifier field */
	private long id;

	/** nullable persistent field */
	private String nachname;

	/** nullable persistent field */
	private String vorname;

	/** nullable persistent field */
	private Date geburtsdatum;

	/** persistent field */
	private Set projektbeteiligungen;

	/** full constructor */
	public Mitarbeiter(String nachname, String vorname, Date geburtsdatum,
			Set projektbeteiligungen) {
		this.nachname = nachname;
		this.vorname = vorname;
		this.geburtsdatum = geburtsdatum;
		this.projektbeteiligungen = projektbeteiligungen;
	}

	/** default constructor */
	public Mitarbeiter() {
	}

	/** minimal constructor */
	public Mitarbeiter(Set projektbeteiligungen) {
		this.projektbeteiligungen = projektbeteiligungen;
	}

	public Mitarbeiter(String nachname, String vorname) {
		setNachname(nachname);
		setVorname(vorname);
	}

	public long getId() {
		return this.id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getNachname() {
		return this.nachname;
	}

	public void setNachname(String nachname) {
		this.nachname = nachname;
	}

	public String getVorname() {
		return this.vorname;
	}

	public void setVorname(String vorname) {
		this.vorname = vorname;
	}

	public Date getGeburtsdatum() {
		return this.geburtsdatum;
	}

	public void setGeburtsdatum(Date geburtsdatum) {
		this.geburtsdatum = geburtsdatum;
	}

	public Set getProjektbeteiligungen() {
		return this.projektbeteiligungen;
	}

	public void setProjektbeteiligungen(Set projektbeteiligungen) {
		this.projektbeteiligungen = projektbeteiligungen;
	}

	public String toString() {
		return new ToStringBuilder(this).append("id", getId()).toString();
	}

}
