#include <QtTest/QtTest>
#include "exchangewidget.h"
#include <QDateEdit>
#include <QLineEdit>
#include <QLabel>

class TestExchangeWidget : public QObject
{
    Q_OBJECT

private slots:
    void initializeTestCase()
        {
            mExchangeWidget = new ExchangeWidget;
        }

    void cleanupTestCase()
        {
            delete mExchangeWidget;
        }


    void testComputation()
        {
            mExchangeWidget->reset();
            QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Up );
            QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Tab );
            QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Tab );
            for( int i = 0; i < 6; i++ )
                QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Up );
            QTest::keyClicks( mExchangeWidget->currencyEdit(), QString::fromLatin1( "SEK" ) );
            QCOMPARE( mExchangeWidget->rateField()->text(), QString::fromLatin1( "9.3977" ) );
        }

    void testSignal()
        {
            mExchangeWidget->reset();
            QSignalSpy spy( mExchangeWidget, SIGNAL( rateChanged( double ) ) );
            QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Up );
            QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Tab );
            QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Tab );
            for( int i = 0; i < 6; i++ )
                QTest::keyClick( mExchangeWidget->dateEdit(), Qt::Key_Up );
            QTest::keyClicks( mExchangeWidget->currencyEdit(), QString::fromLatin1( "SEK" ) );
            QCOMPARE( mExchangeWidget->rateField()->text(), QString::fromLatin1( "9.3977" ) );

            QCOMPARE( spy.count(), 1 );
            if( spy.count() > 0 )
                QCOMPARE( spy[0][0].toString(), QString::fromLatin1( "9.3977" ) );
        }

private:
    ExchangeWidget* mExchangeWidget;
};


QTEST_MAIN(TestExchangeWidget);

#include "main.moc"


