package pdf;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.util.UrlToFileMapper;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;


public class Utilities{
    
    XMultiComponentFactory mxMultiComponentFactory = null;
    XComponentContext mxComponentContext = null;

    
    public Utilities(XComponentContext _xComponentContext, XMultiComponentFactory _xMultiComponentFactory){
        mxComponentContext = _xComponentContext;
        mxMultiComponentFactory = _xMultiComponentFactory;        
    }
    
    protected static PropertyValue createPropertyValue(String name, Object value) {
        PropertyValue pv = new PropertyValue();
        pv.Name = name;
        pv.Value = value;
        return pv;
    }

    
   protected static NamedValue createNamedValue(String _sName, String _sValue) {
        NamedValue aNamedValue = new NamedValue();
        aNamedValue.Name = _sName;
        aNamedValue.Value = _sValue;
        return aNamedValue;
    }
   
   
    public static int FieldInList(String[] SearchList, String SearchString) {
        int FieldLen = SearchList.length;
        int retvalue = -1;
        for (int i = 0; i < FieldLen; i++) {
            if (SearchList[i].compareTo(SearchString) == 0) {
                retvalue = i;
                break;
            }
        }
        return retvalue;
    }    
    
    public static String convertfromURLNotation(String _sURLPath) {
	String sPath = "";
	try {
        URL oJavaURL = new URL(_sURLPath);
        File oFile = UrlToFileMapper.mapUrlToFile(oJavaURL);
        sPath = oFile.getAbsolutePath();
	} catch (MalformedURLException e) {
		e.printStackTrace(System.out);
	} catch (IOException e) {
		e.printStackTrace(System.out);
	}
	return sPath;
    }

    
/*    public static String convertfromURLNotation(String _sURLPath) {
	String sPath = "";
//	try {
			File oFile = new File(_sURLPath);
			sPath = oFile.getAbsolutePath();
//            URL oJavaURL = new URL(oFile.getAbsolutePath());
//            sPath = UrlToFileMapper.mapUrlToFile(oJavaURL);
//            sPath = oFile.getAbsolutePath();
//	} catch (MalformedURLException e) {
//		e.printStackTrace(System.out);
//	} catch (IOException e) {
//		e.printStackTrace(System.out);
//	}
	return sPath;
    }
*/
    
    public String getOfficePath(String sPath) {
    try {
        Object oPathSettings = this.mxMultiComponentFactory.createInstanceWithContext("com.sun.star.util.PathSettings", this.mxComponentContext);
        XPropertySet xPathPropertySet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, oPathSettings);
        String ResultPath = AnyConverter.toString(xPathPropertySet.getPropertyValue(sPath));
        return ResultPath;
    } catch (Exception exception) {
        exception.printStackTrace(System.out);
        return "";
    }}
    

    public static String getFileName(String _sPath) {
        String[] s = _sPath.split("/");
        return s[s.length - 1];
    }

    public static String getBaseFileName(String _sPath) {
        String sFileName = getFileName(_sPath);
        String sBaseFileName = sFileName;
        String sExtension = getFileExtension(sFileName);
        if (sExtension.length() > 0){
            sBaseFileName = sFileName.substring(0, sFileName.length()-(sExtension.length()+1));
        }
        return sBaseFileName;
    }
    
    public static String getFileExtension(String _sFilePath){
        String sExtension = "";
        String[] sStringFragments = _sFilePath.split("\\.");
        int nLength = sStringFragments.length;
        if (nLength > 1){
            sExtension = sStringFragments[sStringFragments.length-1];
        }
        return sExtension;
    }   
    
    public static int getFieldInList(String[] SearchList, String SearchString){
        int FieldLen = SearchList.length;
        int retvalue = -1;
        for (int i = 0; i < FieldLen; i++){
            if (SearchList[i].compareTo(SearchString) == 0){
                retvalue = i;
                break;
            }
        }
        return retvalue;
    }

    public static boolean isPathValid(Component _parentComponent, String _sSystemPath){
        java.io.File sSourceFile = new java.io.File(_sSystemPath);
        if ((!sSourceFile.exists()) || (!sSourceFile.isDirectory())){
            JOptionPane.showMessageDialog(_parentComponent, "Das Verzeichnis '" + _sSystemPath + "' ist nicht vorhanden!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        else{
            return true;
        }
    }
    
}
