/*
 * Created on 21.02.2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package pdf;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XContainerQuery;
import com.sun.star.container.XEnumeration;
import com.sun.star.frame.XModuleManager;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.task.PasswordRequestMode;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.RuntimeException;


/**
 * @author bc93774
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ConversionThread extends Thread
{
	private JProgressBar mjPrgConvert;
	private String[] msDocumentList;
	private PDFDialog moPDFDialog;
        PropertyValue[] aOpenProperties = null;
        PropertyValue[] aPDFFilterData = null;
        String msTargetFolder;

	ConversionThread (PDFDialog _oPDFDialog2, final JProgressBar aBar, String[] sDocumentList, String _sTargetFolder){
            mjPrgConvert = aBar;
            msDocumentList = sDocumentList;
            moPDFDialog = _oPDFDialog2;
            msTargetFolder = _sTargetFolder;
            if (_sTargetFolder.endsWith("/")){
                msTargetFolder = _sTargetFolder.substring(0,_sTargetFolder.length()-1);
            }
            else{
                msTargetFolder = _sTargetFolder;
            }
	}
	
	public void run ()	{
	try {
            aPDFFilterData = moPDFDialog.getPDFFilterData();
            JLabel oCurrentDocumentLabel = moPDFDialog.getCurrentDocumentLabel();
            String sBaseText = oCurrentDocumentLabel.getText();
            for (int i = 0; i < msDocumentList.length; i++){
                mjPrgConvert.setValue(i+1);
                mjPrgConvert.setString("Dokument " + (i+1) + "/" + msDocumentList.length);
                String sTargetFilePath = msTargetFolder + "/" + Utilities.getBaseFileName(msDocumentList[i]) + ".pdf";
                oCurrentDocumentLabel.setText(sBaseText + Utilities.convertfromURLNotation(sTargetFilePath));
                mjPrgConvert.setStringPainted(true);
                mjPrgConvert.paintImmediately(mjPrgConvert.getBounds());
                XComponent xComponent = loadDocument(msDocumentList[i]);
                storeAsPDFDocument(xComponent, sTargetFilePath);
                xComponent.dispose();
            }
		
	} catch (RuntimeException e) {
        JOptionPane.showMessageDialog(moPDFDialog, "Beim Export ist ein Fehler aufgetreten!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);		
	e.printStackTrace(System.out);
	}
        moPDFDialog.getConvertButton().setText("Fertig");	
        moPDFDialog.getConvertButton().setEnabled(true);
        
	}
		
	    
    protected XComponent loadDocument(String _sSourceUrl){
    try{
        PasswordRequestMode[] nInteractionTypes = new PasswordRequestMode[1];
        nInteractionTypes[0] = PasswordRequestMode.PASSWORD_REENTER;
        Object oInteractionHandler = moPDFDialog.mxMultiComponentFactory.createInstanceWithContext("com.sun.star.task.InteractionHandler", moPDFDialog.mxComponentContext);
        XInitialization xInitInteractionHandler = (XInitialization) UnoRuntime.queryInterface(XInitialization.class, oInteractionHandler);
        xInitInteractionHandler.initialize(nInteractionTypes);
        aOpenProperties = new PropertyValue[5];
        aOpenProperties[0] = Utilities.createPropertyValue("Hidden", Boolean.TRUE);
        aOpenProperties[1] = Utilities.createPropertyValue("AsTemplate", Boolean.FALSE);
        aOpenProperties[2] = Utilities.createPropertyValue("MacroExecutionMode", new Short(com.sun.star.document.MacroExecMode.NEVER_EXECUTE));
        aOpenProperties[3] = Utilities.createPropertyValue("UpdateDocMode", new Short(com.sun.star.document.UpdateDocMode.NO_UPDATE));
        aOpenProperties[4] = Utilities.createPropertyValue("InteractionHandler", xInitInteractionHandler);
        return moPDFDialog.mxComponentLoader.loadComponentFromURL(_sSourceUrl, "_default", 0, aOpenProperties);
    }catch(Exception exception){
        exception.printStackTrace(System.out);
        JOptionPane.showMessageDialog(moPDFDialog, "Beim Export ist ein Fehler aufgetreten!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);        
        return null;
    }
    catch (java.lang.OutOfMemoryError jMemoryError){
        jMemoryError.printStackTrace(System.out);
        JOptionPane.showMessageDialog(moPDFDialog, "Beim Export ist ein Fehler aufgetreten." +  (char)13 + "Wahrscheinlich steht nicht gengend Arbeitsspeicher zur Verfgung!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);        
        return null;        
    }}
    
    protected void storeAsPDFDocument(XComponent _xComponent, String _sTargetUrl){
    try{
        XStorable xStorable = (XStorable) UnoRuntime.queryInterface(XStorable.class, _xComponent);
        PropertyValue[] aStoreProperties = new PropertyValue[3];
        String sFilterName = getPDFFilterForApplication(_xComponent);
        aStoreProperties[0] = Utilities.createPropertyValue("FilterName", sFilterName);
        aStoreProperties[1] = Utilities.createPropertyValue("Overwrite", Boolean.TRUE);
        aStoreProperties[2] = Utilities.createPropertyValue("FilterData", aPDFFilterData);
        System.out.println("Dokument wird unter '" + _sTargetUrl + "' abgespeichert...");
        xStorable.storeToURL(_sTargetUrl, aStoreProperties);
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
        JOptionPane.showMessageDialog(moPDFDialog, "Beim Export ist ein Fehler aufgetreten!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);
    }}
        
    
    protected String getPDFFilterForApplication(XComponent _xComponent){
    try{
        String sFilterName = "";
	Object oManager = moPDFDialog.mxMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.ModuleManager", moPDFDialog.mxComponentContext);
        XModuleManager xModuleManager = (XModuleManager) UnoRuntime.queryInterface(XModuleManager.class, oManager);
	String sApplication = xModuleManager.identify(_xComponent);
	if (sApplication.equals("")){
            // msgbox "Die Komponente konnte keiner Applikation zugeordnet werden!";
            return "";
        }
	XContainerQuery xFilterContainerQuery = (XContainerQuery) UnoRuntime.queryInterface(XContainerQuery.class, moPDFDialog.mxMultiComponentFactory.createInstanceWithContext("com.sun.star.document.FilterFactory", moPDFDialog.mxComponentContext));
	NamedValue[] aQuery = new com.sun.star.beans.NamedValue[2];
        aQuery[0] = Utilities.createNamedValue("Type", "pdf_Portable_Document_Format");
        aQuery[1] = Utilities.createNamedValue("DocumentService", sApplication);
	XEnumeration xEnumeration  = xFilterContainerQuery.createSubSetEnumerationByProperties(aQuery);
	if (xEnumeration.hasMoreElements()){
            Object oElement = xEnumeration.nextElement();
            PropertyValue[] oFilters = (PropertyValue[]) AnyConverter.toArray(oElement);
            sFilterName = extractFilterProp(oFilters, "Name");
        }
	return sFilterName;
    }catch(Exception exception){
        exception.printStackTrace(System.out);
        JOptionPane.showMessageDialog(moPDFDialog, "Beim Export ist ein Fehler aufgetreten!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);                
        return "";
    }}

        
    protected String extractFilterProp(PropertyValue[] _filter, String _sProp){
    try{
        for (int i = 0; i < _filter.length; i++){
            if (_filter[i].Name.equals(_sProp)){
                return AnyConverter.toString(_filter[i].Value);
            }
        }
    }catch(Exception exception){
        exception.printStackTrace(System.out);
    }
        return "";
    }
}
