#include "ExchangeRateReader.h"
#include <QDomDocument>
#include <QDomElement>
#include <QDomNode>
#include <QProgressDialog>

ExchangeRateReader::ExchangeRateReader() : mFile( "ExchangeRatesXXXXXX" ), mProgressDialog( 0 )
{
    QObject::connect( &mParserThread, SIGNAL( ratesParsed() ),
                      this, SIGNAL( ratesParsed() ),
                      Qt::QueuedConnection );

    if( mFile.open() ) {
        mProgressDialog = new QProgressDialog( 0, Qt::WindowStaysOnTopHint );
        mProgressDialog->setWindowTitle( tr( "Downloading exchange rates" ) );
        mProgressDialog->setLabelText( tr( "Downloading exchange rates" ) );
        mProgressDialog->setCancelButton( 0 );

        QObject::connect( &mHttp, SIGNAL( done( bool ) ), this, SLOT( slotDownloadDone( bool ) ) );
        QObject::connect( &mHttp, SIGNAL( dataReadProgress( int, int ) ),
                          this, SLOT( slotReadProgress( int, int ) ) );
        mHttp.setHost( "www.ecb.int" );
        mHttp.get( "/stats/eurofxref/eurofxref-hist.xml", &mFile );
    }
}


void ExchangeRateReader::slotReadProgress( int done, int total )
{
    mProgressDialog->setMaximum( total );
    mProgressDialog->setValue( done );
}


void ExchangeRateReader::slotDownloadDone( bool error )
{
    delete mProgressDialog;
    if( !error ) {
        // Herunterladen der XML-Daten korrekt ausgeführt
        mFile.seek( 0 );
        mParserThread.setDevice( &mFile );
        mParserThread.setExchangeRates( &mExchangeRates );
        mParserThread.start();
    }
};

